/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ArrayUtilRt;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ReferenceEditorComboWithBrowseButton
extends ComponentWithBrowseButton<EditorComboBox>
implements TextAccessor {
    public ReferenceEditorComboWithBrowseButton(ActionListener browseActionListener, String text2, @NotNull Project project, boolean toAcceptClasses, String recentsKey) {
        this(browseActionListener, text2, project, toAcceptClasses, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE, recentsKey);
    }

    public ReferenceEditorComboWithBrowseButton(ActionListener browseActionListener, String text2, @NotNull Project project, boolean toAcceptClasses, JavaCodeFragment.VisibilityChecker visibilityChecker, String recentsKey) {
        super((JComponent)new EditorComboBox(JavaReferenceEditorUtil.createDocument(StringUtil.isEmpty((String)text2) ? "" : text2, project, toAcceptClasses, visibilityChecker), project, (FileType)JavaFileType.INSTANCE), browseActionListener);
        List recentEntries = RecentsManager.getInstance((Project)project).getRecentEntries(recentsKey);
        if (recentEntries != null) {
            this.setHistory(ArrayUtilRt.toStringArray((Collection)recentEntries));
        }
        if (text2 != null && text2.length() > 0) {
            this.prependItem(text2);
        } else if (text2 != null) {
            ((EditorComboBox)this.getChildComponent()).setSelectedItem(null);
        }
    }

    public String getText() {
        return ((EditorComboBox)this.getChildComponent()).getText().trim();
    }

    public void setText(String text2) {
        ((EditorComboBox)this.getChildComponent()).setText(text2);
    }

    public boolean isEditable() {
        return !((EditorComboBox)this.getChildComponent()).getEditorEx().isViewer();
    }

    public void setHistory(String[] history) {
        ((EditorComboBox)this.getChildComponent()).setHistory(history);
    }

    public void prependItem(String item) {
        ((EditorComboBox)this.getChildComponent()).prependItem(item);
    }

    public void appendItem(String item) {
        ((EditorComboBox)this.getChildComponent()).appendItem(item);
    }
}

