/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.iterators;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.structuralsearch.impl.matcher.MatchUtils;
import com.intellij.util.SmartList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HierarchyNodeIterator
extends NodeIterator {
    private int index;
    private final List<PsiElement> remaining = new SmartList();
    private boolean objectTaken;
    private boolean firstElementTaken;
    private final boolean acceptClasses;
    private final boolean acceptInterfaces;
    private final boolean acceptFirstElement;

    private void build(PsiElement current, Set<PsiElement> visited) {
        PsiElement element;
        String text2;
        if (current == null) {
            return;
        }
        String string = text2 = current instanceof PsiClass ? ((PsiClass)current).getName() : current.getText();
        if (MatchUtils.compareWithNoDifferenceToPackage((String)text2, (String)"Object")) {
            if (this.objectTaken) {
                return;
            }
            this.objectTaken = true;
        }
        PsiElement psiElement = element = current instanceof PsiReference ? ((PsiReference)current).resolve() : current;
        if (element instanceof PsiClass) {
            if (visited.contains(element)) {
                return;
            }
            PsiClass clazz = (PsiClass)element;
            if (this.acceptInterfaces || !clazz.isInterface()) {
                visited.add(element);
            }
            if (this.firstElementTaken || this.acceptFirstElement) {
                this.remaining.add((PsiElement)clazz);
            }
            this.firstElementTaken = true;
            if (clazz instanceof PsiAnonymousClass) {
                this.build((PsiElement)((PsiAnonymousClass)clazz).getBaseClassReference(), visited);
                return;
            }
            if (this.acceptClasses) {
                this.processClasses(clazz.getExtendsList(), visited);
                if (!this.objectTaken) {
                    this.build((PsiElement)PsiClassImplUtil.getSuperClass(clazz), visited);
                }
            }
            if (this.acceptInterfaces) {
                this.processClasses(clazz.getImplementsList(), visited);
                if (!this.acceptClasses) {
                    this.processClasses(clazz.getExtendsList(), visited);
                }
            }
        } else {
            this.remaining.add(current);
        }
    }

    private void processClasses(PsiReferenceList referenceList, Set<PsiElement> visited) {
        if (referenceList == null) {
            return;
        }
        for (PsiJavaCodeReferenceElement referenceElement : referenceList.getReferenceElements()) {
            this.build((PsiElement)referenceElement, visited);
        }
    }

    public HierarchyNodeIterator(PsiElement reference, boolean acceptClasses, boolean acceptInterfaces) {
        this(reference, acceptClasses, acceptInterfaces, true);
    }

    public HierarchyNodeIterator(PsiElement reference, boolean acceptClasses, boolean acceptInterfaces, boolean acceptFirstElement) {
        this.acceptClasses = acceptClasses;
        this.acceptInterfaces = acceptInterfaces;
        this.acceptFirstElement = acceptFirstElement;
        this.build(reference, new HashSet<PsiElement>());
    }

    public boolean hasNext() {
        return this.index < this.remaining.size();
    }

    public PsiElement current() {
        return this.remaining.get(this.index);
    }

    public void advance() {
        if (this.index != this.remaining.size()) {
            ++this.index;
        }
    }

    public void rewind() {
        if (this.index > 0) {
            --this.index;
        }
    }

    public void reset() {
        this.index = 0;
    }
}

