/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.strategies.JavaMatchingStrategy;
import org.jetbrains.annotations.NotNull;

public class JavaCompiledPattern
extends CompiledPattern {
    public static final String TYPED_VAR_PREFIX = "__$_";
    private boolean requestsSuperFields;
    private boolean requestsSuperMethods;
    private boolean requestsSuperInners;

    public JavaCompiledPattern() {
        this.setStrategy(JavaMatchingStrategy.getInstance());
    }

    public String @NotNull [] getTypedVarPrefixes() {
        return new String[]{TYPED_VAR_PREFIX};
    }

    public boolean isTypedVar(@NotNull String str) {
        if (str.isEmpty()) {
            return false;
        }
        if (str.charAt(0) == '@') {
            return str.regionMatches(1, TYPED_VAR_PREFIX, 0, TYPED_VAR_PREFIX.length());
        }
        return str.startsWith(TYPED_VAR_PREFIX);
    }

    public boolean isToResetHandler(@NotNull PsiElement element) {
        return !(element instanceof PsiJavaToken) && (!(element instanceof PsiJavaCodeReferenceElement) || !(element.getParent() instanceof PsiAnnotation));
    }

    public boolean isRequestsSuperFields() {
        return this.requestsSuperFields;
    }

    public void setRequestsSuperFields(boolean requestsSuperFields) {
        this.requestsSuperFields = requestsSuperFields;
    }

    public boolean isRequestsSuperInners() {
        return this.requestsSuperInners;
    }

    public void setRequestsSuperInners(boolean requestsSuperInners) {
        this.requestsSuperInners = requestsSuperInners;
    }

    public boolean isRequestsSuperMethods() {
        return this.requestsSuperMethods;
    }

    public void setRequestsSuperMethods(boolean requestsSuperMethods) {
        this.requestsSuperMethods = requestsSuperMethods;
    }
}

