/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi;

import com.intellij.icons.AllIcons;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.spi.SPILanguage;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPIFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile {
    public static final SPIFileType INSTANCE = new SPIFileType();

    private SPIFileType() {
        super((Language)SPILanguage.INSTANCE);
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        VirtualFile gParent;
        VirtualFile parent = file.getParent();
        if (parent != null && Comparing.equal((CharSequence)"services", (CharSequence)parent.getNameSequence()) && (gParent = parent.getParent()) != null && Comparing.equal((CharSequence)"META-INF", (CharSequence)gParent.getNameSequence())) {
            String fileName = file.getName();
            return FileTypeRegistry.getInstance().getFileTypeByFileName(fileName) == FileTypes.UNKNOWN;
        }
        return false;
    }

    @NotNull
    public String getName() {
        return "SPI";
    }

    @NotNull
    public String getDescription() {
        return JavaBundle.message((String)"spi.file.type.description", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Text;
    }

    @Nullable
    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        return "UTF-8";
    }
}

