/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiMethod;
import com.intellij.spellchecker.NamedElementTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import org.jetbrains.annotations.NotNull;

public class MethodNameTokenizerJava
extends NamedElementTokenizer<PsiMethod> {
    @Override
    public void tokenize(@NotNull PsiMethod element, TokenConsumer consumer) {
        if (element.isConstructor()) {
            return;
        }
        PsiMethod[] methods = element.findDeepestSuperMethods();
        boolean isInSource = true;
        for (PsiMethod psiMethod : methods) {
            isInSource &= MethodNameTokenizerJava.isMethodDeclarationInSource(psiMethod);
        }
        if (isInSource) {
            super.tokenize(element, consumer);
        }
    }

    private static boolean isMethodDeclarationInSource(@NotNull PsiMethod psiMethod) {
        if (psiMethod.getContainingFile() == null) {
            return false;
        }
        VirtualFile virtualFile = psiMethod.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return ProjectRootManager.getInstance((Project)psiMethod.getProject()).getFileIndex().isInSource(virtualFile);
    }
}

