/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class LiteralExpressionTokenizer
extends EscapeSequenceTokenizer<PsiLiteralExpression> {
    public void tokenize(@NotNull PsiLiteralExpression expression2, TokenConsumer consumer) {
        String text2 = !ExpressionUtils.hasStringType((PsiExpression)expression2) ? null : (expression2.isTextBlock() ? expression2.getText() : PsiLiteralUtil.getStringLiteralContent((PsiLiteralExpression)expression2));
        if (StringUtil.isEmpty(text2) || text2.length() <= 2) {
            return;
        }
        if (InjectedLanguageManager.getInstance((Project)expression2.getProject()).getInjectedPsiFiles((PsiElement)expression2) != null) {
            return;
        }
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiModifierListOwner.class);
        if (listOwner != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)listOwner, (String)"org.jetbrains.annotations.NonNls", (int)2)) {
            PsiElement targetElement = LiteralExpressionTokenizer.getCompleteStringValueExpression((PsiExpression)expression2);
            if (listOwner instanceof PsiMethod ? Arrays.stream(PsiUtil.findReturnStatements((PsiMethod)((PsiMethod)listOwner))).map(s -> s.getReturnValue()).anyMatch(e -> e == targetElement) : listOwner instanceof PsiVariable && ((PsiVariable)listOwner).getInitializer() == targetElement) {
                return;
            }
        }
        if (!text2.contains("\\")) {
            consumer.consumeToken((PsiElement)expression2, (Splitter)PlainTextSplitter.getInstance());
        } else {
            LiteralExpressionTokenizer.processTextWithEscapeSequences(expression2, text2, consumer);
        }
    }

    public static void processTextWithEscapeSequences(PsiLiteralExpression element, String text2, TokenConsumer consumer) {
        StringBuilder unescapedText = new StringBuilder();
        int[] offsets = new int[text2.length() + 1];
        CodeInsightUtilCore.parseStringCharacters((String)text2, (StringBuilder)unescapedText, (int[])offsets);
        LiteralExpressionTokenizer.processTextWithOffsets((PsiElement)element, (TokenConsumer)consumer, (StringBuilder)unescapedText, (int[])offsets, (int)1);
    }

    public static PsiElement getCompleteStringValueExpression(PsiExpression expression2) {
        return ExpressionUtils.isStringConcatenationOperand(expression2) ? expression2.getParent() : expression2;
    }
}

