/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.JavaTargetElementEvaluator;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.slicer.AnalysisStartingPoint;
import com.intellij.slicer.JavaSliceBuilder;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.JavaValueFilter;
import com.intellij.slicer.SliceForwardUtil;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceValueFilter;
import com.intellij.slicer.StackFilter;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SliceUtil {
    SliceUtil() {
    }

    static boolean processUsagesFlownDownTo(@NotNull PsiElement expression2, @NotNull Processor<? super SliceUsage> processor2, @NotNull JavaSliceBuilder builder) {
        AnalysisStartingPoint analysis;
        DfType filterDfType;
        int parametersCount;
        PsiMethod method;
        PsiElement original = expression2 = JavaSliceUsage.simplify(expression2);
        if (expression2 instanceof PsiArrayAccessExpression) {
            expression2 = ((PsiArrayAccessExpression)expression2).getArrayExpression();
            builder = builder.incrementNesting();
        }
        PsiElement par = expression2.getParent();
        if (expression2 instanceof PsiExpressionList && par instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)par).resolveMethod()) != null && (parametersCount = method.getParameterList().getParametersCount()) != 0) {
            PsiExpression[] expressions2 = ((PsiExpressionList)expression2).getExpressions();
            if (builder.hasNesting()) {
                for (int i = parametersCount - 1; i < expressions2.length; ++i) {
                    PsiExpression arg = expressions2[i];
                    if (builder.decrementNesting().process((PsiElement)arg, processor2)) continue;
                    return false;
                }
            }
            return true;
        }
        boolean needToReportDeclaration = false;
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement element = SliceForwardUtil.complexify(expression2);
            if (element instanceof PsiExpression && PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)element))) {
                PsiExpression rightSide = ((PsiAssignmentExpression)element.getParent()).getRExpression();
                return rightSide == null || builder.process((PsiElement)rightSide, processor2);
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)expression2;
            JavaResolveResult result = ref.advancedResolve(false);
            builder = builder.withSubstitutor(result.getSubstitutor().putAll(builder.getSubstitutor()));
            PsiElement resolved = result.getElement();
            if (resolved instanceof PsiCompiledElement) {
                resolved = resolved.getNavigationElement();
            }
            if (resolved instanceof PsiMethod && expression2.getParent() instanceof PsiMethodCallExpression) {
                return SliceUtil.processUsagesFlownDownTo(expression2.getParent(), processor2, builder);
            }
            if (!(resolved instanceof PsiVariable)) {
                return true;
            }
            SliceUtil.addContainerReferences((PsiVariable)resolved, processor2, builder);
            needToReportDeclaration = true;
            if (resolved instanceof PsiField || StackFilter.getElementContext(resolved) != StackFilter.getElementContext(expression2)) {
                builder = builder.withFilter(JavaValueFilter::dropFrameFilter);
            }
            expression2 = resolved;
        }
        if (expression2 instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)expression2;
            Collection<PsiExpression> values = DfaUtil.getVariableValues(variable, original);
            PsiExpression initializer = variable.getInitializer();
            if (values.isEmpty() && initializer != null) {
                values = Collections.singletonList(initializer);
            }
            boolean initializerReported = false;
            if (values.isEmpty() && !(variable instanceof PsiParameter) && !needToReportDeclaration) {
                values = DfaPsiUtil.getVariableAssignmentsInFile(variable, false, variable.getContainingFile().getLastChild());
                initializerReported = !values.isEmpty();
            } else if (!values.isEmpty() && !(variable instanceof PsiParameter)) {
                needToReportDeclaration = false;
            }
            for (PsiExpression exp : values) {
                if (!builder.process((PsiElement)exp, processor2)) {
                    return false;
                }
                if (exp != initializer) continue;
                initializerReported = true;
            }
            if (!initializerReported && needToReportDeclaration) {
                return builder.process((PsiElement)variable, processor2);
            }
            if (variable instanceof PsiField) {
                return SliceUtil.processFieldUsages((PsiField)variable, builder.dropSyntheticField(), processor2);
            }
            if (variable instanceof PsiParameter) {
                return SliceUtil.processParameterUsages((PsiParameter)variable, builder.withFilter(f -> f.popFrame(variable.getProject())), processor2);
            }
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            Flow anno;
            PsiExpression returnedValue = JavaMethodContractUtil.findReturnedValue((PsiMethodCallExpression)expression2);
            if (returnedValue != null && !builder.process((PsiElement)returnedValue, processor2)) {
                return false;
            }
            PsiMethod method2 = ((PsiMethodCallExpression)expression2).resolveMethod();
            Flow flow = anno = method2 == null ? null : SliceUtil.isMethodFlowAnnotated(method2);
            if (anno != null) {
                PsiExpression qualifier;
                String target = anno.target();
                if (target.equals("This container (if the parameter was annotated) or the return value (if instance method was annotated)")) {
                    target = "The return value of this method";
                }
                if (target.equals("The return value of this method") && (qualifier = ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression()) != null) {
                    builder = builder.updateNesting(anno);
                    String source = anno.source();
                    if (source.equals("The method argument (if parameter was annotated) or this container (if instance method was annotated)")) {
                        source = "this";
                    }
                    String synthetic = StringUtil.trimStart((String)StringUtil.trimStart((String)source, (String)"this"), (String)".");
                    return SliceUtil.processUsagesFlownDownTo((PsiElement)qualifier, processor2, builder.withSyntheticField(synthetic));
                }
            }
            return SliceUtil.processMethodReturnValue((PsiMethodCallExpression)expression2, processor2, builder);
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2;
            PsiExpression thenE = conditional.getThenExpression();
            PsiExpression elseE = conditional.getElseExpression();
            if (thenE != null && !builder.process((PsiElement)thenE, processor2)) {
                return false;
            }
            if (elseE != null && !builder.process((PsiElement)elseE, processor2)) {
                return false;
            }
        }
        if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression2;
            IElementType tokenType = assignment.getOperationTokenType();
            PsiExpression rExpression = assignment.getRExpression();
            if (tokenType == JavaTokenType.EQ && rExpression != null) {
                return SliceUtil.processUsagesFlownDownTo((PsiElement)rExpression, processor2, builder);
            }
        }
        if ((filterDfType = builder.getFilter().getDfType()) != DfTypes.TOP && expression2 instanceof PsiExpression && (analysis = AnalysisStartingPoint.propagateThroughExpression(expression2, filterDfType)) != null) {
            return builder.withFilter(filter -> filter.withType(analysis.myDfType)).process((PsiElement)analysis.myAnchor, processor2);
        }
        if (builder.hasNesting()) {
            PsiElement initializer;
            Object object = initializer = expression2 instanceof PsiNewExpression ? ((PsiNewExpression)expression2).getArrayInitializer() : expression2;
            if (initializer instanceof PsiArrayInitializerExpression) {
                for (PsiExpression init : ((PsiArrayInitializerExpression)initializer).getInitializers()) {
                    if (builder.decrementNesting().process((PsiElement)init, processor2)) continue;
                    return false;
                }
            }
            return !(expression2 instanceof PsiNewExpression) || SliceUtil.processContainerPutArguments((PsiCallExpression)((PsiNewExpression)expression2), builder, processor2);
        }
        return true;
    }

    private static Flow isMethodFlowAnnotated(@NotNull PsiMethod method) {
        return (Flow)AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Flow.class);
    }

    private static Flow isParamFlowAnnotated(@NotNull PsiMethod method, int paramIndex) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length <= paramIndex) {
            if (parameters2.length != 0 && parameters2[parameters2.length - 1].isVarArgs()) {
                paramIndex = parameters2.length - 1;
            } else {
                return null;
            }
        }
        return (Flow)AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)parameters2[paramIndex], Flow.class);
    }

    @NotNull
    static Collection<SliceUsage> collectMethodReturnValues(@NotNull SliceUsage parent, @NotNull PsiSubstitutor parentSubstitutor, PsiMethod methodCalled) {
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        SliceUtil.processMethodReturnValue((Processor<? super SliceUsage>)processor2, parentSubstitutor, null, methodCalled, null, JavaSliceBuilder.create(parent).withSubstitutor(PsiSubstitutor.EMPTY).dropSyntheticField());
        return processor2.getResults();
    }

    private static boolean processMethodReturnValue(@NotNull PsiMethodCallExpression methodCallExpr, @NotNull Processor<? super SliceUsage> processor2, @NotNull JavaSliceBuilder builder) {
        PsiClass qualifierClass = SliceUtil.resolveQualifier(methodCallExpr);
        JavaResolveResult resolved = methodCallExpr.resolveMethodGenerics();
        PsiElement r = resolved.getElement();
        if (r instanceof PsiCompiledElement) {
            r = r.getNavigationElement();
        }
        if (!(r instanceof PsiMethod)) {
            return true;
        }
        PsiMethod methodCalled = (PsiMethod)r;
        PsiType returnType = methodCalled.getReturnType();
        if (returnType == null) {
            return true;
        }
        PsiType parentType = builder.substitute(methodCallExpr.getType());
        PsiSubstitutor substitutor = resolved.getSubstitutor().putAll(builder.getSubstitutor());
        return SliceUtil.processMethodReturnValue(processor2, builder.getSubstitutor(), qualifierClass, methodCalled, parentType, builder.withSubstitutor(substitutor).dropSyntheticField().withFilter(JavaValueFilter::pushFrame));
    }

    private static boolean processMethodReturnValue(final @NotNull Processor<? super SliceUsage> processor2, @NotNull PsiSubstitutor parentSubstitutor, @Nullable PsiClass qualifierClass, PsiMethod methodCalled, final @Nullable PsiType parentType, final @NotNull JavaSliceBuilder builder) {
        THashSet overrides = new THashSet();
        SearchScope scope = builder.getSearchScope();
        if (qualifierClass != null && qualifierClass != methodCalled.getContainingClass()) {
            scope = JavaTargetElementEvaluator.getHierarchyScope(qualifierClass, scope);
        }
        overrides.addAll(OverridingMethodsSearch.search((PsiMethod)methodCalled, (SearchScope)scope, (boolean)true).findAll());
        overrides.add(methodCalled);
        final boolean[] result = new boolean[]{true};
        for (PsiMethod override : overrides) {
            if (!result[0]) break;
            if (override instanceof PsiCompiledElement) {
                override = (PsiMethod)override.getNavigationElement();
            }
            if (!builder.getParent().getScope().contains((PsiElement)PsiUtil.preferCompiledElement((PsiModifierListOwner)override))) continue;
            Language language = override.getLanguage();
            if (language != JavaLanguage.INSTANCE) {
                builder.process((PsiElement)override, processor2);
                continue;
            }
            PsiCodeBlock body2 = override.getBody();
            if (body2 == null) continue;
            PsiSubstitutor origSubstitutor = builder.getSubstitutor();
            PsiSubstitutor s = methodCalled == override ? origSubstitutor : MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodCalled.getSignature(origSubstitutor), (MethodSignature)override.getSignature(origSubstitutor));
            final PsiSubstitutor superSubstitutor = s == null ? parentSubstitutor : s;
            body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitClass(PsiClass aClass) {
                }

                public void visitLambdaExpression(PsiLambdaExpression expression2) {
                }

                public void visitReturnStatement(PsiReturnStatement statement) {
                    PsiExpression returnValue = statement.getReturnValue();
                    if (returnValue == null) {
                        return;
                    }
                    PsiType right = superSubstitutor.substitute(superSubstitutor.substitute(returnValue.getType()));
                    if (right == null || parentType != null && !TypeConversionUtil.isAssignable((PsiType)parentType, (PsiType)right)) {
                        return;
                    }
                    if (!builder.process((PsiElement)returnValue, (Processor<? super SliceUsage>)processor2)) {
                        this.stopWalking();
                        result[0] = false;
                    }
                }
            });
        }
        return result[0];
    }

    private static PsiClass resolveQualifier(@NotNull PsiMethodCallExpression expr2) {
        PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(expr2.getMethodExpression());
        if (qualifier == null) {
            return null;
        }
        PsiType psiType = null;
        CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(qualifier);
        if (result != null) {
            psiType = TypeConstraint.fromDfType(result.getDfTypeNoAssertions(qualifier)).getPsiType(qualifier.getProject());
        }
        if (psiType == null) {
            psiType = qualifier.getType();
        }
        return PsiUtil.resolveClassInClassTypeOnly(psiType);
    }

    private static boolean processFieldUsages(@NotNull PsiField field, @NotNull JavaSliceBuilder builder, @NotNull Processor<? super SliceUsage> processor2) {
        PsiExpression initializer;
        if (field.hasInitializer() && (initializer = field.getInitializer()) != null && !(field instanceof PsiCompiledElement) && !builder.process((PsiElement)initializer, processor2)) {
            return false;
        }
        AnalysisScope scope = builder.getParent().getScope();
        SearchScope searchScope = builder.getSearchScope();
        return ReferencesSearch.search((PsiElement)field, (SearchScope)searchScope).forEach(reference -> {
            ProgressManager.checkCanceled();
            PsiElement element = reference.getElement();
            if (element instanceof PsiCompiledElement && !scope.contains(element = element.getNavigationElement())) {
                return true;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiExpression rExpression;
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement parentExpr = referenceExpression.getParent();
                if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)referenceExpression) && (rExpression = ((PsiAssignmentExpression)parentExpr).getRExpression()) != null) {
                    PsiType rType = rExpression.getType();
                    PsiType fType = field.getType();
                    PsiType subFType = builder.substitute(fType);
                    PsiType subRType = builder.substitute(rType);
                    if (subFType != null && subRType != null && TypeConversionUtil.isAssignable((PsiType)subFType, (PsiType)subRType)) {
                        return builder.process((PsiElement)rExpression, processor2);
                    }
                }
                if (parentExpr instanceof PsiUnaryExpression && ((PsiUnaryExpression)parentExpr).getOperand() == referenceExpression && (((PsiUnaryExpression)parentExpr).getOperationTokenType() == JavaTokenType.PLUSPLUS || ((PsiUnaryExpression)parentExpr).getOperationTokenType() == JavaTokenType.MINUSMINUS)) {
                    PsiUnaryExpression unaryExpression = (PsiUnaryExpression)parentExpr;
                    return builder.process((PsiElement)unaryExpression, processor2);
                }
            }
            return SliceUtil.processIfInForeignLanguage(builder.dropNesting(), processor2, element);
        });
    }

    private static boolean processParameterUsages(@NotNull PsiParameter parameter2, @NotNull JavaSliceBuilder builder, @NotNull Processor<? super SliceUsage> processor2) {
        PsiElement declarationScope = parameter2.getDeclarationScope();
        if (declarationScope instanceof PsiForeachStatement) {
            PsiForeachStatement statement = (PsiForeachStatement)declarationScope;
            PsiExpression iterated = statement.getIteratedValue();
            return statement.getIterationParameter() != parameter2 || iterated == null || builder.incrementNesting().process((PsiElement)iterated, processor2);
        }
        if (!(declarationScope instanceof PsiMethod)) {
            return true;
        }
        PsiMethod method = (PsiMethod)declarationScope;
        PsiType actualParameterType = parameter2.getType();
        Object[] actualParameters = method.getParameterList().getParameters();
        int paramSeqNo = ArrayUtilRt.find((Object[])actualParameters, (Object)parameter2);
        assert (paramSeqNo != -1);
        SliceUsage specificMethodCall = SliceUtil.findSpecificMethodCallUpTheTree(builder.getParent(), method);
        if (specificMethodCall != null) {
            SliceValueFilter filter = specificMethodCall.params.valueFilter;
            return SliceUtil.processMethodCall(builder.withFilter(f -> f.copyStackFrom(filter)), processor2, actualParameterType, (PsiParameter[])actualParameters, paramSeqNo, specificMethodCall.getElement());
        }
        Set superMethods = ContainerUtil.set((Object[])method.findDeepestSuperMethods());
        superMethods.add(method);
        THashSet processed = new THashSet();
        for (PsiMethod superMethod : superMethods) {
            if (MethodReferencesSearch.search((PsiMethod)superMethod, (SearchScope)builder.getSearchScope(), (boolean)true).forEach(arg_0 -> SliceUtil.lambda$processParameterUsages$4((Set)processed, builder, processor2, actualParameterType, (PsiParameter[])actualParameters, paramSeqNo, arg_0))) continue;
            return false;
        }
        return true;
    }

    private static SliceUsage findSpecificMethodCallUpTheTree(SliceUsage parent, PsiMethod method) {
        while (parent != null) {
            PsiElement element = parent.getElement();
            if (element instanceof PsiCall && method.getManager().areElementsEquivalent((PsiElement)((PsiCall)element).resolveMethod(), (PsiElement)method)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static boolean processMethodCall(@NotNull JavaSliceBuilder builder, @NotNull Processor<? super SliceUsage> processor2, PsiType actualParameterType, PsiParameter[] actualParameters, int paramSeqNo, PsiElement refElement) {
        PsiType typeToCheck;
        PsiType actualExpressionType;
        PsiExpressionList passExpression;
        JavaResolveResult result;
        PsiExpressionList argumentList;
        if (refElement instanceof PsiCall) {
            PsiCall call = (PsiCall)refElement;
            argumentList = call.getArgumentList();
            result = call.resolveMethodGenerics();
        } else {
            PsiElement element = refElement.getParent();
            if (element instanceof PsiCompiledElement) {
                return true;
            }
            if (element instanceof PsiAnonymousClass) {
                PsiAnonymousClass anon = (PsiAnonymousClass)element;
                argumentList = anon.getArgumentList();
                PsiElement callExp = element.getParent();
                if (!(callExp instanceof PsiCallExpression)) {
                    return true;
                }
                result = ((PsiCall)callExp).resolveMethodGenerics();
            } else if (element instanceof PsiCall) {
                PsiCall call = (PsiCall)element;
                argumentList = call.getArgumentList();
                result = call.resolveMethodGenerics();
            } else {
                return SliceUtil.processIfInForeignLanguage(builder, processor2, refElement);
            }
        }
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpression[] expressions2 = argumentList.getExpressions();
        if (paramSeqNo >= expressions2.length) {
            return true;
        }
        if (actualParameterType instanceof PsiEllipsisType) {
            passExpression = argumentList;
            actualExpressionType = expressions2[paramSeqNo].getType();
        } else {
            passExpression = expressions2[paramSeqNo];
            actualExpressionType = ((PsiExpression)passExpression).getType();
        }
        Project project = argumentList.getProject();
        PsiElement element = result.getElement();
        if (element instanceof PsiCompiledElement) {
            element = element.getNavigationElement();
        }
        if (element instanceof PsiTypeParameterListOwner && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)((PsiTypeParameterListOwner)element), (PsiSubstitutor)substitutor)) {
            PsiTypeParameter[] typeParameters = substitutor.getSubstitutionMap().keySet().toArray(PsiTypeParameter.EMPTY_ARRAY);
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)project).getResolveHelper();
            substitutor = resolveHelper.inferTypeArguments(typeParameters, actualParameters, expressions2, builder.getSubstitutor(), (PsiElement)argumentList, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
        }
        if ((builder = builder.combineSubstitutor(substitutor = SliceUtil.removeRawMappingsLeftFromResolve(substitutor), project)) == null) {
            return true;
        }
        PsiType substituted = builder.substitute(actualExpressionType);
        if (substituted instanceof PsiPrimitiveType) {
            PsiClassType boxedType = ((PsiPrimitiveType)substituted).getBoxedType((PsiElement)argumentList);
            Object object = substituted = boxedType != null ? boxedType : substituted;
        }
        if (substituted == null) {
            return true;
        }
        if (actualParameterType instanceof PsiEllipsisType) {
            if (TypeConversionUtil.areTypesConvertible((PsiType)substituted, (PsiType)actualParameterType)) {
                return builder.process((PsiElement)expressions2[paramSeqNo], processor2);
            }
            typeToCheck = ((PsiEllipsisType)actualParameterType).getComponentType();
        } else {
            typeToCheck = actualParameterType;
        }
        if (!TypeConversionUtil.areTypesConvertible((PsiType)substituted, (PsiType)typeToCheck)) {
            return true;
        }
        return builder.process((PsiElement)passExpression, processor2);
    }

    private static boolean processIfInForeignLanguage(@NotNull JavaSliceBuilder builder, @NotNull Processor<? super SliceUsage> processor2, @NotNull PsiElement foreignElement) {
        PsiFile file = foreignElement.getContainingFile();
        if (file != null && file.getLanguage() != JavaLanguage.INSTANCE) {
            return builder.process(foreignElement, processor2);
        }
        return true;
    }

    private static void addContainerReferences(@NotNull PsiVariable variable, @NotNull Processor<? super SliceUsage> processor2, @NotNull JavaSliceBuilder builder) {
        if (builder.hasNesting()) {
            ReferencesSearch.search((PsiElement)variable).forEach(reference -> {
                PsiElement element = reference.getElement();
                if (element instanceof PsiExpression && !element.getManager().areElementsEquivalent(element, builder.getParent().getElement())) {
                    PsiExpression expression2 = (PsiExpression)element;
                    return SliceUtil.addContainerItemModification(expression2, processor2, builder);
                }
                return true;
            });
        }
    }

    private static boolean addContainerItemModification(@NotNull PsiExpression expression2, @NotNull Processor<? super SliceUsage> processor2, @NotNull JavaSliceBuilder builder) {
        PsiElement grand;
        PsiElement parentElement = expression2.getParent();
        if (parentElement instanceof PsiArrayAccessExpression && ((PsiArrayAccessExpression)parentElement).getArrayExpression() == expression2 && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)parentElement)) && PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)parentElement))) {
            PsiExpression rightSide = ((PsiAssignmentExpression)parentElement.getParent()).getRExpression();
            return rightSide == null || builder.decrementNesting().process((PsiElement)rightSide, processor2);
        }
        PsiElement psiElement = grand = parentElement == null ? null : parentElement.getParent();
        if (grand instanceof PsiCallExpression) {
            return SliceUtil.processContainerPutArguments((PsiCallExpression)grand, builder, processor2);
        }
        return true;
    }

    private static boolean processContainerPutArguments(@NotNull PsiCallExpression call, @NotNull JavaSliceBuilder builder, @NotNull Processor<? super SliceUsage> processor2) {
        assert (builder.hasNesting());
        JavaResolveResult result = call.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        if (method != null) {
            int parametersCount = method.getParameterList().getParametersCount();
            Flow[] annotations = new Flow[parametersCount];
            for (int i = 0; i < parametersCount; ++i) {
                annotations[i] = SliceUtil.isParamFlowAnnotated(method, i);
            }
            PsiExpression[] expressions2 = call.getArgumentList().getExpressions();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            for (int i = 0; i < expressions2.length; ++i) {
                PsiParameter parameter2;
                Flow anno;
                PsiExpression argument = expressions2[i];
                if (i >= parameters2.length) {
                    if (parameters2.length == 0 || !parameters2[parameters2.length - 1].isVarArgs()) break;
                    anno = annotations[parameters2.length - 1];
                    parameter2 = parameters2[parameters2.length - 1];
                } else {
                    anno = annotations[i];
                    parameter2 = parameters2[i];
                }
                if (anno != null) {
                    JavaSliceBuilder combined;
                    String paramSynthetic;
                    String target = anno.target();
                    if (target.equals("This container (if the parameter was annotated) or the return value (if instance method was annotated)")) {
                        target = "this";
                    }
                    if (target.startsWith("this") && (paramSynthetic = StringUtil.trimStart((String)StringUtil.trimStart((String)target, (String)"this"), (String)".")).equals(builder.getSyntheticField()) && (combined = builder.updateNesting(anno).combineSubstitutor(result.getSubstitutor(), argument.getProject())) != null && !combined.process((PsiElement)argument, processor2)) {
                        return false;
                    }
                }
                for (int si = 0; si < annotations.length; ++si) {
                    Flow sourceAnno;
                    if (si == i || (sourceAnno = annotations[si]) == null || !sourceAnno.target().equals(parameter2.getName())) continue;
                    PsiExpression sourceArgument = expressions2[si];
                    JavaSliceBuilder combined = builder.updateNesting(sourceAnno).combineSubstitutor(result.getSubstitutor(), argument.getProject());
                    if (combined == null || combined.process((PsiElement)sourceArgument, processor2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    private static PsiSubstitutor removeRawMappingsLeftFromResolve(@NotNull PsiSubstitutor substitutor) {
        Map map2 = null;
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            if (entry.getValue() != null) continue;
            if (map2 == null) {
                map2 = new THashMap();
            }
            map2.put(entry.getKey(), entry.getValue());
        }
        if (map2 == null) {
            return substitutor;
        }
        THashMap newMap = new THashMap(substitutor.getSubstitutionMap());
        newMap.keySet().removeAll(map2.keySet());
        return PsiSubstitutor.createSubstitutor((Map)newMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ boolean lambda$processParameterUsages$4(Set processed, JavaSliceBuilder builder, Processor processor2, PsiType actualParameterType, PsiParameter[] actualParameters, int paramSeqNo, PsiReference reference) {
        ProgressManager.checkCanceled();
        Set set = processed;
        synchronized (set) {
            if (!processed.add(reference)) {
                return true;
            }
        }
        PsiElement refElement = reference.getElement();
        return SliceUtil.processMethodCall(builder, (Processor<? super SliceUsage>)processor2, actualParameterType, actualParameters, paramSeqNo, refElement);
    }
}

