/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilderListener;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.module.CloudApplicationConfiguration;
import com.intellij.remoteServer.impl.module.CloudModuleBuilderContribution;
import com.intellij.remoteServer.impl.module.CloudModuleBuilderContributionFactory;
import com.intellij.remoteServer.impl.module.CloudModuleWizardStep;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudModuleBuilder
extends JavaModuleBuilder {
    private RemoteServer<?> myAccount;
    private CloudApplicationConfiguration myApplicationConfiguration;
    private FrameworkSupportModelBase myFrameworkSupportModel;
    private final Map<ServerType<?>, CloudModuleBuilderContribution> myCloudType2Contribution = new HashMap();
    private Project myProject;

    public CloudModuleBuilder() {
        ModuleBuilder.ModuleConfigurationUpdater configurationUpdater = new ModuleBuilder.ModuleConfigurationUpdater(){

            public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                CloudModuleBuilder.this.preConfigureModule(module, rootModel);
            }
        };
        this.addModuleConfigurationUpdater(configurationUpdater);
        this.addListener(new ModuleBuilderListener(){

            public void moduleCreated(@NotNull Module module) {
                CloudModuleBuilder.this.configureModule(module);
            }
        });
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Icon getNodeIcon() {
        return AllIcons.General.Balloon;
    }

    public String getDescription() {
        return CloudBundle.message((String)"module.builder.description.java.module.of.paas.cloud.application", (Object[])new Object[0]);
    }

    public String getPresentableName() {
        return CloudBundle.message((String)"presentable.name.clouds", (Object[])new Object[0]);
    }

    public String getGroupName() {
        return "Clouds";
    }

    public String getParentGroup() {
        return "Java";
    }

    public int getWeight() {
        return 30;
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        return ModuleWizardStep.EMPTY_ARRAY;
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        this.myProject = context.getProject();
        return new CloudModuleWizardStep(this, this.myProject, parentDisposable);
    }

    public void setAccount(RemoteServer<?> account) {
        this.myAccount = account;
    }

    public RemoteServer<?> getAccount() {
        return this.myAccount;
    }

    public void setApplicationConfiguration(CloudApplicationConfiguration applicationConfiguration) {
        this.myApplicationConfiguration = applicationConfiguration;
    }

    public CloudApplicationConfiguration getApplicationConfiguration() {
        return this.myApplicationConfiguration;
    }

    public CloudModuleBuilderContribution getContribution(ServerType<?> cloudType) {
        CloudModuleBuilderContribution result = this.myCloudType2Contribution.get(cloudType);
        if (result == null) {
            result = CloudModuleBuilderContributionFactory.getInstanceByType(cloudType).createContribution(this);
            this.myCloudType2Contribution.put(cloudType, result);
        }
        return result;
    }

    private CloudModuleBuilderContribution getContribution() {
        return this.getContribution(this.myAccount.getType());
    }

    private void preConfigureModule(Module module, ModifiableRootModel model) {
        this.getContribution().preConfigureModule(module, model);
    }

    private void configureModule(Module module) {
        this.getContribution().configureModule(module);
    }

    public FrameworkSupportModelBase getFrameworkSupportModel() {
        if (this.myFrameworkSupportModel == null) {
            LibrariesContainer librariesContainer = LibrariesContainerFactory.createContainer(this.myProject);
            this.myFrameworkSupportModel = new FrameworkSupportModelBase(this.myProject, (ModuleBuilder)this, librariesContainer){

                @Override
                @NotNull
                public String getBaseDirectoryForLibrariesPath() {
                    return StringUtil.notNullize((String)CloudModuleBuilder.this.getContentEntryPath());
                }
            };
        }
        return this.myFrameworkSupportModel;
    }

    public boolean isAvailable() {
        return ((CloudModuleBuilderContributionFactory[])CloudModuleBuilderContributionFactory.EP_NAME.getExtensions()).length > 0;
    }
}

