/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.JavaDeploymentSourceUtil;
import com.intellij.remoteServer.impl.configuration.deployment.ArtifactDeploymentSourceImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaDeploymentSourceUtilImpl
extends JavaDeploymentSourceUtil {
    @NotNull
    public ArtifactDeploymentSource createArtifactDeploymentSource(@NotNull ArtifactPointer artifactPointer) {
        return new ArtifactDeploymentSourceImpl(artifactPointer);
    }

    @NotNull
    public List<DeploymentSource> createArtifactDeploymentSources(@NotNull Project project, @NotNull Collection<? extends Artifact> artifacts) {
        ArrayList<DeploymentSource> sources = new ArrayList<DeploymentSource>();
        ArtifactPointerManager pointerManager = ArtifactPointerManager.getInstance((Project)project);
        for (Artifact artifact : artifacts) {
            sources.add((DeploymentSource)this.createArtifactDeploymentSource(pointerManager.createPointer(artifact)));
        }
        return sources;
    }

    @NotNull
    public List<DeploymentSource> createArtifactDeploymentSources(Project project, ArtifactType ... artifactTypes) {
        if (project.isDefault()) {
            return Collections.emptyList();
        }
        Artifact[] artifacts = ArtifactManager.getInstance((Project)project).getArtifacts();
        ArrayList<Artifact> supportedArtifacts = new ArrayList<Artifact>();
        Set typeSet = ContainerUtil.set((Object[])artifactTypes);
        for (Artifact artifact : artifacts) {
            if (!typeSet.contains(artifact.getArtifactType())) continue;
            supportedArtifacts.add(artifact);
        }
        return this.createArtifactDeploymentSources(project, supportedArtifacts);
    }
}

