/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classRefs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.refactoring.util.classRefs.ClassReferenceVisitor;

public abstract class ClassReferenceScanner {
    protected PsiClass myClass;
    private PsiReference[] myReferences;

    public abstract PsiReference[] findReferences();

    public ClassReferenceScanner(PsiClass aClass) {
        this.myClass = aClass;
    }

    public void processReferences(ClassReferenceVisitor visitor2) {
        if (this.myReferences == null) {
            this.myReferences = this.findReferences();
        }
        for (PsiReference reference : this.myReferences) {
            this.processUsage(reference.getElement(), visitor2);
        }
    }

    private void processUsage(PsiElement ref, ClassReferenceVisitor visitor2) {
        if (ref instanceof PsiReferenceExpression) {
            visitor2.visitReferenceExpression((PsiReferenceExpression)ref);
            return;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiTypeElement) {
            PsiElement pparent = parent.getParent();
            while (pparent instanceof PsiTypeElement) {
                parent = pparent;
                pparent = parent.getParent();
            }
            ClassReferenceVisitor.TypeOccurence occurence = new ClassReferenceVisitor.TypeOccurence(ref, ((PsiTypeElement)parent).getType());
            if (pparent instanceof PsiLocalVariable) {
                visitor2.visitLocalVariableDeclaration((PsiLocalVariable)pparent, occurence);
            } else if (pparent instanceof PsiParameter) {
                PsiParameter parameter2 = (PsiParameter)pparent;
                visitor2.visitParameterDeclaration(parameter2, occurence);
            } else if (pparent instanceof PsiField) {
                visitor2.visitFieldDeclaration((PsiField)pparent, occurence);
            } else if (pparent instanceof PsiMethod) {
                visitor2.visitMethodReturnType((PsiMethod)pparent, occurence);
            } else if (pparent instanceof PsiTypeCastExpression) {
                visitor2.visitTypeCastExpression((PsiTypeCastExpression)pparent, occurence);
            }
        } else if (parent instanceof PsiNewExpression) {
            visitor2.visitNewExpression((PsiNewExpression)parent, new ClassReferenceVisitor.TypeOccurence(ref, ((PsiNewExpression)parent).getType()));
        } else {
            visitor2.visitOther(ref);
        }
    }
}

