/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeCook.deductive.resolver;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.Bottom;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVariable;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeCook.Util;
import com.intellij.refactoring.typeCook.deductive.PsiExtendedTypeVisitor;
import com.intellij.refactoring.typeCook.deductive.PsiTypeVariableFactory;
import com.intellij.refactoring.typeCook.deductive.builder.Constraint;
import com.intellij.refactoring.typeCook.deductive.builder.ReductionSystem;
import com.intellij.refactoring.typeCook.deductive.builder.Subtype;
import com.intellij.refactoring.typeCook.deductive.resolver.Binding;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BindingFactory {
    private static final Logger LOG = Logger.getInstance(BindingFactory.class);
    private final Set<PsiTypeVariable> myBoundVariables;
    private final Project myProject;
    private final PsiTypeVariableFactory myFactory;

    private static PsiClass[] getGreatestLowerClasses(PsiClass aClass, PsiClass bClass) {
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)bClass, (boolean)true)) {
            return new PsiClass[]{aClass};
        }
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)bClass, (PsiClass)aClass, (boolean)true)) {
            return new PsiClass[]{bClass};
        }
        LinkedHashSet descendants = new LinkedHashSet();
        new Object(){

            public void getGreatestLowerClasses(PsiClass aClass, PsiClass bClass, Set<? super PsiClass> descendants) {
                if (bClass.hasModifierProperty("final")) {
                    return;
                }
                if (aClass.isInheritor(bClass, true)) {
                    descendants.add((PsiClass)aClass);
                } else {
                    for (PsiClass bInheritor : ClassInheritorsSearch.search((PsiClass)bClass, (boolean)false)) {
                        this.getGreatestLowerClasses(bInheritor, aClass, descendants);
                    }
                }
            }
        }.getGreatestLowerClasses(aClass, bClass, descendants);
        return descendants.toArray(PsiClass.EMPTY_ARRAY);
    }

    public Binding balance(PsiType x, PsiType y, final Balancer balancer, final Set<? super Constraint> constraints) {
        int indicator = (x instanceof PsiTypeVariable ? 1 : 0) + (y instanceof PsiTypeVariable ? 2 : 0);
        switch (indicator) {
            case 0: {
                if (x instanceof PsiWildcardType || y instanceof PsiWildcardType) {
                    PsiType xType = x instanceof PsiWildcardType ? ((PsiWildcardType)x).getBound() : x;
                    PsiType yType = y instanceof PsiWildcardType ? ((PsiWildcardType)y).getBound() : y;
                    switch ((x instanceof PsiWildcardType ? 1 : 0) + (y instanceof PsiWildcardType ? 2 : 0)) {
                        case 1: {
                            if (((PsiWildcardType)x).isExtends()) {
                                return null;
                            }
                            if (xType != null && !"java.lang.Object".equals(xType.getCanonicalText())) {
                                return null;
                            }
                            return this.create();
                        }
                        case 2: {
                            if (((PsiWildcardType)y).isExtends()) {
                                if (yType instanceof PsiTypeVariable) {
                                    PsiTypeVariable beta = this.myFactory.create();
                                    if (constraints != null) {
                                        constraints.add(new Subtype(beta, yType));
                                        if (x != null) {
                                            constraints.add(new Subtype(x, yType));
                                        }
                                    }
                                    return this.create();
                                }
                                if (constraints != null && xType != null && yType != null) {
                                    constraints.add(new Subtype(xType, yType));
                                }
                                return this.balance(xType, yType, balancer, constraints);
                            }
                            if (yType instanceof PsiTypeVariable) {
                                PsiTypeVariable beta = this.myFactory.create();
                                if (constraints != null) {
                                    if (x != null) {
                                        constraints.add(new Subtype(x, beta));
                                    }
                                    constraints.add(new Subtype(yType, beta));
                                }
                                return this.create();
                            }
                            if (constraints != null && yType != null && xType != null) {
                                constraints.add(new Subtype(yType, xType));
                            }
                            return this.balance(xType, yType, balancer, constraints);
                        }
                        case 3: {
                            switch ((((PsiWildcardType)x).isExtends() ? 0 : 1) + (((PsiWildcardType)y).isExtends() ? 0 : 2)) {
                                case 0: {
                                    if (constraints != null && xType != null && yType != null) {
                                        constraints.add(new Subtype(yType, xType));
                                    }
                                    return this.balance(xType, yType, balancer, constraints);
                                }
                                case 1: {
                                    if (constraints != null && xType != null && yType != null) {
                                        constraints.add(new Subtype(xType, yType));
                                    }
                                    return this.balance(xType, yType, balancer, constraints);
                                }
                                case 2: {
                                    return null;
                                }
                                case 3: {
                                    if (constraints != null && xType != null && yType != null) {
                                        constraints.add(new Subtype(xType, yType));
                                    }
                                    return this.balance(xType, yType, balancer, constraints);
                                }
                            }
                        }
                    }
                    return this.create();
                }
                if (x instanceof PsiArrayType || y instanceof PsiArrayType) {
                    PsiType xType = x instanceof PsiArrayType ? ((PsiArrayType)x).getComponentType() : x;
                    PsiType yType = y instanceof PsiArrayType ? ((PsiArrayType)y).getComponentType() : y;
                    return this.balance(xType, yType, balancer, constraints);
                }
                if (x instanceof PsiClassType && y instanceof PsiClassType) {
                    PsiClassType.ClassResolveResult resultX = Util.resolveType(x);
                    PsiClassType.ClassResolveResult resultY = Util.resolveType(y);
                    PsiClass xClass = resultX.getElement();
                    PsiClass yClass = resultY.getElement();
                    if (xClass == null || yClass == null) break;
                    PsiSubstitutor ySubst = resultY.getSubstitutor();
                    PsiSubstitutor xSubst = TypeConversionUtil.getClassSubstitutor((PsiClass)yClass, (PsiClass)xClass, (PsiSubstitutor)resultX.getSubstitutor());
                    if (xSubst == null) {
                        return null;
                    }
                    Binding b = this.create();
                    for (PsiTypeParameter aParm : xSubst.getSubstitutionMap().keySet()) {
                        PsiType yType;
                        PsiType xType = xSubst.substitute(aParm);
                        Binding b1 = this.unify(xType, yType = ySubst.substitute(aParm), new Unifier(){

                            @Override
                            public Binding unify(PsiType x, PsiType y) {
                                return BindingFactory.this.balance(x, y, balancer, constraints);
                            }
                        });
                        if (b1 == null) {
                            return null;
                        }
                        b = b.compose(b1);
                    }
                    return b;
                }
                if (y instanceof Bottom) {
                    return this.create();
                }
                return null;
            }
            case 1: {
                return balancer.varType((PsiTypeVariable)x, y);
            }
            case 2: {
                return balancer.typeVar(x, (PsiTypeVariable)y);
            }
            case 3: {
                return balancer.varVar((PsiTypeVariable)x, (PsiTypeVariable)y);
            }
        }
        return null;
    }

    private Binding unify(PsiType x, PsiType y, Unifier unifier) {
        int indicator = (x instanceof PsiTypeVariable ? 1 : 0) + (y instanceof PsiTypeVariable ? 2 : 0);
        if (indicator == 0) {
            if (x instanceof PsiWildcardType || y instanceof PsiWildcardType) {
                return unifier.unify(x, y);
            }
            if (x instanceof PsiArrayType || y instanceof PsiArrayType) {
                PsiType xType = x instanceof PsiArrayType ? ((PsiArrayType)x).getComponentType() : x;
                PsiType yType = y instanceof PsiArrayType ? ((PsiArrayType)y).getComponentType() : y;
                return this.unify(xType, yType, unifier);
            }
            if (x instanceof PsiClassType && y instanceof PsiClassType) {
                PsiClassType.ClassResolveResult resultX = Util.resolveType(x);
                PsiClassType.ClassResolveResult resultY = Util.resolveType(y);
                PsiClass xClass = resultX.getElement();
                PsiClass yClass = resultY.getElement();
                if (xClass != null && yClass != null) {
                    PsiSubstitutor ySubst = resultY.getSubstitutor();
                    PsiSubstitutor xSubst = resultX.getSubstitutor();
                    if (!xClass.equals(yClass)) {
                        return null;
                    }
                    Binding b = this.create();
                    for (PsiTypeParameter aParm : xSubst.getSubstitutionMap().keySet()) {
                        PsiType yType;
                        PsiType xType = xSubst.substitute(aParm);
                        Binding b1 = this.unify(xType, yType = ySubst.substitute(aParm), unifier);
                        if (b1 == null) {
                            return null;
                        }
                        b = b.compose(b1);
                    }
                    return b;
                }
            } else {
                if (y instanceof Bottom) {
                    return this.create();
                }
                return null;
            }
        }
        return unifier.unify(x, y);
    }

    public Binding riseWithWildcard(PsiType x, PsiType y, final Set<? super Constraint> constraints) {
        Binding binding = this.balance(x, y, new Balancer(){

            @Override
            public Binding varType(PsiTypeVariable x, PsiType y) {
                if (y instanceof Bottom) {
                    return BindingFactory.this.create();
                }
                if (y == null || y instanceof PsiWildcardType) {
                    return null;
                }
                PsiTypeVariable var = BindingFactory.this.myFactory.create();
                Binding binding = BindingFactory.this.create(x, (PsiType)PsiWildcardType.createSuper((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (PsiType)var));
                binding.addTypeVariable(var);
                constraints.add(new Subtype(var, y));
                return binding;
            }

            @Override
            public Binding varVar(PsiTypeVariable x, PsiTypeVariable y) {
                int yi;
                int xi = x.getIndex();
                if (xi == (yi = y.getIndex())) {
                    return BindingFactory.this.create();
                }
                return BindingFactory.this.create(y, (PsiType)PsiWildcardType.createExtends((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (PsiType)x));
            }

            @Override
            public Binding typeVar(PsiType x, PsiTypeVariable y) {
                if (x == null) {
                    return BindingFactory.this.create(y, Bottom.BOTTOM);
                }
                if (x instanceof PsiWildcardType) {
                    return null;
                }
                PsiTypeVariable var = BindingFactory.this.myFactory.create();
                Binding binding = BindingFactory.this.create(y, (PsiType)PsiWildcardType.createExtends((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (PsiType)var));
                binding.addTypeVariable(var);
                constraints.add(new Subtype(x, var));
                return binding;
            }
        }, constraints);
        return binding != null ? binding.reduceRecursive() : null;
    }

    public Binding rise(PsiType x, PsiType y, Set<? super Constraint> constraints) {
        Binding binding = this.balance(x, y, new Balancer(){

            @Override
            public Binding varType(PsiTypeVariable x, PsiType y) {
                if (y instanceof Bottom || y instanceof PsiWildcardType) {
                    return BindingFactory.this.create();
                }
                return BindingFactory.this.create(x, y);
            }

            @Override
            public Binding varVar(PsiTypeVariable x, PsiTypeVariable y) {
                int yi;
                int xi = x.getIndex();
                if (xi < (yi = y.getIndex())) {
                    return BindingFactory.this.create(x, y);
                }
                if (yi < xi) {
                    return BindingFactory.this.create(y, x);
                }
                return BindingFactory.this.create();
            }

            @Override
            public Binding typeVar(PsiType x, PsiTypeVariable y) {
                if (x == null) {
                    return BindingFactory.this.create(y, Bottom.BOTTOM);
                }
                if (x instanceof PsiWildcardType) {
                    return BindingFactory.this.create();
                }
                return BindingFactory.this.create(y, x);
            }
        }, constraints);
        return binding != null ? binding.reduceRecursive() : null;
    }

    public Binding sink(PsiType x, PsiType y, Set<? super Constraint> constraints) {
        return this.balance(x, y, new Balancer(){

            @Override
            public Binding varType(PsiTypeVariable x, PsiType y) {
                return BindingFactory.this.create(x, y);
            }

            @Override
            public Binding varVar(PsiTypeVariable x, PsiTypeVariable y) {
                return BindingFactory.this.create(y, Bottom.BOTTOM);
            }

            @Override
            public Binding typeVar(PsiType x, PsiTypeVariable y) {
                return BindingFactory.this.create(y, Bottom.BOTTOM);
            }
        }, constraints);
    }

    public LinkedList<Pair<PsiType, Binding>> union(PsiType x, PsiType y) {
        LinkedList<Pair<PsiType, Binding>> list = new LinkedList<Pair<PsiType, Binding>>();
        new Object(){

            void union(PsiType x, PsiType y, LinkedList<? super Pair<PsiType, Binding>> list) {
                if (x instanceof PsiArrayType && y instanceof PsiArrayType) {
                    this.union(((PsiArrayType)x).getComponentType(), ((PsiArrayType)y).getComponentType(), list);
                } else if (x instanceof PsiClassType && y instanceof PsiClassType) {
                    PsiClassType.ClassResolveResult xResult = Util.resolveType(x);
                    PsiClassType.ClassResolveResult yResult = Util.resolveType(y);
                    PsiClass xClass = xResult.getElement();
                    PsiClass yClass = yResult.getElement();
                    PsiSubstitutor xSubst = xResult.getSubstitutor();
                    PsiSubstitutor ySubst = yResult.getSubstitutor();
                    if (xClass == null || yClass == null) {
                        return;
                    }
                    if (xClass.equals(yClass)) {
                        Binding risen = BindingFactory.this.rise(x, y, null);
                        if (risen == null) {
                            return;
                        }
                        list.addFirst((Pair<PsiType, Binding>)Pair.create((Object)risen.apply(x), (Object)risen));
                    } else {
                        PsiClass[] descendants;
                        for (PsiClass descendant : descendants = BindingFactory.getGreatestLowerClasses(xClass, yClass)) {
                            PsiSubstitutor x2aSubst = TypeConversionUtil.getClassSubstitutor((PsiClass)xClass, (PsiClass)descendant, (PsiSubstitutor)xSubst);
                            PsiSubstitutor y2aSubst = TypeConversionUtil.getClassSubstitutor((PsiClass)yClass, (PsiClass)descendant, (PsiSubstitutor)ySubst);
                            LOG.assertTrue(x2aSubst != null && y2aSubst != null);
                            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)xClass.getProject());
                            this.union((PsiType)factory.createType(descendant, x2aSubst), (PsiType)factory.createType(descendant, y2aSubst), list);
                        }
                    }
                }
            }
        }.union(x, y, list);
        return list;
    }

    public LinkedList<Pair<PsiType, Binding>> intersect(PsiType x, PsiType y) {
        LinkedList<Pair<PsiType, Binding>> list = new LinkedList<Pair<PsiType, Binding>>();
        new Object(){

            void intersect(PsiType x, PsiType y, LinkedList<? super Pair<PsiType, Binding>> list) {
                block12: {
                    block10: {
                        block11: {
                            if (x instanceof PsiWildcardType || y instanceof PsiWildcardType) {
                                PsiType xType = x instanceof PsiWildcardType ? ((PsiWildcardType)x).getBound() : x;
                                PsiType yType = y instanceof PsiWildcardType ? ((PsiWildcardType)y).getBound() : y;
                                this.intersect(xType, yType, list);
                            }
                            if (!(x instanceof PsiArrayType) && !(y instanceof PsiArrayType)) break block10;
                            if (!(x instanceof PsiClassType) && !(y instanceof PsiClassType)) break block11;
                            try {
                                PsiElementFactory f = JavaPsiFacade.getElementFactory((Project)BindingFactory.this.myProject);
                                PsiType keyType = x instanceof PsiClassType ? x : y;
                                PsiType object = f.createTypeFromText("java.lang.Object", null);
                                PsiType cloneable = f.createTypeFromText("java.lang.Cloneable", null);
                                PsiType serializable = f.createTypeFromText("java.io.Serializable", null);
                                this.intersect(keyType, object, list);
                                this.intersect(keyType, cloneable, list);
                                this.intersect(keyType, serializable, list);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error("Exception " + (Object)((Object)e));
                            }
                            break block12;
                        }
                        if (!(x instanceof PsiArrayType) || !(y instanceof PsiArrayType)) break block12;
                        this.intersect(((PsiArrayType)x).getComponentType(), ((PsiArrayType)y).getComponentType(), list);
                        break block12;
                    }
                    if (x instanceof PsiClassType && y instanceof PsiClassType) {
                        PsiClassType.ClassResolveResult xResult = Util.resolveType(x);
                        PsiClassType.ClassResolveResult yResult = Util.resolveType(y);
                        PsiClass xClass = xResult.getElement();
                        PsiClass yClass = yResult.getElement();
                        PsiSubstitutor xSubst = xResult.getSubstitutor();
                        PsiSubstitutor ySubst = yResult.getSubstitutor();
                        if (xClass == null || yClass == null) {
                            return;
                        }
                        if (xClass.equals(yClass)) {
                            Binding risen = BindingFactory.this.rise(x, y, null);
                            if (risen == null) {
                                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)xClass.getProject());
                                list.addFirst((Pair<PsiType, Binding>)Pair.create((Object)Util.banalize((PsiType)factory.createType(xClass, factory.createRawSubstitutor((PsiTypeParameterListOwner)xClass))), (Object)BindingFactory.this.create()));
                            } else {
                                list.addFirst((Pair<PsiType, Binding>)Pair.create((Object)risen.apply(x), (Object)risen));
                            }
                        } else {
                            PsiClass[] ancestors;
                            for (PsiClass ancestor : ancestors = GenericsUtil.getLeastUpperClasses((PsiClass)xClass, (PsiClass)yClass)) {
                                if ("java.lang.Object".equals(ancestor.getQualifiedName()) && ancestors.length > 1) continue;
                                PsiSubstitutor x2aSubst = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)ancestor, (PsiClass)xClass, (PsiSubstitutor)xSubst);
                                PsiSubstitutor y2aSubst = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)ancestor, (PsiClass)yClass, (PsiSubstitutor)ySubst);
                                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)xClass.getProject());
                                this.intersect((PsiType)factory.createType(ancestor, x2aSubst), (PsiType)factory.createType(ancestor, y2aSubst), list);
                            }
                        }
                    }
                }
            }
        }.intersect(x, y, list);
        return list;
    }

    public BindingFactory(ReductionSystem system) {
        this.myBoundVariables = system.getBoundVariables();
        this.myProject = system.getProject();
        this.myFactory = system.getVariableFactory();
    }

    public Binding create(PsiTypeVariable var, PsiType type2) {
        return new BindingImpl(var, type2);
    }

    public Binding create() {
        return new BindingImpl();
    }

    public Set<PsiTypeVariable> getBoundVariables() {
        return this.myBoundVariables;
    }

    static interface Unifier {
        public Binding unify(PsiType var1, PsiType var2);
    }

    static interface Balancer {
        public Binding varType(PsiTypeVariable var1, PsiType var2);

        public Binding varVar(PsiTypeVariable var1, PsiTypeVariable var2);

        public Binding typeVar(PsiType var1, PsiTypeVariable var2);
    }

    private class BindingImpl
    extends Binding {
        private final TIntObjectHashMap<PsiType> myBindings = new TIntObjectHashMap();
        private boolean myCyclic;

        BindingImpl(PsiTypeVariable var, PsiType type2) {
            this.myCyclic = type2 instanceof PsiTypeVariable;
            this.myBindings.put(var.getIndex(), (Object)type2);
        }

        BindingImpl(int index, PsiType type2) {
            Set<PsiTypeVariable> cluster;
            this.myCyclic = type2 instanceof PsiTypeVariable;
            this.myBindings.put(index, (Object)type2);
            if (type2 instanceof Bottom && (cluster = BindingFactory.this.myFactory.getClusterOf(index)) != null) {
                for (PsiTypeVariable var : cluster) {
                    this.myBindings.put(var.getIndex(), (Object)type2);
                }
            }
        }

        BindingImpl() {
            this.myCyclic = false;
        }

        @Override
        public PsiType apply(PsiType type2) {
            if (type2 instanceof PsiTypeVariable) {
                PsiType t = (PsiType)this.myBindings.get(((PsiTypeVariable)type2).getIndex());
                return t == null ? type2 : t;
            }
            if (type2 instanceof PsiArrayType) {
                return this.apply(((PsiArrayType)type2).getComponentType()).createArrayType();
            }
            if (type2 instanceof PsiClassType) {
                PsiClassType.ClassResolveResult result = Util.resolveType(type2);
                PsiClass theClass = result.getElement();
                PsiSubstitutor aSubst = result.getSubstitutor();
                PsiSubstitutor theSubst = PsiSubstitutor.EMPTY;
                if (theClass != null) {
                    for (PsiTypeParameter aParm : aSubst.getSubstitutionMap().keySet()) {
                        PsiType aType = aSubst.substitute(aParm);
                        theSubst = theSubst.put(aParm, this.apply(aType));
                    }
                    return JavaPsiFacade.getElementFactory((Project)theClass.getProject()).createType(theClass, theSubst);
                }
                return type2;
            }
            if (type2 instanceof PsiWildcardType) {
                PsiWildcardType wcType = (PsiWildcardType)type2;
                PsiType bound = wcType.getBound();
                if (bound != null) {
                    PsiType abound = this.apply(bound);
                    if (abound instanceof PsiWildcardType) {
                        return null;
                    }
                    return wcType.isExtends() ? PsiWildcardType.createExtends((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (PsiType)abound) : PsiWildcardType.createSuper((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (PsiType)abound);
                }
                return type2;
            }
            return type2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BindingImpl)) {
                return false;
            }
            BindingImpl binding = (BindingImpl)o;
            return this.myBindings.equals(binding.myBindings);
        }

        @Override
        public Binding compose(Binding b) {
            LOG.assertTrue(b instanceof BindingImpl);
            BindingImpl b1 = this;
            BindingImpl b2 = (BindingImpl)b;
            BindingImpl b3 = new BindingImpl();
            block6: for (PsiTypeVariable boundVariable : BindingFactory.this.myBoundVariables) {
                int i = boundVariable.getIndex();
                PsiType b1i = (PsiType)b1.myBindings.get(i);
                PsiType b2i = (PsiType)b2.myBindings.get(i);
                int flag = (b1i == null ? 0 : 1) + (b2i == null ? 0 : 2);
                switch (flag) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        PsiType type2 = b2.apply(b1i);
                        if (type2 == null) {
                            return null;
                        }
                        if (type2 == PsiType.NULL) continue block6;
                        b3.myBindings.put(i, (Object)type2);
                        b3.myCyclic = type2 instanceof PsiTypeVariable;
                        break;
                    }
                    case 2: {
                        PsiType type2 = b1.apply(b2i);
                        if (type2 == null) {
                            return null;
                        }
                        if (type2 == PsiType.NULL) continue block6;
                        b3.myBindings.put(i, (Object)type2);
                        b3.myCyclic = type2 instanceof PsiTypeVariable;
                        break;
                    }
                    case 3: {
                        Binding common = BindingFactory.this.rise(b1i, b2i, null);
                        if (common == null) {
                            return null;
                        }
                        PsiType type3 = common.apply(b1i);
                        if (type3 == null) {
                            return null;
                        }
                        if (type3 == PsiType.NULL) break;
                        b3.myBindings.put(i, (Object)type3);
                        b3.myCyclic = type3 instanceof PsiTypeVariable;
                    }
                }
            }
            return b3;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            for (PsiTypeVariable boundVariable : BindingFactory.this.myBoundVariables) {
                int i = boundVariable.getIndex();
                PsiType binding = (PsiType)this.myBindings.get(i);
                if (binding == null) continue;
                buffer.append("#").append(i).append(" -> ").append(binding.getPresentableText()).append("; ");
            }
            return buffer.toString();
        }

        private PsiType normalize(PsiType t) {
            if (t == null || t instanceof PsiTypeVariable) {
                return Bottom.BOTTOM;
            }
            if (t instanceof PsiWildcardType) {
                return ((PsiWildcardType)t).getBound();
            }
            return t;
        }

        @Override
        public int compare(Binding binding) {
            BindingImpl b2 = (BindingImpl)binding;
            BindingImpl b1 = this;
            int directoin = 3;
            boolean first = true;
            for (PsiTypeVariable boundVariable : BindingFactory.this.myBoundVariables) {
                PsiType y;
                int index = boundVariable.getIndex();
                PsiType x = this.normalize((PsiType)b1.myBindings.get(index));
                int comp = new Object(){

                    int compare(PsiType x, PsiType y) {
                        int kindY;
                        int[] kinds = new Object(){

                            private int classify(PsiType type2) {
                                if (type2 == null) {
                                    return 0;
                                }
                                if (type2 instanceof PsiPrimitiveType) {
                                    return 1;
                                }
                                if (type2 instanceof PsiArrayType) {
                                    return 2;
                                }
                                if (type2 instanceof PsiClassType) {
                                    return 3;
                                }
                                return 4;
                            }

                            int[] classify2(PsiType x, PsiType y) {
                                return new int[]{this.classify(x), this.classify(y)};
                            }
                        }.classify2(x, y);
                        int kindX = kinds[0];
                        if (kindX + (kindY = kinds[1]) == 0) {
                            return 2;
                        }
                        if (kindX * kindY == 0) {
                            if (kindX == 0) {
                                return 1;
                            }
                            return 0;
                        }
                        if (kindX * kindY == 1) {
                            if (x.equals(y)) {
                                return 2;
                            }
                            return 3;
                        }
                        if (kindX != kindY) {
                            if (kindX == 4) {
                                return 1;
                            }
                            if (kindY == 4) {
                                return 0;
                            }
                            if (kindX + kindY == 5) {
                                try {
                                    int flag;
                                    PsiType type2;
                                    PsiElementFactory f = JavaPsiFacade.getElementFactory((Project)BindingFactory.this.myProject);
                                    PsiType cloneable = f.createTypeFromText("java.lang.Cloneable", null);
                                    PsiType object = f.createTypeFromText("java.lang.Object", null);
                                    PsiType serializable = f.createTypeFromText("java.io.Serializable", null);
                                    if (kindX == 3) {
                                        type2 = x;
                                        flag = 1;
                                    } else {
                                        type2 = y;
                                        flag = 0;
                                    }
                                    if (type2.equals(object) || type2.equals(cloneable) || type2.equals(serializable)) {
                                        return flag;
                                    }
                                }
                                catch (IncorrectOperationException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                            return 3;
                        }
                        if (kindX == 2) {
                            return this.compare(((PsiArrayType)x).getComponentType(), ((PsiArrayType)y).getComponentType());
                        }
                        if (x.equals(y)) {
                            return 2;
                        }
                        PsiClassType.ClassResolveResult resultX = Util.resolveType(x);
                        PsiClassType.ClassResolveResult resultY = Util.resolveType(y);
                        PsiClass xClass = resultX.getElement();
                        PsiClass yClass = resultY.getElement();
                        PsiSubstitutor xSubst = resultX.getSubstitutor();
                        PsiSubstitutor ySubst = resultY.getSubstitutor();
                        if (xClass == null || yClass == null) {
                            return 3;
                        }
                        if (xClass.equals(yClass)) {
                            boolean first = true;
                            int direction = 2;
                            for (PsiTypeParameter p : xSubst.getSubstitutionMap().keySet()) {
                                PsiType yParm;
                                PsiType xParm = xSubst.substitute(p);
                                int comp = this.compare(xParm, yParm = ySubst.substitute(p));
                                if (comp == 3) {
                                    return 3;
                                }
                                if (first) {
                                    first = false;
                                    direction = comp;
                                }
                                if (direction == comp) continue;
                                return 3;
                            }
                            return direction;
                        }
                        if (InheritanceUtil.isInheritorOrSelf((PsiClass)xClass, (PsiClass)yClass, (boolean)true)) {
                            return 0;
                        }
                        if (InheritanceUtil.isInheritorOrSelf((PsiClass)yClass, (PsiClass)xClass, (boolean)true)) {
                            return 1;
                        }
                        return 3;
                    }
                }.compare(x, y = this.normalize((PsiType)b2.myBindings.get(index)));
                if (comp == 3) {
                    return 3;
                }
                if (first) {
                    first = false;
                    directoin = comp;
                }
                if (directoin != 2) {
                    if (comp == 2 || directoin == comp) continue;
                    return 3;
                }
                if (comp == 2) continue;
                directoin = comp;
            }
            return directoin;
        }

        @Override
        public boolean nonEmpty() {
            return this.myBindings.size() > 0;
        }

        @Override
        public boolean isCyclic() {
            return this.myCyclic;
        }

        @Override
        public Binding reduceRecursive() {
            PsiType type2;
            int index;
            BindingImpl binding = (BindingImpl)BindingFactory.this.create();
            for (PsiTypeVariable var : BindingFactory.this.myBoundVariables) {
                index = var.getIndex();
                type2 = (PsiType)this.myBindings.get(index);
                if (type2 != null) {
                    class Verifier
                    extends PsiExtendedTypeVisitor<Void> {
                        boolean myFlag;

                        Verifier() {
                        }

                        @Override
                        public Void visitTypeVariable(@NotNull PsiTypeVariable var) {
                            if (var.getIndex() == index) {
                                this.myFlag = true;
                            }
                            return null;
                        }
                    }
                    Verifier verifier = new Verifier();
                    type2.accept((PsiTypeVisitor)verifier);
                    if (verifier.myFlag) {
                        this.myBindings.put(index, (Object)Bottom.BOTTOM);
                        binding.myBindings.put(index, (Object)Bottom.BOTTOM);
                        continue;
                    }
                    binding.myBindings.put(index, (Object)type2);
                    continue;
                }
                binding.myBindings.put(index, (Object)type2);
            }
            for (PsiTypeVariable var : BindingFactory.this.myBoundVariables) {
                index = var.getIndex();
                type2 = (PsiType)this.myBindings.get(index);
                if (type2 == null) continue;
                this.myBindings.put(index, (Object)binding.apply(type2));
            }
            return this;
        }

        @Override
        public boolean binds(PsiTypeVariable var) {
            return this.myBindings.get(var.getIndex()) != null;
        }

        @Override
        public void merge(Binding b, boolean removeObject) {
            block0: for (PsiTypeVariable var : b.getBoundVariables()) {
                int index = var.getIndex();
                if (this.myBindings.get(index) != null) {
                    LOG.error("Oops... Binding conflict...");
                    continue;
                }
                PsiType type2 = b.apply(var);
                PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)BindingFactory.this.myProject), (GlobalSearchScope)GlobalSearchScope.allScope((Project)BindingFactory.this.myProject));
                if (removeObject && javaLangObject.equals((Object)type2)) {
                    Set<PsiTypeVariable> cluster = BindingFactory.this.myFactory.getClusterOf(var.getIndex());
                    if (cluster == null) continue;
                    for (PsiTypeVariable war : cluster) {
                        PsiType wtype = b.apply(war);
                        if (javaLangObject.equals((Object)wtype)) continue;
                        this.myBindings.put(index, (Object)type2);
                        continue block0;
                    }
                    continue;
                }
                this.myBindings.put(index, (Object)type2);
            }
        }

        @Override
        public Set<PsiTypeVariable> getBoundVariables() {
            return BindingFactory.this.myBoundVariables;
        }

        @Override
        public int getWidth() {
            class MyProcecure
            implements TObjectProcedure<PsiType> {
                int width;

                MyProcecure() {
                }

                public boolean execute(PsiType type2) {
                    if (BindingImpl.this.substitute(type2) != null) {
                        ++this.width;
                    }
                    return true;
                }

                public int getWidth() {
                    return this.width;
                }
            }
            MyProcecure procedure = new MyProcecure();
            this.myBindings.forEachValue((TObjectProcedure)procedure);
            return procedure.getWidth();
        }

        @Override
        public boolean isValid() {
            for (PsiTypeVariable var : BindingFactory.this.myBoundVariables) {
                PsiType type2;
                if (var.isValidInContext(type2 = this.substitute(var))) continue;
                return false;
            }
            return true;
        }

        @Override
        public void addTypeVariable(PsiTypeVariable var) {
            BindingFactory.this.myBoundVariables.add(var);
        }

        @Override
        public PsiType substitute(PsiType t) {
            if (t instanceof PsiWildcardType) {
                PsiWildcardType wcType = (PsiWildcardType)t;
                PsiType bound = wcType.getBound();
                if (bound == null) {
                    return t;
                }
                PsiManager manager = PsiManager.getInstance((Project)BindingFactory.this.myProject);
                PsiType subst = this.substitute(bound);
                if (subst == null) {
                    return null;
                }
                return subst instanceof PsiWildcardType ? subst : (wcType.isExtends() ? PsiWildcardType.createExtends((PsiManager)manager, (PsiType)subst) : PsiWildcardType.createSuper((PsiManager)manager, (PsiType)subst));
            }
            if (t instanceof PsiTypeVariable) {
                PsiType b = this.apply(t);
                if (b instanceof Bottom || b instanceof PsiTypeVariable) {
                    return null;
                }
                return this.substitute(b);
            }
            if (t instanceof Bottom) {
                return null;
            }
            if (t instanceof PsiArrayType) {
                return this.substitute(((PsiArrayType)t).getComponentType()).createArrayType();
            }
            if (t instanceof PsiClassType) {
                PsiClassType.ClassResolveResult result = ((PsiClassType)t).resolveGenerics();
                PsiClass aClass = result.getElement();
                PsiSubstitutor aSubst = result.getSubstitutor();
                if (aClass != null) {
                    PsiSubstitutor theSubst = PsiSubstitutor.EMPTY;
                    for (PsiTypeParameter parm : aSubst.getSubstitutionMap().keySet()) {
                        PsiType type2 = aSubst.substitute(parm);
                        theSubst = theSubst.put(parm, this.substitute(type2));
                    }
                    return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, theSubst);
                }
            }
            return t;
        }
    }
}

