/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingMoveDestination;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutocreatingSingleSourceRootMoveDestination
extends AutocreatingMoveDestination {
    private final VirtualFile mySourceRoot;
    PsiDirectory myTargetDirectory;

    public AutocreatingSingleSourceRootMoveDestination(PackageWrapper targetPackage, @NotNull VirtualFile sourceRoot) {
        super(targetPackage);
        this.mySourceRoot = sourceRoot;
    }

    @Override
    @NotNull
    public PackageWrapper getTargetPackage() {
        return this.myPackage;
    }

    public PsiDirectory getTargetIfExists(PsiDirectory source) {
        return RefactoringUtil.findPackageDirectoryInSourceRoot(this.myPackage, this.mySourceRoot);
    }

    public PsiDirectory getTargetIfExists(@NotNull PsiFile source) {
        return RefactoringUtil.findPackageDirectoryInSourceRoot(this.myPackage, this.mySourceRoot);
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiDirectory source) throws IncorrectOperationException {
        return this.getDirectory();
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiFile source) throws IncorrectOperationException {
        return this.getDirectory();
    }

    @Nullable
    public String verify(PsiFile source) {
        return this.checkCanCreateInSourceRoot(this.mySourceRoot);
    }

    public String verify(PsiDirectory source) {
        return this.checkCanCreateInSourceRoot(this.mySourceRoot);
    }

    public String verify(PsiPackage aPackage) {
        return this.checkCanCreateInSourceRoot(this.mySourceRoot);
    }

    public void analyzeModuleConflicts(@NotNull Collection<? extends PsiElement> elements, @NotNull MultiMap<PsiElement, String> conflicts, UsageInfo[] usages) {
        RefactoringConflictsUtil.analyzeModuleConflicts(this.getTargetPackage().getManager().getProject(), elements, usages, this.mySourceRoot, conflicts);
    }

    public boolean isTargetAccessible(@NotNull Project project, @NotNull VirtualFile place) {
        boolean inTestSourceContent = ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(place);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)place, (Project)project);
        return this.mySourceRoot == null || module == null || GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)inTestSourceContent).contains(this.mySourceRoot);
    }

    private PsiDirectory getDirectory() throws IncorrectOperationException {
        if (this.myTargetDirectory == null) {
            this.myTargetDirectory = (PsiDirectory)WriteAction.compute(() -> {
                try {
                    return RefactoringUtil.createPackageDirectoryInSourceRoot(this.myPackage, this.mySourceRoot);
                }
                catch (IncorrectOperationException e) {
                    return null;
                }
            });
        }
        return this.myTargetDirectory;
    }
}

