/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.ClassMemberInExprUsageInfo;
import com.intellij.refactoring.introduceParameter.LocalVariableInExprUsageInfo;
import com.intellij.refactoring.introduceParameter.ParameterInExprUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static void analyzeExpression(PsiExpression expr2, List<? super UsageInfo> localVars, List<? super UsageInfo> classMemberRefs, List<? super UsageInfo> params) {
        PsiElement[] children;
        if (expr2 instanceof PsiThisExpression || expr2 instanceof PsiSuperExpression) {
            classMemberRefs.add(new ClassMemberInExprUsageInfo((PsiElement)expr2));
        } else if (expr2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)expr2;
            PsiElement subj = refExpr.resolve();
            if (subj instanceof PsiParameter) {
                params.add(new ParameterInExprUsageInfo((PsiElement)refExpr));
            } else if (subj instanceof PsiLocalVariable) {
                localVars.add(new LocalVariableInExprUsageInfo((PsiElement)refExpr));
            } else if (subj instanceof PsiField || subj instanceof PsiMethod) {
                classMemberRefs.add(new ClassMemberInExprUsageInfo((PsiElement)refExpr));
            }
        }
        for (PsiElement child : children = expr2.getChildren()) {
            if (!(child instanceof PsiExpression)) continue;
            Util.analyzeExpression((PsiExpression)child, localVars, classMemberRefs, params);
        }
    }

    @NotNull
    private static PsiElement getPhysical(@NotNull PsiElement expr2) {
        PsiElement physicalElement = (PsiElement)expr2.getUserData(ElementToWorkOn.PARENT);
        if (physicalElement != null) {
            expr2 = physicalElement;
        }
        return expr2;
    }

    public static PsiMethod getContainingMethod(PsiElement expr2) {
        return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)Util.getPhysical(expr2), PsiMethod.class);
    }

    public static boolean isAncestor(PsiElement ancestor, PsiElement element, boolean strict) {
        TextRange exprRange = (TextRange)ancestor.getUserData(ElementToWorkOn.EXPR_RANGE);
        if (exprRange != null) {
            return exprRange.contains(element.getTextRange());
        }
        return PsiTreeUtil.isAncestor((PsiElement)Util.getPhysical(ancestor), (PsiElement)Util.getPhysical(element), (boolean)strict);
    }

    public static boolean anyFieldsWithGettersPresent(List<? extends UsageInfo> classMemberRefs) {
        for (UsageInfo usageInfo : classMemberRefs) {
            PsiElement e;
            if (!(usageInfo.getElement() instanceof PsiReferenceExpression) || !((e = ((PsiReferenceExpression)usageInfo.getElement()).resolve()) instanceof PsiField)) continue;
            PsiField psiField = (PsiField)e;
            PsiMethod getterPrototype = GenerateMembersUtil.generateGetterPrototype(psiField);
            PsiMethod getter = psiField.getContainingClass().findMethodBySignature(getterPrototype, true);
            if (getter == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TIntArrayList findParametersToRemove(@NotNull PsiMethod method, @NotNull PsiExpression expr2, PsiExpression @Nullable [] occurences) {
        final PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length == 0) {
            return new TIntArrayList();
        }
        Object[] overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        PsiMethod[] allMethods = (PsiMethod[])ArrayUtil.append((Object[])overridingMethods, (Object)method);
        final TIntHashSet suspects = new TIntHashSet();
        expr2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                int i;
                super.visitReferenceExpression(expression2);
                PsiElement resolved = expression2.resolve();
                if (resolved instanceof PsiParameter && (i = ArrayUtil.find((Object[])parameters2, (Object)resolved)) != -1) {
                    suspects.add(i);
                }
            }
        });
        TIntIterator iterator = suspects.iterator();
        while (iterator.hasNext()) {
            PsiParameter parameter2;
            PsiMethod psiMethod;
            PsiParameter[] psiParameters;
            int paramNum = iterator.next();
            PsiMethod[] psiMethodArray = allMethods;
            int n = psiMethodArray.length;
            for (int i = 0; i < n && (paramNum >= (psiParameters = (psiMethod = psiMethodArray[i]).getParameterList().getParameters()).length || ReferencesSearch.search((PsiElement)(parameter2 = psiParameters[paramNum]), (SearchScope)parameter2.getResolveScope(), (boolean)false).forEach(reference -> {
                PsiElement element = reference.getElement();
                boolean stillCanBeRemoved = false;
                if (element != null) {
                    boolean bl = stillCanBeRemoved = Util.isAncestor((PsiElement)expr2, element, false) || PsiUtil.isInsideJavadocComment((PsiElement)Util.getPhysical(element));
                    if (!stillCanBeRemoved && occurences != null) {
                        for (PsiExpression occurence : occurences) {
                            if (!Util.isAncestor((PsiElement)occurence, element, false)) continue;
                            stillCanBeRemoved = true;
                            break;
                        }
                    }
                }
                if (!stillCanBeRemoved) {
                    iterator.remove();
                    return false;
                }
                return true;
            })); ++i) {
            }
        }
        return new TIntArrayList(suspects.toArray());
    }
}

