/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.inline.InlineFieldDialog;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class InlineConstantFieldHandler
extends JavaInlineActionHandler {
    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiField && JavaLanguage.INSTANCE.equals(element.getLanguage());
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiElement resolve2;
        PsiReference reference;
        PsiElement navigationElement = element.getNavigationElement();
        PsiField field = (PsiField)(navigationElement instanceof PsiField ? navigationElement : element);
        PsiExpression initializer = InlineConstantFieldHandler.getInitializer(field);
        if (initializer == null) {
            String message2 = JavaRefactoringBundle.message((String)"no.initializer.present.for.the.field", (Object[])new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)InlineConstantFieldHandler.getRefactoringName(), (String)"refactoring.inlineField");
            return;
        }
        if (field instanceof PsiEnumConstant) {
            String message3 = JavaRefactoringBundle.message((String)"inline.constant.field.not.supported.for.enum.constants", (Object[])new Object[]{InlineConstantFieldHandler.getRefactoringName()});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)InlineConstantFieldHandler.getRefactoringName(), (String)"refactoring.inlineField");
            return;
        }
        if (ReferencesSearch.search((PsiElement)field, (SearchScope)ProjectScope.getProjectScope((Project)project), (boolean)false).findFirst() == null) {
            String message4 = JavaRefactoringBundle.message((String)"field.0.is.never.used", (Object[])new Object[]{field.getName()});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message4, (String)InlineConstantFieldHandler.getRefactoringName(), (String)"refactoring.inlineField");
            return;
        }
        if (!field.hasModifierProperty("final")) {
            Ref hasWriteUsages = new Ref((Object)false);
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)field)) {
                    if (!InlineConstantFieldHandler.isAccessedForWriting(reference.getElement())) continue;
                    hasWriteUsages.set((Object)true);
                    break;
                }
            }), JavaRefactoringBundle.message((String)"inline.conflicts.progress", (Object[])new Object[0]), true, project)) {
                return;
            }
            if (((Boolean)hasWriteUsages.get()).booleanValue()) {
                String message5 = JavaRefactoringBundle.message((String)"0.refactoring.is.supported.only.for.final.fields", (Object[])new Object[]{InlineConstantFieldHandler.getRefactoringName()});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message5, (String)InlineConstantFieldHandler.getRefactoringName(), (String)"refactoring.inlineField");
                return;
            }
        }
        PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset()) : null;
        if (reference != null && (resolve2 = reference.resolve()) != null && !field.equals(resolve2.getNavigationElement())) {
            reference = null;
        }
        if (!(element instanceof PsiCompiledElement && reference != null || CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)field))) {
            return;
        }
        MultiMap conflicts = new MultiMap();
        InlineUtil.checkChangedBeforeLastAccessConflicts((MultiMap<PsiElement, String>)conflicts, initializer, (PsiVariable)field);
        if (!BaseRefactoringProcessor.processConflicts((Project)project, (MultiMap)conflicts)) {
            return;
        }
        PsiReferenceExpression refExpression = reference instanceof PsiReferenceExpression ? (PsiReferenceExpression)reference : null;
        InlineFieldDialog dialog = new InlineFieldDialog(project, field, refExpression);
        dialog.show();
    }

    private static boolean isAccessedForWriting(PsiElement referenceElement) {
        if (referenceElement.getLanguage() == JavaLanguage.INSTANCE) {
            if (!(referenceElement instanceof PsiExpression) || PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)referenceElement))) {
                return true;
            }
        } else {
            for (ReadWriteAccessDetector detector : ReadWriteAccessDetector.EP_NAME.getExtensionList()) {
                if (detector.getExpressionAccess(referenceElement) == ReadWriteAccessDetector.Access.Read) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiExpression getInitializer(PsiField field) {
        PsiClass containingClass;
        if (field.hasInitializer()) {
            PsiExpression initializer = field.getInitializer();
            if (initializer instanceof PsiCompiledElement) {
                initializer = JavaPsiFacade.getElementFactory((Project)field.getProject()).createExpressionFromText(initializer.getText(), (PsiElement)field);
            }
            return initializer;
        }
        if (field.hasModifierProperty("final") && (containingClass = field.getContainingClass()) != null) {
            PsiMethod[] constructors = containingClass.getConstructors();
            ArrayList result = new ArrayList();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement[])constructors))) {
                PsiAssignmentExpression assignmentExpression;
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiReferenceExpression) || !PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiExpression)element)) || (assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAssignmentExpression.class)) == null) continue;
                ContainerUtil.addIfNotNull(result, (Object)assignmentExpression.getRExpression());
            }
            if (result.isEmpty()) {
                return null;
            }
            PsiExpression first = (PsiExpression)result.get(0);
            for (PsiExpression expr2 : result) {
                if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expr2, (PsiElement)first)) continue;
                return null;
            }
            return first;
        }
        return null;
    }

    @Nullable
    public String getActionName(PsiElement element) {
        return InlineConstantFieldHandler.getRefactoringName() + "...";
    }

    private static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"inline.field.title", (Object[])new Object[0]);
    }
}

