/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterDescriptor
implements ItemToReplaceDescriptor {
    private final PsiTypeElement myTypeElement;
    private final PsiType myTypeToUse;

    public ParameterDescriptor(@NotNull PsiTypeElement typeElement, @NotNull PsiType typeToUse) {
        this.myTypeElement = typeElement;
        this.myTypeToUse = typeToUse;
    }

    @Nullable
    public static ParameterDescriptor createIfInaccessible(@NotNull PsiParameter parameter2) {
        PsiType parameterType;
        PsiTypeElement typeElement = parameter2.getTypeElement();
        if (typeElement != null && !PsiReflectionAccessUtil.isAccessibleType(parameterType = typeElement.getType())) {
            return new ParameterDescriptor(typeElement, PsiReflectionAccessUtil.nearestAccessibleType(parameterType));
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        this.myTypeElement.replace((PsiElement)elementFactory.createTypeElement(this.myTypeToUse));
    }
}

