/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.refactoring.extractMethod.preview.PreviewTreeListener;
import com.intellij.refactoring.extractMethod.preview.PreviewTreeModel;
import com.intellij.refactoring.extractMethod.preview.PreviewTreeRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreviewTree
implements Disposable {
    private final Project myProject;
    private final Tree myTree;
    private final List<PreviewTreeListener> myTreeListeners = new SmartList();
    private final PreviewTreeModel myModel;

    PreviewTree(ExtractMethodProcessor processor2) {
        this.myProject = processor2.getProject();
        this.myModel = new PreviewTreeModel(processor2);
        this.myTree = this.createTree(this.myModel);
        this.myTree.setPaintBusy(true);
    }

    private Tree createTree(DefaultTreeModel model) {
        Tree tree = new Tree((TreeModel)model);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setCellRenderer((TreeCellRenderer)((Object)new PreviewTreeRenderer()));
        tree.setName("ExtractMethodPreview");
        tree.getSelectionModel().addTreeSelectionListener(e -> ApplicationManager.getApplication().invokeLater(() -> this.onSelectionUpdate()));
        SmartExpander.installOn((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        TreeUtil.expand((JTree)tree, (int)2);
        TreeUtil.promiseSelectFirst((JTree)tree);
        PopupHandler.installPopupHandler((JComponent)tree, (String)"ExtractMethodToolWindow.TreePopup", (String)"unknown");
        return tree;
    }

    public void addTreeListener(PreviewTreeListener listener) {
        this.myTreeListeners.add(listener);
    }

    void onSelectionUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        FragmentNode firstSelectedNode = this.getFirstSelectedNode();
        if (firstSelectedNode != null) {
            for (PreviewTreeListener listener : this.myTreeListeners) {
                listener.onNodeSelected(firstSelectedNode);
            }
        }
    }

    @NotNull
    public List<FragmentNode> getSelectedNodes() {
        Object[] selectionPaths = this.myTree.getSelectionPaths();
        if (ArrayUtil.isEmpty((Object[])selectionPaths)) {
            return Collections.emptyList();
        }
        ArrayList<FragmentNode> result = new ArrayList<FragmentNode>();
        for (Object path : selectionPaths) {
            result.addAll(PreviewTree.getFragmentNodes((TreePath)path));
        }
        return result;
    }

    @Nullable
    private FragmentNode getFirstSelectedNode() {
        Object[] selectionPaths = this.myTree.getSelectionPaths();
        if (ArrayUtil.isEmpty((Object[])selectionPaths)) {
            return null;
        }
        for (Object path : selectionPaths) {
            List<FragmentNode> nodes = PreviewTree.getFragmentNodes((TreePath)path);
            if (nodes.isEmpty()) continue;
            return nodes.get(0);
        }
        return null;
    }

    @NotNull
    private static List<FragmentNode> getFragmentNodes(@NotNull TreePath path) {
        Object component = path.getLastPathComponent();
        if (component instanceof FragmentNode) {
            return Collections.singletonList((FragmentNode)component);
        }
        if (component instanceof TreeNode) {
            TreeNode node = (TreeNode)component;
            return IntStreamEx.range((int)0, (int)node.getChildCount()).mapToObj(node::getChildAt).select(FragmentNode.class).toList();
        }
        return Collections.emptyList();
    }

    public PreviewTreeModel getModel() {
        return this.myModel;
    }

    public JComponent getComponent() {
        return this.myTree;
    }

    public void repaint() {
        this.myTree.repaint();
    }

    void onUpdateLater() {
        this.myTree.setPaintBusy(false);
        this.onSelectionUpdate();
    }

    void selectNode(FragmentNode node) {
        this.myTree.setSelectionPath(new TreePath(node.getPath()));
    }

    public boolean isValid() {
        return this.myModel.isValid();
    }

    public void setValid(boolean valid) {
        this.myModel.setValid(valid);
        this.repaint();
    }

    public void dispose() {
        this.myTreeListeners.clear();
    }
}

