/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReusedLocalVariable {
    @NotNull
    private final String myName;
    @Nullable
    private final String myTempName;
    @NotNull
    private final String myType;
    private final boolean myReuseValue;

    ReusedLocalVariable(@NotNull String name2, @Nullable String tempName, @NotNull String type2, boolean reuseValue) {
        assert (reuseValue == (tempName != null));
        this.myName = name2;
        this.myTempName = tempName;
        this.myType = type2;
        this.myReuseValue = reuseValue;
    }

    String getDeclarationText() {
        String initText = this.myReuseValue ? " = " + this.myTempName : "";
        return this.myType + " " + this.myName + initText + ";";
    }

    String getAssignmentText() {
        return this.myTempName + " = " + this.myName + ";";
    }

    String getTempDeclarationText() {
        return this.myType + " " + this.myTempName + ";";
    }

    boolean reuseValue() {
        return this.myReuseValue;
    }
}

