/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.RefactoringActionContextUtil;
import com.intellij.refactoring.extractInterface.ExtractClassUtil;
import com.intellij.refactoring.extractInterface.ExtractInterfaceDialog;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;

public class ExtractInterfaceHandler
implements RefactoringActionHandler,
ElementsHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(ExtractInterfaceHandler.class);
    private Project myProject;
    private PsiClass myClass;
    private String myInterfaceName;
    private MemberInfo[] mySelectedMembers;
    private PsiDirectory myTargetDir;
    private DocCommentPolicy myJavaDocPolicy;

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        return RefactoringActionContextUtil.isOutsideModuleAndCodeBlock(editor, file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)ExtractInterfaceHandler.getRefactoringName(), (String)"refactoring.extractInterface");
                return;
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (elements.length != 1) {
            return;
        }
        this.myProject = project;
        this.myClass = (PsiClass)elements[0];
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)this.myClass)) {
            return;
        }
        ExtractInterfaceDialog dialog = new ExtractInterfaceDialog(this.myProject, this.myClass);
        if (!dialog.showAndGet() || !dialog.isExtractSuperclass()) {
            return;
        }
        MultiMap conflicts = new MultiMap();
        ExtractSuperClassUtil.checkSuperAccessible(dialog.getTargetDirectory(), (MultiMap<PsiElement, String>)conflicts, this.myClass);
        if (!ExtractSuperClassUtil.showConflicts((DialogWrapper)dialog, (MultiMap<PsiElement, String>)conflicts, this.myProject)) {
            return;
        }
        PsiClass anInterface = (PsiClass)WriteCommandAction.writeCommandAction((Project)project).withName(ExtractInterfaceHandler.getRefactoringName()).compute(() -> {
            this.myInterfaceName = dialog.getExtractedSuperName();
            this.mySelectedMembers = dialog.getSelectedMemberInfos().toArray(new MemberInfo[0]);
            this.myTargetDir = dialog.getTargetDirectory();
            this.myJavaDocPolicy = new DocCommentPolicy(dialog.getDocCommentPolicy());
            LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
            try {
                PsiClass psiClass = ExtractInterfaceHandler.extractInterface(this.myTargetDir, this.myClass, this.myInterfaceName, this.mySelectedMembers, this.myJavaDocPolicy);
                return psiClass;
            }
            finally {
                a.finish();
            }
        });
        ExtractClassUtil.askAndTurnRefsToSuper(this.myClass, anInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PsiClass extractInterface(PsiDirectory targetDir, PsiClass aClass, String interfaceName, MemberInfo[] selectedMembers, DocCommentPolicy javaDocPolicy) throws IncorrectOperationException {
        Project project = aClass.getProject();
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted("refactoring.extractSuper", ExtractSuperClassUtil.createBeforeData(aClass, selectedMembers));
        PsiClass anInterface = JavaDirectoryService.getInstance().createInterface(targetDir, interfaceName);
        try {
            PsiReferenceList referenceList;
            PsiJavaCodeReferenceElement ref = ExtractSuperClassUtil.createExtendingReference(anInterface, aClass, selectedMembers);
            PsiReferenceList psiReferenceList = referenceList = aClass.isInterface() ? aClass.getExtendsList() : aClass.getImplementsList();
            assert (referenceList != null);
            CodeStyleManager.getInstance((Project)project).reformat(referenceList.add((PsiElement)ref));
            PullUpProcessor pullUpHelper = new PullUpProcessor(aClass, anInterface, selectedMembers, javaDocPolicy);
            pullUpHelper.moveMembersToBase();
            PsiClass psiClass = anInterface;
            return psiClass;
        }
        finally {
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone("refactoring.extractSuper", ExtractSuperClassUtil.createAfterData(anInterface));
        }
    }

    private String getCommandName() {
        return RefactoringBundle.message((String)"extract.interface.command.name", (Object[])new Object[]{this.myInterfaceName, DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass)});
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }

    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"extract.interface.title");
    }
}

