/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.copy;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.EditorHelper;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyClassDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesDialog;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.copy.CopyHandlerDelegateBase;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyClassesHandler
extends CopyHandlerDelegateBase {
    private static final Logger LOG = Logger.getInstance(CopyClassesHandler.class);

    public boolean forbidToClone(PsiElement[] elements, boolean fromUpdate) {
        Map<PsiFile, PsiClass[]> fileMap = CopyClassesHandler.convertToTopLevelClasses(elements, fromUpdate, null, null);
        if (fileMap != null && fileMap.size() == 1) {
            PsiClass[] psiClasses = fileMap.values().iterator().next();
            return psiClasses != null && psiClasses.length > 1;
        }
        return true;
    }

    public boolean canCopy(PsiElement[] elements, boolean fromUpdate) {
        return CopyClassesHandler.canCopyClass(fromUpdate, elements);
    }

    @Nullable
    public String getActionName(PsiElement[] elements) {
        if (elements.length == 1 && !(elements[0] instanceof PsiPackage) && !(elements[0] instanceof PsiDirectory)) {
            return JavaRefactoringBundle.message((String)"copy.handler.copy.class.with.dialog", (Object[])new Object[0]);
        }
        return JavaRefactoringBundle.message((String)"copy.handler.copy.classes.with.dialog", (Object[])new Object[0]);
    }

    public static boolean canCopyClass(PsiElement ... elements) {
        return CopyClassesHandler.canCopyClass(false, elements);
    }

    public static boolean canCopyClass(boolean fromUpdate, PsiElement ... elements) {
        if (fromUpdate && elements.length > 0 && elements[0] instanceof PsiDirectory) {
            return true;
        }
        return CopyClassesHandler.convertToTopLevelClasses(elements, fromUpdate, null, null) != null;
    }

    @Nullable
    private static Map<PsiFile, PsiClass[]> convertToTopLevelClasses(PsiElement[] elements, boolean fromUpdate, String relativePath, Map<PsiFile, String> relativeMap) {
        HashMap<PsiFile, PsiClass[]> result = new HashMap<PsiFile, PsiClass[]>();
        for (PsiElement element : elements) {
            PsiElement navigationElement = element.getNavigationElement();
            LOG.assertTrue(navigationElement != null, (Object)element);
            PsiFile containingFile = navigationElement.getContainingFile();
            if (containingFile instanceof PsiClassOwner && JavaProjectRootsUtil.isOutsideJavaSourceRoot(containingFile) || containingFile != null && "package-info.class".equals(containingFile.getName())) continue;
            PsiClass[] topLevelClasses = CopyClassesHandler.getTopLevelClasses(element);
            if (topLevelClasses == null) {
                if (element instanceof PsiDirectory) {
                    if (fromUpdate) continue;
                    String name2 = ((PsiDirectory)element).getName();
                    String path = relativePath != null ? (relativePath.length() > 0 ? relativePath + "/" : "") + name2 : null;
                    Map<PsiFile, PsiClass[]> map2 = CopyClassesHandler.convertToTopLevelClasses(element.getChildren(), fromUpdate, path, relativeMap);
                    if (map2 == null) {
                        return null;
                    }
                    for (Map.Entry<PsiFile, PsiClass[]> entry : map2.entrySet()) {
                        CopyClassesHandler.fillResultsMap(result, entry.getKey(), entry.getValue());
                    }
                    continue;
                }
                if (!(element instanceof PsiFileSystemItem)) {
                    return null;
                }
            }
            CopyClassesHandler.fillResultsMap(result, containingFile, topLevelClasses);
            if (relativeMap == null) continue;
            relativeMap.put(containingFile, relativePath);
        }
        if (result.isEmpty()) {
            return null;
        }
        boolean hasClasses = false;
        for (PsiClass[] classes2 : result.values()) {
            if (classes2 == null) continue;
            hasClasses = true;
            break;
        }
        return hasClasses ? result : null;
    }

    @Nullable
    private static String normalizeRelativeMap(Map<PsiFile, String> relativeMap) {
        String vector = null;
        for (String relativePath : relativeMap.values()) {
            if (vector == null) {
                vector = relativePath;
                continue;
            }
            if (vector.startsWith(relativePath + "/")) {
                vector = relativePath;
                continue;
            }
            if (relativePath.startsWith(vector + "/") || relativePath.equals(vector)) continue;
            return null;
        }
        if (vector != null) {
            Iterator<String> iterator = relativeMap.keySet().iterator();
            while (iterator.hasNext()) {
                PsiFile psiFile;
                String path = relativeMap.get(psiFile = (PsiFile)iterator.next());
                relativeMap.put(psiFile, path.equals(vector) ? "" : path.substring(vector.length() + 1));
            }
        }
        return vector;
    }

    private static void fillResultsMap(Map<PsiFile, PsiClass[]> result, PsiFile containingFile, PsiClass[] topLevelClasses) {
        Object[] classes2 = result.get(containingFile);
        if (topLevelClasses != null) {
            if (classes2 != null) {
                topLevelClasses = (PsiClass[])ArrayUtil.mergeArrays((Object[])classes2, (Object[])topLevelClasses, (ArrayFactory)PsiClass.ARRAY_FACTORY);
            }
            result.put(containingFile, topLevelClasses);
        } else {
            result.put(containingFile, (PsiClass[])classes2);
        }
    }

    public void doCopy(PsiElement[] elements, PsiDirectory defaultTargetDirectory) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.copyClass");
        HashMap<PsiFile, String> relativePathsMap = new HashMap<PsiFile, String>();
        Map<PsiFile, PsiClass[]> classes2 = CopyClassesHandler.convertToTopLevelClasses(elements, false, "", relativePathsMap);
        assert (classes2 != null);
        if (defaultTargetDirectory == null) {
            PsiFile psiFile = classes2.keySet().iterator().next();
            defaultTargetDirectory = psiFile.getContainingDirectory();
            LOG.assertTrue(defaultTargetDirectory != null, (Object)psiFile);
        }
        Project project = defaultTargetDirectory.getProject();
        if (DumbService.isDumb((Project)elements[0].getProject())) {
            DumbService.getInstance((Project)project).showDumbModeNotification(JavaRefactoringBundle.message((String)"copy.handler.is.not.available.during.indexing", (Object[])new Object[0]));
            return;
        }
        VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(defaultTargetDirectory.getVirtualFile());
        if (sourceRootForFile == null) {
            ArrayList<Object> files = new ArrayList<Object>();
            for (PsiElement element : elements) {
                PsiFile containingFile = element.getContainingFile();
                if (containingFile != null) {
                    files.add(containingFile);
                    continue;
                }
                if (!(element instanceof PsiDirectory)) continue;
                files.add(element);
            }
            CopyFilesOrDirectoriesHandler.copyAsFiles((PsiElement[])files.toArray(PsiElement.EMPTY_ARRAY), (PsiDirectory)defaultTargetDirectory, (Project)project);
            return;
        }
        PsiDirectory targetDirectory = null;
        String className2 = null;
        boolean openInEditor = true;
        if (CopyClassesHandler.copyOneClass(classes2)) {
            final String commonPath = ArrayUtilRt.find((Object[])elements, (Object)classes2.values().iterator().next()) == -1 ? CopyClassesHandler.normalizeRelativeMap(relativePathsMap) : null;
            CopyClassDialog dialog = new CopyClassDialog(classes2.values().iterator().next()[0], defaultTargetDirectory, project, false){

                @Override
                protected String getQualifiedName() {
                    String qualifiedName = super.getQualifiedName();
                    if (commonPath != null && !commonPath.isEmpty() && !qualifiedName.endsWith(commonPath)) {
                        return StringUtil.getQualifiedName((String)qualifiedName, (String)commonPath.replaceAll("/", "."));
                    }
                    return qualifiedName;
                }
            };
            dialog.setTitle(JavaRefactoringBundle.message((String)"copy.handler.copy.class", (Object[])new Object[0]));
            if (dialog.showAndGet()) {
                openInEditor = dialog.isOpenInEditor();
                targetDirectory = dialog.getTargetDirectory();
                className2 = dialog.getClassName();
                if (className2 == null || className2.length() == 0) {
                    return;
                }
            }
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            targetDirectory = defaultTargetDirectory;
        } else {
            if ((defaultTargetDirectory = CopyFilesOrDirectoriesHandler.resolveDirectory((PsiDirectory)defaultTargetDirectory)) == null) {
                return;
            }
            final PsiFile[] files = PsiUtilCore.toPsiFileArray(classes2.keySet());
            CopyFilesOrDirectoriesDialog dialog = new CopyFilesOrDirectoriesDialog((PsiElement[])files, defaultTargetDirectory, project, false){

                public JComponent getPreferredFocusedComponent() {
                    return files.length == 1 ? this.getTargetDirectoryComponent() : super.getPreferredFocusedComponent();
                }
            };
            if (dialog.showAndGet()) {
                targetDirectory = dialog.getTargetDirectory();
                String newName = dialog.getNewName();
                if (files.length == 1) {
                    className2 = StringUtil.trimEnd((String)newName, (String)("." + CopyClassesHandler.getFileExtension(files[0])));
                }
                openInEditor = dialog.isOpenInEditor();
            }
        }
        if (targetDirectory != null) {
            CopyClassesHandler.copyClassesImpl(className2, project, classes2, relativePathsMap, targetDirectory, defaultTargetDirectory, JavaRefactoringBundle.message((String)"copy.handler.copy.class", (Object[])new Object[0]), false, openInEditor);
        }
    }

    private static boolean copyOneClass(Map<PsiFile, PsiClass[]> classes2) {
        if (classes2.size() == 1) {
            PsiClass[] psiClasses = classes2.values().iterator().next();
            return psiClasses != null && psiClasses.length == 1;
        }
        return false;
    }

    public void doClone(PsiElement element) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.copyClass");
        PsiClass[] classes2 = CopyClassesHandler.getTopLevelClasses(element);
        if (classes2 == null) {
            CopyFilesOrDirectoriesHandler.doCloneFile((PsiElement)element);
            return;
        }
        Project project = element.getProject();
        CopyClassDialog dialog = new CopyClassDialog(classes2[0], null, project, true);
        dialog.setTitle(JavaRefactoringBundle.message((String)"copy.handler.clone.class", (Object[])new Object[0]));
        if (dialog.showAndGet()) {
            String className2 = dialog.getClassName();
            PsiDirectory targetDirectory = element.getContainingFile().getContainingDirectory();
            CopyClassesHandler.copyClassesImpl(className2, project, Collections.singletonMap(classes2[0].getContainingFile(), classes2), null, targetDirectory, targetDirectory, JavaRefactoringBundle.message((String)"copy.handler.clone.class", (Object[])new Object[0]), true, true);
        }
    }

    private static void copyClassesImpl(String copyClassName, Project project, Map<PsiFile, PsiClass[]> classes2, HashMap<PsiFile, String> map2, Object targetDirectory, PsiDirectory defaultTargetDirectory, String commandName, boolean selectInActivePanel, boolean openInEditor) {
        Runnable command = () -> {
            PsiDirectory target = targetDirectory instanceof PsiDirectory ? (PsiDirectory)targetDirectory : (PsiDirectory)WriteAction.compute(() -> ((MoveDestination)targetDirectory).getTargetDirectory(defaultTargetDirectory));
            try {
                Collection<PsiFile> files = CopyClassesHandler.doCopyClasses(classes2, map2, copyClassName, target, project);
                if (openInEditor) {
                    for (PsiFile file : files) {
                        CopyHandler.updateSelectionInActiveProjectView((PsiElement)file, (Project)project, (boolean)selectInActivePanel);
                    }
                    EditorHelper.openFilesInEditor((PsiElement[])((PsiElement[])files.toArray(PsiFile.EMPTY_ARRAY)));
                }
            }
            catch (IncorrectOperationException ex) {
                Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
            }
        };
        CommandProcessor processor2 = CommandProcessor.getInstance();
        processor2.executeCommand(project, command, commandName, null);
    }

    @NotNull
    public static Collection<PsiFile> doCopyClasses(Map<PsiFile, PsiClass[]> fileToClasses, String copyClassName, PsiDirectory targetDirectory, Project project) throws IncorrectOperationException {
        return CopyClassesHandler.doCopyClasses(fileToClasses, null, copyClassName, targetDirectory, project);
    }

    @NotNull
    public static Collection<PsiFile> doCopyClasses(Map<PsiFile, PsiClass[]> fileToClasses, @Nullable HashMap<PsiFile, String> map2, String copyClassName, PsiDirectory targetDirectory, Project project) throws IncorrectOperationException {
        int[] nArray;
        HashMap<PsiClass, Object> oldToNewMap = new HashMap<PsiClass, Object>();
        for (PsiClass[] psiClasses : fileToClasses.values()) {
            if (psiClasses == null) continue;
            for (PsiClass aClass : psiClasses) {
                if (CopyClassesHandler.isSynthetic(aClass)) continue;
                oldToNewMap.put(aClass, null);
            }
        }
        ArrayList<PsiFile> createdFiles = new ArrayList<PsiFile>(fileToClasses.size());
        if (fileToClasses.size() > 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = -1;
        } else {
            nArray = null;
        }
        int[] choice = nArray;
        ArrayList files = new ArrayList();
        ((PsiDirectoryImpl)targetDirectory).executeWithUpdatingAddedFilesDisabled(() -> {
            for (Map.Entry entry : fileToClasses.entrySet()) {
                PsiFile psiFile = (PsiFile)entry.getKey();
                PsiClass[] sources = (PsiClass[])entry.getValue();
                if (psiFile instanceof PsiClassOwner && sources != null) {
                    PsiFile createdFile = CopyClassesHandler.copy(psiFile, targetDirectory, copyClassName, map2 == null ? null : (String)map2.get(psiFile), choice);
                    if (createdFile == null) {
                        for (PsiClass aClass : ((PsiClassOwner)psiFile).getClasses()) {
                            oldToNewMap.remove(aClass);
                        }
                        continue;
                    }
                    LinkedHashMap<PsiClass, PsiClass> sourceToDestination = new LinkedHashMap<PsiClass, PsiClass>();
                    for (PsiClass destination : ((PsiClassOwner)createdFile).getClasses()) {
                        if (CopyClassesHandler.isSynthetic(destination)) continue;
                        PsiClass source = CopyClassesHandler.findByName(sources, destination.getName());
                        if (source == null) {
                            WriteAction.run(() -> destination.delete());
                            continue;
                        }
                        sourceToDestination.put(source, destination);
                    }
                    for (Map.Entry classEntry : sourceToDestination.entrySet()) {
                        PsiClass copy = CopyClassesHandler.copy((PsiClass)classEntry.getKey(), sourceToDestination.size() > 1 ? null : copyClassName);
                        PsiElement newElement = (PsiElement)WriteAction.compute(() -> ((PsiClass)classEntry.getValue()).replace((PsiElement)copy));
                        oldToNewMap.put((PsiClass)classEntry.getKey(), newElement);
                    }
                    createdFiles.add(createdFile);
                    continue;
                }
                files.add(psiFile);
            }
        });
        DumbService.getInstance((Project)project).completeJustSubmittedTasks();
        WriteAction.run(() -> UpdateAddedFileProcessor.updateAddedFiles((Iterable)createdFiles));
        for (PsiFile file : files) {
            try {
                PsiFile fileCopy;
                String relativePath;
                PsiDirectory finalTarget = targetDirectory;
                String string = relativePath = map2 != null ? map2.get(file) : null;
                if (relativePath != null && !relativePath.isEmpty()) {
                    finalTarget = (PsiDirectory)WriteAction.compute(() -> CopyClassesHandler.buildRelativeDir(targetDirectory, relativePath).findOrCreateTargetDirectory());
                }
                if ((fileCopy = CopyFilesOrDirectoriesHandler.copyToDirectory((PsiFileSystemItem)file, (String)CopyClassesHandler.getNewFileName(file, copyClassName), (PsiDirectory)finalTarget, (int[])choice, null)) == null) continue;
                createdFiles.add(fileCopy);
            }
            catch (IOException e) {
                throw new IncorrectOperationException(e.getMessage());
            }
        }
        WriteAction.run(() -> {
            HashSet rebindExpressions = new HashSet();
            for (PsiElement element : oldToNewMap.values()) {
                if (element == null) {
                    LOG.error(oldToNewMap.keySet());
                    continue;
                }
                CopyClassesHandler.decodeRefs(element, oldToNewMap, rebindExpressions);
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            for (PsiFile psiFile : createdFiles) {
                if (!(psiFile instanceof PsiJavaFile)) continue;
                codeStyleManager.removeRedundantImports((PsiJavaFile)psiFile);
            }
            for (PsiElement expression2 : rebindExpressions) {
                if (!expression2.isValid()) continue;
                codeStyleManager.shortenClassReferences(expression2);
            }
        });
        new OptimizeImportsProcessor(project, createdFiles.toArray(PsiFile.EMPTY_ARRAY), null).run();
        return createdFiles;
    }

    protected static boolean isSynthetic(PsiClass aClass) {
        return aClass instanceof SyntheticElement || !aClass.isPhysical();
    }

    private static PsiFile copy(@NotNull PsiFile file, PsiDirectory directory, String name2, String relativePath, int[] choice) {
        String fileName = CopyClassesHandler.getNewFileName(file, name2);
        if (relativePath != null && !relativePath.isEmpty()) {
            return (PsiFile)WriteAction.compute(() -> CopyClassesHandler.buildRelativeDir(directory, relativePath).findOrCreateTargetDirectory().copyFileFrom(fileName, file));
        }
        if (CopyFilesOrDirectoriesHandler.checkFileExist((PsiDirectory)directory, (int[])choice, (PsiFile)file, (String)fileName, (String)"Copy")) {
            return null;
        }
        return (PsiFile)WriteAction.compute(() -> directory.copyFileFrom(fileName, file));
    }

    private static String getNewFileName(PsiFile file, String name2) {
        if (name2 != null) {
            String fileExtension = CopyClassesHandler.getFileExtension(file);
            return fileExtension.isEmpty() ? name2 : StringUtil.getQualifiedName((String)name2, (String)fileExtension);
        }
        return file.getName();
    }

    private static String getFileExtension(PsiFile file) {
        if (file instanceof PsiClassOwner) {
            for (PsiClass psiClass : ((PsiClassOwner)file).getClasses()) {
                if (CopyClassesHandler.isSynthetic(psiClass)) continue;
                return file.getViewProvider().getVirtualFile().getExtension();
            }
        }
        return "";
    }

    @NotNull
    private static MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper buildRelativeDir(@NotNull PsiDirectory directory, @NotNull String relativePath) {
        MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper current = null;
        for (String pathElement : relativePath.split("/")) {
            current = current == null ? new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(directory, pathElement) : new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(current, pathElement);
        }
        LOG.assertTrue(current != null);
        return current;
    }

    private static PsiClass copy(PsiClass aClass, String name2) {
        PsiClass classNavigationElement = (PsiClass)aClass.getNavigationElement();
        PsiClass classCopy = (PsiClass)classNavigationElement.copy();
        if (name2 != null) {
            classCopy.setName(name2);
        }
        return classCopy;
    }

    @Nullable
    private static PsiClass findByName(PsiClass[] classes2, String name2) {
        if (name2 != null) {
            for (PsiClass aClass : classes2) {
                if (!name2.equals(aClass.getName())) continue;
                return aClass;
            }
        }
        return null;
    }

    private static void rebindExternalReferences(PsiElement element, Map<PsiClass, PsiElement> oldToNewMap, Set<? super PsiElement> rebindExpressions) {
        LocalSearchScope searchScope = new LocalSearchScope(element);
        for (PsiClass aClass : oldToNewMap.keySet()) {
            PsiElement newClass = oldToNewMap.get(aClass);
            for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)searchScope)) {
                rebindExpressions.add((PsiElement)reference.bindToElement(newClass));
            }
        }
    }

    private static void decodeRefs(@NotNull PsiElement element, final Map<PsiClass, PsiElement> oldToNewMap, Set<? super PsiElement> rebindExpressions) {
        final LinkedHashMap rebindMap = new LinkedHashMap();
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                CopyClassesHandler.decodeRef(reference, oldToNewMap, rebindMap);
            }
        });
        for (Map.Entry entry : rebindMap.entrySet()) {
            rebindExpressions.add((PsiElement)((PsiJavaCodeReferenceElement)entry.getKey()).bindToElement((PsiElement)entry.getValue()));
        }
        CopyClassesHandler.rebindExternalReferences(element, oldToNewMap, rebindExpressions);
    }

    private static void decodeRef(PsiJavaCodeReferenceElement expression2, Map<PsiClass, PsiElement> oldToNewMap, Map<PsiJavaCodeReferenceElement, PsiElement> rebindExpressions) {
        PsiClass psiClass;
        PsiElement resolved = expression2.resolve();
        if (resolved instanceof PsiClass && oldToNewMap.containsKey(psiClass = (PsiClass)resolved)) {
            rebindExpressions.put(expression2, oldToNewMap.get(psiClass));
        }
    }

    private static PsiClass @Nullable [] getTopLevelClasses(PsiElement element) {
        PsiClass[] psiClassArray;
        while (!(element == null || element instanceof PsiFile || element instanceof PsiClass && element.getParent() != null && ((PsiClass)element).getContainingClass() == null && !(element instanceof PsiAnonymousClass))) {
            element = element.getParent();
        }
        if (element instanceof PsiClassOwner) {
            PsiClass[] classes2 = ((PsiClassOwner)element).getClasses();
            ArrayList<PsiClass> buffer = new ArrayList<PsiClass>();
            for (PsiClass aClass : classes2) {
                if (CopyClassesHandler.isSynthetic(aClass)) {
                    return null;
                }
                buffer.add(aClass);
            }
            return buffer.toArray(PsiClass.EMPTY_ARRAY);
        }
        if (element instanceof PsiClass) {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = (PsiClass)element;
        } else {
            psiClassArray = null;
        }
        return psiClassArray;
    }
}

