/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.AccessModifier;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodDescriptor
implements MethodDescriptor<ParameterInfoImpl, String> {
    @NotNull
    private final PsiMethod myMethod;

    public JavaMethodDescriptor(@NotNull PsiMethod method) {
        this.myMethod = method;
    }

    public String getName() {
        return this.myMethod.getName();
    }

    @NotNull
    public List<ParameterInfoImpl> getParameters() {
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters2 = this.myMethod.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            ParameterInfoImpl info = ParameterInfoImpl.create(i).withName(parameter2.getName()).withType(parameter2.getType());
            info.defaultValue = "";
            result.add(info);
        }
        return result;
    }

    @NotNull
    public String getVisibility() {
        return VisibilityUtil.getVisibilityModifier((PsiModifierList)this.myMethod.getModifierList());
    }

    @NotNull
    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public int getParametersCount() {
        return this.myMethod.getParameterList().getParametersCount();
    }

    @Nullable
    public String getReturnTypeText() {
        PsiTypeElement typeElement = this.myMethod.getReturnTypeElement();
        if (typeElement != null) {
            PsiType type2 = typeElement.getType();
            if (type2.getAnnotations().length > 0) {
                return type2.getPresentableText(true);
            }
            return typeElement.getText();
        }
        return null;
    }

    public boolean canChangeVisibility() {
        return AccessModifier.getAvailableModifiers((PsiMember)this.myMethod).size() > 1;
    }

    public boolean canChangeParameters() {
        return true;
    }

    @NotNull
    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        return this.myMethod.isConstructor() ? MethodDescriptor.ReadWriteOption.None : MethodDescriptor.ReadWriteOption.ReadWrite;
    }

    public boolean canChangeName() {
        return !this.myMethod.isConstructor();
    }

    public List<AccessModifier> getAllowedModifiers() {
        return AccessModifier.getAvailableModifiers((PsiMember)this.myMethod);
    }
}

