/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringActionContextUtil {
    public static boolean isJavaClassHeader(@NotNull PsiElement element) {
        if (element.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        return psiClass != null && (element == psiClass || element == psiClass.getNameIdentifier() || PsiTreeUtil.isAncestor((PsiElement)psiClass.getModifierList(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiClass.getExtendsList(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiClass.getImplementsList(), (PsiElement)element, (boolean)false));
    }

    @Nullable
    public static PsiMethod getJavaMethodHeader(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element.getLanguage() != JavaLanguage.INSTANCE) {
            return null;
        }
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        if (psiMethod != null && (element == psiMethod || element == psiMethod.getNameIdentifier() || PsiTreeUtil.isAncestor((PsiElement)psiMethod.getModifierList(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiMethod.getParameterList(), (PsiElement)element, (boolean)false))) {
            return psiMethod;
        }
        return null;
    }

    public static boolean isOutsideModuleAndCodeBlock(@NotNull Editor editor, @NotNull PsiFile file) {
        if (PsiUtil.isModuleFile((PsiFile)file)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class) == null;
    }
}

