/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseJavaRefactoringAction;
import com.intellij.refactoring.anonymousToInner.AnonymousToInnerHandler;
import org.jetbrains.annotations.NotNull;

public class AnonymousToInnerAction
extends BaseJavaRefactoringAction {
    public boolean isAvailableInEditorOnly() {
        return true;
    }

    public boolean isEnabledOnElements(PsiElement @NotNull [] elements) {
        return false;
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        PsiElement targetElement = file.findElementAt(editor.getCaretModel().getOffset());
        if (PsiTreeUtil.getParentOfType((PsiElement)targetElement, PsiAnonymousClass.class) != null) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnonymousClass.class) != null) {
            return true;
        }
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
        return newExpression != null && newExpression.getAnonymousClass() != null;
    }

    public RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        return new AnonymousToInnerHandler();
    }
}

