/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.RecaptureTypeMapper;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.siyeh.ig.bugs.NullArgumentToVariableArgMethodInspection;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantCastUtil {
    private static final Logger LOG = Logger.getInstance(RedundantCastUtil.class);

    private RedundantCastUtil() {
    }

    @NotNull
    public static List<PsiTypeCastExpression> getRedundantCastsInside(@NotNull PsiElement where) {
        HashSet casts = new HashSet();
        final JavaElementVisitor visitor2 = RedundantCastUtil.createRedundantCastVisitor((Processor<? super PsiTypeCastExpression>)new CommonProcessors.CollectProcessor(casts));
        where.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                super.visitElement(element);
                element.accept((PsiElementVisitor)visitor2);
            }
        });
        return new ArrayList<PsiTypeCastExpression>(casts);
    }

    public static boolean isCastRedundant(PsiTypeCastExpression typeCast) {
        PsiElement parent = typeCast.getParent();
        PsiExpression operand2 = typeCast.getOperand();
        if (operand2 != null && operand2.getType() != null && operand2.getType().equals(typeCast.getType())) {
            return true;
        }
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiExpressionList) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiReferenceExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiAnonymousClass) {
            parent = parent.getParent();
        }
        final HashSet casts = new HashSet();
        final JavaElementVisitor visitor2 = RedundantCastUtil.createRedundantCastVisitor((Processor<? super PsiTypeCastExpression>)new CommonProcessors.CollectProcessor(casts));
        parent.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                super.visitElement(element);
                element.accept((PsiElementVisitor)visitor2);
                if (!casts.isEmpty()) {
                    this.stopWalking();
                }
            }
        });
        return casts.contains(typeCast);
    }

    public static JavaElementVisitor createRedundantCastVisitor(final Processor<? super PsiTypeCastExpression> processor2) {
        return new MyIsRedundantVisitor(){

            @Override
            protected void registerCast(@NotNull PsiTypeCastExpression typeCast) {
                processor2.process((Object)typeCast);
            }
        };
    }

    @Nullable
    private static PsiExpression deparenthesizeExpression(PsiExpression arg) {
        return PsiUtil.skipParenthesizedExprDown((PsiExpression)arg);
    }

    private static boolean isTypeCastSemantic(PsiTypeCastExpression typeCast) {
        PsiExpression stripParenthesisOperand;
        PsiExpression operand2 = typeCast.getOperand();
        if (operand2 == null) {
            return false;
        }
        if (RedundantCastUtil.isInPolymorphicCall(typeCast)) {
            return true;
        }
        PsiType opType = operand2.getType();
        PsiTypeElement typeElement = typeCast.getCastType();
        if (typeElement == null) {
            return false;
        }
        PsiType castType = typeElement.getType();
        if (castType instanceof PsiPrimitiveType) {
            if (opType instanceof PsiPrimitiveType) {
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)typeCast.getParent());
                if ((parent instanceof PsiReturnStatement || parent instanceof PsiExpressionList || parent instanceof PsiVariable || parent instanceof PsiAssignmentExpression || parent instanceof PsiArrayAccessExpression && PsiTreeUtil.isAncestor((PsiElement)((PsiArrayAccessExpression)parent).getIndexExpression(), (PsiElement)typeCast, (boolean)false)) && castType.equals(ExpectedTypeUtils.findExpectedType((PsiExpression)typeCast, false))) {
                    return !TypeConversionUtil.isSafeConversion((PsiType)castType, (PsiType)opType);
                }
                return !castType.equals(opType);
            }
            PsiPrimitiveType unboxedOpType = PsiPrimitiveType.getUnboxedType((PsiType)opType);
            if (unboxedOpType != null && !unboxedOpType.equals((Object)castType)) {
                return true;
            }
        } else if (castType instanceof PsiClassType && ((PsiClassType)castType).hasParameters() && opType instanceof PsiClassType && ((PsiClassType)opType).isRaw()) {
            return true;
        }
        if ((stripParenthesisOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2)) instanceof PsiFunctionalExpression ? RedundantCastUtil.isCastToSerializable(castType) : stripParenthesisOperand instanceof PsiConditionalExpression && (PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiConditionalExpression)stripParenthesisOperand).getThenExpression()) instanceof PsiFunctionalExpression || PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiConditionalExpression)stripParenthesisOperand).getElseExpression()) instanceof PsiFunctionalExpression)) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)typeCast.getParent());
        if (parent instanceof PsiBinaryExpression) {
            PsiBinaryExpression expression2 = (PsiBinaryExpression)parent;
            PsiExpression firstOperand = expression2.getLOperand();
            PsiExpression otherOperand = expression2.getROperand();
            if (PsiTreeUtil.isAncestor((PsiElement)otherOperand, (PsiElement)typeCast, (boolean)false)) {
                PsiExpression temp = otherOperand;
                otherOperand = firstOperand;
                firstOperand = temp;
            }
            if (otherOperand != null && RedundantCastUtil.wrapperCastChangeSemantics(firstOperand, otherOperand, operand2)) {
                return true;
            }
        } else if (parent instanceof PsiConditionalExpression) {
            if (opType instanceof PsiPrimitiveType && !(((PsiConditionalExpression)parent).getType() instanceof PsiPrimitiveType) && PsiPrimitiveType.getUnboxedType((PsiType)PsiTypesUtil.getExpectedTypeByParent((PsiElement)parent)) != null) {
                return true;
            }
        } else if (parent instanceof PsiLocalVariable) {
            return ((PsiLocalVariable)parent).getTypeElement().isInferredType();
        }
        return false;
    }

    private static boolean isCastToSerializable(PsiType castType) {
        return InheritanceUtil.isInheritor((PsiType)castType, (String)"java.io.Serializable");
    }

    private static boolean wrapperCastChangeSemantics(PsiExpression operand2, PsiExpression otherOperand, PsiExpression toCast) {
        boolean isPrimitiveComparisonWithoutCast;
        boolean isPrimitiveComparisonWithCast;
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)otherOperand.getType())) {
            isPrimitiveComparisonWithCast = TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)operand2.getType());
            isPrimitiveComparisonWithoutCast = TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)toCast.getType());
        } else {
            isPrimitiveComparisonWithCast = TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operand2.getType());
            isPrimitiveComparisonWithoutCast = TypeConversionUtil.isPrimitiveAndNotNull((PsiType)toCast.getType());
        }
        return isPrimitiveComparisonWithCast != isPrimitiveComparisonWithoutCast;
    }

    public static boolean isInPolymorphicCall(PsiTypeCastExpression typeCast) {
        PsiElement methodCall;
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)typeCast)) {
            return false;
        }
        PsiExpression operand2 = typeCast.getOperand();
        if (operand2 instanceof PsiMethodCallExpression && RedundantCastUtil.isPolymorphicMethod((PsiMethodCallExpression)operand2)) {
            return true;
        }
        PsiElement exprList = PsiUtil.skipParenthesizedExprUp((PsiElement)typeCast.getParent());
        return exprList instanceof PsiExpressionList && (methodCall = exprList.getParent()) instanceof PsiMethodCallExpression && RedundantCastUtil.isPolymorphicMethod((PsiMethodCallExpression)methodCall);
    }

    private static boolean isPolymorphicMethod(PsiMethodCallExpression expression2) {
        PsiElement method = expression2.getMethodExpression().resolve();
        return method instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiMethod)method), (String)"java.lang.invoke.MethodHandle.PolymorphicSignature", (int)0);
    }

    private static boolean areNullabilityCompatible(PsiMethod oldTargetMethod, PsiMethod newTargetMethod) {
        Nullability newNullability;
        Nullability oldNullability = NullableNotNullManager.getNullability((PsiModifierListOwner)oldTargetMethod);
        return oldNullability == (newNullability = NullableNotNullManager.getNullability((PsiModifierListOwner)newTargetMethod));
    }

    private static boolean areThrownExceptionsCompatible(PsiMethod targetMethod, PsiMethod newTargetMethod) {
        PsiClassType[] newThrowsTypes;
        PsiClassType[] oldThrowsTypes = targetMethod.getThrowsList().getReferencedTypes();
        for (PsiClassType throwsType : newThrowsTypes = newTargetMethod.getThrowsList().getReferencedTypes()) {
            if (RedundantCastUtil.isExceptionThrown(throwsType, oldThrowsTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean isExceptionThrown(PsiClassType exceptionType, PsiClassType[] thrownTypes) {
        for (PsiClassType type2 : thrownTypes) {
            if (!type2.equals((Object)exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static abstract class MyIsRedundantVisitor
    extends JavaElementVisitor {
        private MyIsRedundantVisitor() {
        }

        private void addToResults(@NotNull PsiTypeCastExpression typeCast) {
            if (!RedundantCastUtil.isTypeCastSemantic(typeCast)) {
                this.registerCast(typeCast);
            }
        }

        private void addIfNarrowing(PsiTypeCastExpression castExpression, @NotNull PsiType opType, PsiType expectedTypeByParent) {
            PsiTypeElement castElement = castExpression.getCastType();
            if (castElement != null && TypeConversionUtil.isAssignable((PsiType)castElement.getType(), (PsiType)opType, (boolean)false) && (expectedTypeByParent == null || TypeConversionUtil.isAssignable((PsiType)expectedTypeByParent, (PsiType)opType, (boolean)false))) {
                this.addToResults(castExpression);
            }
        }

        private void addIfNarrowing(PsiExpression expression2, PsiType expectedTypeByParent) {
            PsiType opType;
            PsiExpression operand2;
            if ((expression2 = RedundantCastUtil.deparenthesizeExpression(expression2)) instanceof PsiTypeCastExpression && (operand2 = MyIsRedundantVisitor.getInnerMostOperand(expression2)) != null && (opType = operand2.getType()) != null) {
                this.addIfNarrowing((PsiTypeCastExpression)expression2, opType, expectedTypeByParent);
            }
        }

        protected abstract void registerCast(@NotNull PsiTypeCastExpression var1);

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            this.processTypeCastWithExpectedType(expression2.getRExpression(), expression2.getLExpression().getType());
            super.visitAssignmentExpression(expression2);
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            PsiType type2 = expression2.getType();
            if (type2 instanceof PsiArrayType) {
                for (PsiExpression initializer : expression2.getInitializers()) {
                    this.processTypeCastWithExpectedType(initializer, ((PsiArrayType)type2).getComponentType());
                }
            }
            super.visitArrayInitializerExpression(expression2);
        }

        public void visitVariable(PsiVariable variable) {
            this.processTypeCastWithExpectedType(variable.getInitializer(), variable.getType());
            super.visitVariable(variable);
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (method != null) {
                PsiType returnType = method.getReturnType();
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue != null) {
                    this.processTypeCastWithExpectedType(returnValue, returnType);
                }
            }
            super.visitReturnStatement(statement);
        }

        private void processTypeCastWithExpectedType(PsiExpression rExpr, @Nullable PsiType lType) {
            PsiType opType;
            PsiExpression castOperand;
            if ((rExpr = RedundantCastUtil.deparenthesizeExpression(rExpr)) instanceof PsiTypeCastExpression && (castOperand = MyIsRedundantVisitor.getInnerMostOperand(rExpr)) != null && lType != null && (opType = MyIsRedundantVisitor.getOpTypeWithExpected(castOperand, lType)) != null) {
                if (castOperand instanceof PsiConditionalExpression) {
                    if (!MyIsRedundantVisitor.isApplicableForConditionalBranch(opType, ((PsiConditionalExpression)castOperand).getThenExpression())) {
                        return;
                    }
                    if (!MyIsRedundantVisitor.isApplicableForConditionalBranch(opType, ((PsiConditionalExpression)castOperand).getElseExpression())) {
                        return;
                    }
                }
                if (TypeConversionUtil.isAssignable((PsiType)lType, (PsiType)opType, (boolean)false)) {
                    if (!MyIsRedundantVisitor.isFunctionalExpressionTypePreserved((PsiTypeCastExpression)rExpr, castOperand, lType)) {
                        return;
                    }
                    this.addToResults((PsiTypeCastExpression)rExpr);
                }
            }
        }

        private static boolean isFunctionalExpressionTypePreserved(PsiTypeCastExpression typeCast, PsiExpression castOperand, @NotNull PsiType lType) {
            if (castOperand instanceof PsiFunctionalExpression) {
                PsiTypeElement typeElement = typeCast.getCastType();
                PsiType castType = typeElement != null ? typeElement.getType() : null;
                return lType.equals(castType);
            }
            return true;
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            class Processor {
                Processor() {
                }

                @Nullable
                private PsiType processBinaryExpressionOperand(PsiExpression operand2, PsiType otherType, IElementType binaryToken) {
                    PsiTypeCastExpression typeCast;
                    PsiExpression toCast;
                    if (operand2 instanceof PsiTypeCastExpression && (toCast = (typeCast = (PsiTypeCastExpression)operand2).getOperand()) != null && otherType != null && TypeConversionUtil.isBinaryOperatorApplicable((IElementType)binaryToken, (PsiType)toCast.getType(), (PsiType)otherType, (boolean)false)) {
                        MyIsRedundantVisitor.this.addToResults(typeCast);
                        return toCast.getType();
                    }
                    return operand2 != null ? operand2.getType() : null;
                }
            }
            Processor processor2 = new Processor();
            IElementType tokenType = expression2.getOperationTokenType();
            PsiExpression[] operands2 = expression2.getOperands();
            if (operands2.length >= 2) {
                PsiType lType = processor2.processBinaryExpressionOperand(RedundantCastUtil.deparenthesizeExpression(operands2[0]), operands2[1].getType(), tokenType);
                for (int i = 1; i < operands2.length; ++i) {
                    PsiExpression operand2 = RedundantCastUtil.deparenthesizeExpression(operands2[i]);
                    if (operand2 == null) continue;
                    PsiType rType = processor2.processBinaryExpressionOperand(operand2, lType, tokenType);
                    lType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)tokenType, (boolean)true);
                }
            }
            super.visitPolyadicExpression(expression2);
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            this.processCall((PsiCall)callExpression);
            super.visitCallExpression(callExpression);
        }

        public void visitEnumConstant(PsiEnumConstant enumConstant) {
            this.processCall((PsiCall)enumConstant);
            super.visitEnumConstant(enumConstant);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiExpression qualifier = RedundantCastUtil.deparenthesizeExpression(expression2.getQualifierExpression());
            if (qualifier instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCast = (PsiTypeCastExpression)qualifier;
                PsiExpression operand2 = MyIsRedundantVisitor.getInnerMostOperand(typeCast.getOperand());
                if (operand2 == null) {
                    return;
                }
                PsiTypeElement typeElement = typeCast.getCastType();
                if (typeElement == null) {
                    return;
                }
                PsiType opType = operand2.getType();
                if (opType == null) {
                    return;
                }
                if (!(operand2 instanceof PsiFunctionalExpression) && !(opType instanceof PsiPrimitiveType) && MyIsRedundantVisitor.isCastInReferenceQualifierRedundant(expression2)) {
                    this.addToResults(typeCast);
                }
            }
            super.visitReferenceExpression(expression2);
        }

        private static PsiExpression getInnerMostOperand(@Nullable PsiExpression castOperand) {
            castOperand = RedundantCastUtil.deparenthesizeExpression(castOperand);
            while (castOperand instanceof PsiTypeCastExpression) {
                castOperand = RedundantCastUtil.deparenthesizeExpression(((PsiTypeCastExpression)castOperand).getOperand());
            }
            return castOperand;
        }

        private static boolean isCastInReferenceQualifierRedundant(PsiReferenceExpression refExpression) {
            JavaResolveResult resolveResult = refExpression.advancedResolve(false);
            PsiElement oldMember = resolveResult.getElement();
            if (oldMember == null) {
                return false;
            }
            try {
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)refExpression.getParent());
                if (parent instanceof PsiMethodCallExpression) {
                    PsiMethod targetMethod = (PsiMethod)oldMember;
                    if (targetMethod.hasModifierProperty("static")) {
                        return false;
                    }
                    PsiMethodCallExpression newCall = (PsiMethodCallExpression)MyIsRedundantVisitor.copyCallExpression((PsiCall)((PsiMethodCallExpression)parent), PsiTypesUtil.getExpectedTypeByParent((PsiElement)parent));
                    if (newCall == null) {
                        return false;
                    }
                    PsiExpression newQualifier = RedundantCastUtil.deparenthesizeExpression(newCall.getMethodExpression().getQualifierExpression());
                    LOG.assertTrue(newQualifier != null);
                    PsiElement oldReference = (PsiElement)newQualifier.getCopyableUserData(RecaptureTypeMapper.SELF_REFERENCE);
                    PsiElement replace = newQualifier.replace((PsiElement)MyIsRedundantVisitor.getInnerMostOperand(newQualifier));
                    replace.putCopyableUserData(RecaptureTypeMapper.SELF_REFERENCE, (Object)oldReference);
                    JavaResolveResult newResult = newCall.getMethodExpression().advancedResolve(false);
                    if (!newResult.isValidResult()) {
                        return false;
                    }
                    PsiMethod newTargetMethod = (PsiMethod)newResult.getElement();
                    LOG.assertTrue(newTargetMethod != null, (Object)"isValidResult() check above should find this");
                    PsiType newReturnType = newCall.getType();
                    PsiType oldReturnType = ((PsiMethodCallExpression)parent).getType();
                    return Comparing.equal(newReturnType == null ? null : new RecaptureTypeMapper().mapType(newReturnType), (Object)oldReturnType) && (Comparing.equal((Object)newTargetMethod, (Object)targetMethod) || (!newTargetMethod.isDeprecated() || targetMethod.isDeprecated()) && MethodSignatureUtil.isSuperMethod((PsiMethod)newTargetMethod, (PsiMethod)targetMethod) && RedundantCastUtil.areThrownExceptionsCompatible(targetMethod, newTargetMethod) && RedundantCastUtil.areNullabilityCompatible(targetMethod, newTargetMethod));
                }
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)refExpression.getProject());
                PsiReferenceExpression newExpression = (PsiReferenceExpression)elementFactory.createExpressionFromText(refExpression.getText(), (PsiElement)refExpression);
                PsiExpression newQualifier = newExpression.getQualifierExpression();
                LOG.assertTrue(newQualifier != null);
                newQualifier.replace((PsiElement)MyIsRedundantVisitor.getInnerMostOperand(newQualifier));
                JavaResolveResult newResult = newExpression.advancedResolve(false);
                if (!newResult.isValidResult()) {
                    return false;
                }
                return oldMember.equals(newResult.getElement());
            }
            catch (IncorrectOperationException ignore) {
                return false;
            }
        }

        private void processCall(PsiCall expression2) {
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length == 0) {
                return;
            }
            JavaResolveResult oldResult = expression2.resolveMethodGenerics();
            PsiElement element = oldResult.getElement();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod oldMethod = (PsiMethod)element;
            PsiParameter[] parameters2 = oldMethod.getParameterList().getParameters();
            PsiCall newCall = null;
            for (int i = 0; i < args.length; ++i) {
                PsiExpression arg = RedundantCastUtil.deparenthesizeExpression(args[i]);
                if (!(arg instanceof PsiTypeCastExpression) && !(arg instanceof PsiLambdaExpression) && !(arg instanceof PsiConditionalExpression)) continue;
                ProgressManager.checkCanceled();
                if (newCall == null) {
                    newCall = MyIsRedundantVisitor.copyCallExpression(expression2, PsiTypesUtil.getExpectedTypeByParent((PsiElement)expression2));
                }
                if (newCall == null) {
                    return;
                }
                PsiExpressionList argList = newCall.getArgumentList();
                LOG.assertTrue(argList != null);
                PsiExpression[] newArgs = argList.getExpressions();
                LOG.assertTrue(newArgs.length == args.length, (Object)("oldCall: " + expression2.getText() + "; old length: " + args.length + "; newCall: " + newCall.getText() + "; new length: " + newArgs.length));
                if (arg instanceof PsiTypeCastExpression) {
                    this.checkTypeCastInCallArgument(i, (PsiTypeCastExpression)arg, newArgs, expression2, newCall);
                    continue;
                }
                if (arg instanceof PsiLambdaExpression) {
                    this.checkLambdaReturnsInsideCall(i, (PsiLambdaExpression)arg, newArgs, expression2, newCall, parameters2);
                    continue;
                }
                PsiType conditionalType = arg.getType();
                PsiExpression thenExpression2 = RedundantCastUtil.deparenthesizeExpression(((PsiConditionalExpression)arg).getThenExpression());
                PsiExpression elseExpression2 = RedundantCastUtil.deparenthesizeExpression(((PsiConditionalExpression)arg).getElseExpression());
                if (thenExpression2 instanceof PsiTypeCastExpression && !MyIsRedundantVisitor.castForBoxing(MyIsRedundantVisitor.getInnerMostOperand(thenExpression2), elseExpression2 != null ? elseExpression2.getType() : null, conditionalType)) {
                    PsiExpression newThenExpression = RedundantCastUtil.deparenthesizeExpression(((PsiConditionalExpression)Objects.requireNonNull(RedundantCastUtil.deparenthesizeExpression(newArgs[i]))).getThenExpression());
                    this.checkConditionalBranch(expression2, newCall, thenExpression2, newThenExpression);
                }
                if (!(elseExpression2 instanceof PsiTypeCastExpression) || MyIsRedundantVisitor.castForBoxing(MyIsRedundantVisitor.getInnerMostOperand(elseExpression2), thenExpression2 != null ? thenExpression2.getType() : null, conditionalType)) continue;
                PsiExpression newElseExpression = RedundantCastUtil.deparenthesizeExpression(((PsiConditionalExpression)Objects.requireNonNull(RedundantCastUtil.deparenthesizeExpression(newArgs[i]))).getElseExpression());
                this.checkConditionalBranch(expression2, newCall, elseExpression2, newElseExpression);
            }
        }

        private void checkConditionalBranch(PsiCall oldCall, PsiCall newCall, PsiExpression oldBranchExpression, PsiExpression newBranchExpression) {
            PsiExpression operand2 = ((PsiTypeCastExpression)newBranchExpression).getOperand();
            if (operand2 != null) {
                JavaResolveResult newResult;
                newBranchExpression = (PsiExpression)newBranchExpression.replace((PsiElement)operand2);
                JavaResolveResult oldResult = oldCall.resolveMethodGenerics();
                if (MyIsRedundantVisitor.isSameResolveResult(oldResult, newResult = MyIsRedundantVisitor.resolveNewResult(oldCall, newCall))) {
                    this.addToResults((PsiTypeCastExpression)oldBranchExpression);
                } else {
                    newBranchExpression.replace((PsiElement)oldBranchExpression);
                }
            }
        }

        private static boolean isSameResolveResult(JavaResolveResult oldResult, JavaResolveResult newResult) {
            PsiMethod oldMethod = (PsiMethod)oldResult.getElement();
            LOG.assertTrue(oldMethod != null);
            return oldMethod.equals(newResult.getElement()) && newResult.isValidResult() && (!(newResult instanceof MethodCandidateInfo) || ((MethodCandidateInfo)newResult).getInferenceErrorMessage() == null) && new RecaptureTypeMapper().recapture(newResult.getSubstitutor()).equals(oldResult.getSubstitutor());
        }

        private static boolean castForBoxing(PsiExpression operand2, PsiType oppositeType, PsiType conditionalType) {
            return operand2 != null && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)operand2.getType()) && !(oppositeType instanceof PsiPrimitiveType) && !(conditionalType instanceof PsiPrimitiveType);
        }

        private void checkLambdaReturnsInsideCall(int i, PsiLambdaExpression arg, PsiExpression[] newArgs, PsiCall oldCall, PsiCall newCall, PsiParameter[] parameters2) {
            PsiType interfaceType = arg.getFunctionalInterfaceType();
            if (interfaceType != null) {
                List expressions2 = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
                PsiLambdaExpression newLambdaExpression = (PsiLambdaExpression)RedundantCastUtil.deparenthesizeExpression(newArgs[i]);
                LOG.assertTrue(newLambdaExpression != null);
                List newReturnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)newLambdaExpression);
                for (int returnExprIdx = 0; returnExprIdx < expressions2.size(); ++returnExprIdx) {
                    ProgressManager.checkCanceled();
                    PsiExpression returnExpression2 = RedundantCastUtil.deparenthesizeExpression((PsiExpression)expressions2.get(returnExprIdx));
                    PsiExpression newReturnExpression = RedundantCastUtil.deparenthesizeExpression((PsiExpression)newReturnExpressions.get(returnExprIdx));
                    if (newReturnExpression instanceof PsiTypeCastExpression) {
                        this.checkLambdaReturn(i, (PsiTypeCastExpression)returnExpression2, (PsiTypeCastExpression)newReturnExpression, interfaceType, newLambdaExpression, oldCall, newCall, parameters2);
                        continue;
                    }
                    if (!(returnExpression2 instanceof PsiConditionalExpression)) continue;
                    LOG.assertTrue(newReturnExpression instanceof PsiConditionalExpression);
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)returnExpression2;
                    PsiConditionalExpression newConditionalExpression = (PsiConditionalExpression)newReturnExpression;
                    PsiExpression thenExpression2 = RedundantCastUtil.deparenthesizeExpression(conditionalExpression.getThenExpression());
                    PsiExpression newThenExpression = RedundantCastUtil.deparenthesizeExpression(newConditionalExpression.getThenExpression());
                    PsiExpression elseExpression2 = RedundantCastUtil.deparenthesizeExpression(conditionalExpression.getElseExpression());
                    PsiExpression newElseExpression = RedundantCastUtil.deparenthesizeExpression(newConditionalExpression.getElseExpression());
                    if (thenExpression2 instanceof PsiTypeCastExpression && !MyIsRedundantVisitor.castForBoxing(MyIsRedundantVisitor.getInnerMostOperand(thenExpression2), elseExpression2 != null ? elseExpression2.getType() : null, returnExpression2.getType())) {
                        this.checkLambdaReturn(i, (PsiTypeCastExpression)thenExpression2, (PsiTypeCastExpression)newThenExpression, interfaceType, newLambdaExpression, oldCall, newCall, parameters2);
                    }
                    if (!(elseExpression2 instanceof PsiTypeCastExpression) || MyIsRedundantVisitor.castForBoxing(MyIsRedundantVisitor.getInnerMostOperand(elseExpression2), thenExpression2 != null ? thenExpression2.getType() : null, returnExpression2.getType())) continue;
                    this.checkLambdaReturn(i, (PsiTypeCastExpression)elseExpression2, (PsiTypeCastExpression)newElseExpression, interfaceType, newLambdaExpression, oldCall, newCall, parameters2);
                }
            }
        }

        private void checkLambdaReturn(int i, PsiTypeCastExpression returnExpression2, PsiTypeCastExpression newReturnExpression, PsiType originalFunctionalInterfaceType, PsiLambdaExpression newLambdaExpression, PsiCall oldCall, PsiCall newCall, PsiParameter[] parameters2) {
            PsiType castExprType;
            PsiExpression castOperand = MyIsRedundantVisitor.getInnerMostOperand((PsiExpression)returnExpression2);
            if (castOperand == null) {
                return;
            }
            PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)originalFunctionalInterfaceType);
            if (interfaceReturnType == null || !MyIsRedundantVisitor.isFunctionalExpressionTypePreserved(returnExpression2, castOperand, interfaceReturnType)) {
                return;
            }
            PsiExpression strippedCast = (PsiExpression)newReturnExpression.replace((PsiElement)castOperand);
            PsiType newArgType = MyIsRedundantVisitor.calculateNewArgType(i, MyIsRedundantVisitor.resolveNewResult(oldCall, newCall), parameters2);
            PsiType functionalInterfaceType = newLambdaExpression.getGroundTargetType(newArgType);
            if (originalFunctionalInterfaceType.equals(functionalInterfaceType) && (castExprType = (PsiType)LambdaUtil.performWithTargetType((PsiElement)newLambdaExpression, (PsiType)functionalInterfaceType, () -> strippedCast.getType())) != null && interfaceReturnType.isAssignableFrom(castExprType)) {
                this.addToResults(returnExpression2);
                return;
            }
            strippedCast.replace((PsiElement)returnExpression2);
        }

        private void checkTypeCastInCallArgument(int i, PsiTypeCastExpression arg, PsiExpression[] newArgs, PsiCall oldCall, PsiCall newCall) {
            PsiTypeElement castTypeElement = arg.getCastType();
            PsiType castType = castTypeElement != null ? castTypeElement.getType() : null;
            PsiExpression castOperand = ((PsiTypeCastExpression)Objects.requireNonNull(RedundantCastUtil.deparenthesizeExpression(newArgs[i]))).getOperand();
            if (castOperand == null) {
                return;
            }
            newArgs[i] = (PsiExpression)newArgs[i].replace((PsiElement)castOperand);
            JavaResolveResult oldResult = oldCall.resolveMethodGenerics();
            JavaResolveResult newResult = MyIsRedundantVisitor.resolveNewResult(oldCall, newCall);
            PsiMethod oldMethod = (PsiMethod)oldResult.getElement();
            LOG.assertTrue(oldMethod != null);
            PsiParameter[] parameters2 = oldMethod.getParameterList().getParameters();
            if (i == newArgs.length - 1 && newArgs.length == parameters2.length && parameters2[i].isVarArgs() && (NullArgumentToVariableArgMethodInspection.isSuspiciousVararg(newCall, newArgs[i].getType(), () -> (PsiMethod)newResult.getElement()) || oldResult instanceof MethodCandidateInfo && newResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)oldResult).getApplicabilityLevel() != ((MethodCandidateInfo)newResult).getApplicabilityLevel())) {
                newArgs[i].replace((PsiElement)arg);
                return;
            }
            if (MyIsRedundantVisitor.isSameResolveResult(oldResult, newResult)) {
                PsiExpression newArg = PsiUtil.deparenthesizeExpression((PsiExpression)newArgs[i]);
                if (newArg instanceof PsiFunctionalExpression) {
                    PsiType newArgType = MyIsRedundantVisitor.calculateNewArgType(i, newResult, parameters2);
                    if (Comparing.equal((Object)castType, (Object)((PsiFunctionalExpression)newArg).getGroundTargetType(newArgType))) {
                        this.addToResults(arg);
                        return;
                    }
                } else if (newArg instanceof PsiCallExpression) {
                    JavaResolveResult result = ((PsiCallExpression)newArg).resolveMethodGenerics();
                    if (!(result instanceof MethodCandidateInfo) || ((MethodCandidateInfo)result).getInferenceErrorMessage() == null) {
                        this.addToResults(arg);
                        return;
                    }
                } else {
                    this.addToResults(arg);
                    return;
                }
            }
            newArgs[i].replace((PsiElement)arg);
        }

        @Nullable
        private static PsiType calculateNewArgType(int i, JavaResolveResult newResult, PsiParameter[] parameters2) {
            boolean varargs = newResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)newResult).isVarargs();
            PsiType parameterType = PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)i, (boolean)varargs);
            PsiType newArgType = newResult.getSubstitutor().substitute(parameterType);
            if (newResult instanceof MethodCandidateInfo && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)((MethodCandidateInfo)newResult).getElement(), (PsiSubstitutor)newResult.getSubstitutor())) {
                newArgType = TypeConversionUtil.erasure((PsiType)newArgType);
            }
            return newArgType;
        }

        @NotNull
        private static JavaResolveResult resolveNewResult(PsiCall oldCall, PsiCall newCall) {
            JavaResolveResult newResult;
            if (newCall instanceof PsiEnumConstant) {
                PsiEnumConstant enumConstant = (PsiEnumConstant)oldCall;
                PsiClass containingClass = enumConstant.getContainingClass();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)enumConstant.getProject());
                PsiClassType type2 = facade.getElementFactory().createType(Objects.requireNonNull(containingClass));
                newResult = facade.getResolveHelper().resolveConstructor(type2, Objects.requireNonNull(newCall.getArgumentList()), (PsiElement)enumConstant);
            } else {
                newResult = newCall.resolveMethodGenerics();
            }
            return newResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private static PsiCall copyCallExpression(PsiCall expression2, PsiType typeByParent) {
            PsiCall psiCall;
            block14: {
                PsiCall encoded;
                block10: {
                    PsiCall psiCall2;
                    block13: {
                        PsiCall callCopy;
                        Object marker;
                        block11: {
                            PsiCall psiCall3;
                            block12: {
                                block8: {
                                    PsiCall psiCall4;
                                    block9: {
                                        encoded = null;
                                        if (typeByParent == null || !PsiTypesUtil.isDenotableType((PsiType)typeByParent, (PsiElement)expression2)) break block8;
                                        encoded = expression2;
                                        RecaptureTypeMapper.encode((PsiElement)encoded);
                                        psiCall4 = (PsiCall)LambdaUtil.copyWithExpectedType((PsiElement)expression2, (PsiType)typeByParent);
                                        if (encoded == null) break block9;
                                        RecaptureTypeMapper.clean((PsiElement)encoded);
                                    }
                                    return psiCall4;
                                }
                                PsiCall call = LambdaUtil.treeWalkUp((PsiElement)expression2);
                                if (call == null) break block10;
                                encoded = call;
                                RecaptureTypeMapper.encode((PsiElement)encoded);
                                marker = new Object();
                                PsiTreeUtil.mark((PsiElement)expression2, (Object)marker);
                                callCopy = LambdaUtil.copyTopLevelCall((PsiCall)call);
                                if (callCopy != null) break block11;
                                psiCall3 = null;
                                if (encoded == null) break block12;
                                RecaptureTypeMapper.clean((PsiElement)encoded);
                            }
                            return psiCall3;
                        }
                        psiCall2 = (PsiCall)PsiTreeUtil.releaseMark((PsiElement)callCopy, (Object)marker);
                        if (encoded == null) break block13;
                        RecaptureTypeMapper.clean((PsiElement)encoded);
                    }
                    return psiCall2;
                }
                try {
                    encoded = expression2;
                    RecaptureTypeMapper.encode((PsiElement)encoded);
                    psiCall = (PsiCall)expression2.copy();
                    if (encoded == null) break block14;
                }
                catch (IllegalArgumentException e) {
                    PsiCall psiCall5;
                    block15: {
                        try {
                            psiCall5 = null;
                            if (encoded == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (encoded != null) {
                                RecaptureTypeMapper.clean(encoded);
                            }
                            throw throwable;
                        }
                        RecaptureTypeMapper.clean((PsiElement)encoded);
                    }
                    return psiCall5;
                }
                RecaptureTypeMapper.clean((PsiElement)encoded);
            }
            return psiCall;
        }

        public void visitTypeCastExpression(PsiTypeCastExpression typeCast) {
            PsiExpression operand2 = typeCast.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiExpression expr2 = RedundantCastUtil.deparenthesizeExpression(operand2);
            PsiType topCastType = typeCast.getType();
            if (expr2 instanceof PsiTypeCastExpression) {
                PsiType operandType;
                PsiTypeCastExpression innerCast = (PsiTypeCastExpression)expr2;
                PsiTypeElement typeElement = innerCast.getCastType();
                if (typeElement == null) {
                    return;
                }
                PsiType castType = typeElement.getType();
                PsiExpression innerOperand = innerCast.getOperand();
                PsiType psiType = operandType = innerOperand != null ? innerOperand.getType() : null;
                if (!(castType instanceof PsiPrimitiveType) && !(topCastType instanceof PsiPrimitiveType)) {
                    if (operandType != null && topCastType != null && TypeConversionUtil.areTypesConvertible((PsiType)operandType, (PsiType)topCastType)) {
                        this.addToResults(innerCast);
                    }
                } else if (Comparing.equal((Object)PsiPrimitiveType.getUnboxedType((PsiType)operandType), (Object)topCastType)) {
                    this.addToResults(innerCast);
                } else if (operandType != null && operandType.equals(castType)) {
                    this.addToResults(innerCast);
                }
            }
            super.visitTypeCastExpression(typeCast);
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            PsiType collectionItemType;
            PsiExpression operand2;
            PsiExpression iteratedValue2 = RedundantCastUtil.deparenthesizeExpression(statement.getIteratedValue());
            if (iteratedValue2 instanceof PsiTypeCastExpression && (operand2 = ((PsiTypeCastExpression)iteratedValue2).getOperand()) != null && (collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)operand2.getType(), (GlobalSearchScope)statement.getResolveScope())) != null && TypeConversionUtil.isAssignable((PsiType)statement.getIterationParameter().getType(), (PsiType)collectionItemType)) {
                this.addToResults((PsiTypeCastExpression)iteratedValue2);
            }
            super.visitForeachStatement(statement);
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
            PsiType opType;
            PsiExpression operand2;
            PsiTypeElement checkTypeElement = expression2.getCheckType();
            if (checkTypeElement == null) {
                return;
            }
            PsiExpression typeCast = RedundantCastUtil.deparenthesizeExpression(expression2.getOperand());
            if (typeCast instanceof PsiTypeCastExpression && (operand2 = MyIsRedundantVisitor.getInnerMostOperand(((PsiTypeCastExpression)typeCast).getOperand())) != null && (opType = operand2.getType()) != null && !(opType instanceof PsiPrimitiveType) && TypeConversionUtil.areTypesConvertible((PsiType)opType, (PsiType)checkTypeElement.getType())) {
                this.addToResults((PsiTypeCastExpression)typeCast);
            }
            super.visitInstanceOfExpression(expression2);
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            PsiExpression operand2;
            PsiExpression typeCast = RedundantCastUtil.deparenthesizeExpression(statement.getException());
            if (typeCast instanceof PsiTypeCastExpression && (operand2 = MyIsRedundantVisitor.getInnerMostOperand(((PsiTypeCastExpression)typeCast).getOperand())) != null) {
                PsiType opType = operand2.getType();
                PsiClass thrownClass = PsiUtil.resolveClassInType((PsiType)opType);
                if (InheritanceUtil.isInheritor((PsiClass)thrownClass, (boolean)false, (String)"java.lang.RuntimeException")) {
                    this.addToResults((PsiTypeCastExpression)typeCast);
                }
                if (InheritanceUtil.isInheritor((PsiClass)thrownClass, (boolean)false, (String)"java.lang.Throwable")) {
                    PsiParameterListOwner listOwner = (PsiParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                    if (listOwner instanceof PsiMethod) {
                        this.processThrowsList((PsiMethod)listOwner, PsiSubstitutor.EMPTY, (PsiTypeCastExpression)typeCast, opType);
                    } else if (listOwner instanceof PsiLambdaExpression) {
                        PsiType functionalInterfaceType = ((PsiLambdaExpression)listOwner).getFunctionalInterfaceType();
                        PsiClassType.ClassResolveResult functionalInterfaceResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                        if (interfaceMethod != null) {
                            this.processThrowsList(interfaceMethod, LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)functionalInterfaceResolveResult), (PsiTypeCastExpression)typeCast, opType);
                        }
                    }
                }
            }
            super.visitThrowStatement(statement);
        }

        private void processThrowsList(PsiMethod interfaceMethod, PsiSubstitutor psiSubstitutor, PsiTypeCastExpression typeCast, PsiType opType) {
            for (PsiClassType thrownType : interfaceMethod.getThrowsList().getReferencedTypes()) {
                PsiType left = psiSubstitutor.substitute((PsiType)thrownType);
                if (left == null || !TypeConversionUtil.isAssignable((PsiType)left, (PsiType)opType, (boolean)false)) continue;
                this.addToResults(typeCast);
            }
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
            PsiExpression operand2;
            PsiExpression lockExpression2 = RedundantCastUtil.deparenthesizeExpression(statement.getLockExpression());
            if (lockExpression2 instanceof PsiTypeCastExpression && (operand2 = MyIsRedundantVisitor.getInnerMostOperand(((PsiTypeCastExpression)lockExpression2).getOperand())) != null) {
                PsiType opType = operand2.getType();
                if (!(operand2 instanceof PsiFunctionalExpression) && !(opType instanceof PsiPrimitiveType) && opType != null) {
                    this.addIfNarrowing((PsiTypeCastExpression)lockExpression2, opType, null);
                }
            }
            super.visitSynchronizedStatement(statement);
        }

        public void visitSwitchStatement(PsiSwitchStatement statement) {
            this.visitSwitchBlockSelector((PsiSwitchBlock)statement);
            super.visitSwitchStatement(statement);
        }

        public void visitSwitchExpression(PsiSwitchExpression expression2) {
            this.visitSwitchBlockSelector((PsiSwitchBlock)expression2);
            PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)expression2);
            for (PsiExpression resultExpression : PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)expression2)) {
                this.addIfNarrowing(resultExpression, expectedTypeByParent);
            }
            super.visitSwitchExpression(expression2);
        }

        private void visitSwitchBlockSelector(PsiSwitchBlock expression2) {
            PsiExpression operand2;
            PsiExpression switchVariable = RedundantCastUtil.deparenthesizeExpression(expression2.getExpression());
            if (switchVariable instanceof PsiTypeCastExpression && (operand2 = ((PsiTypeCastExpression)switchVariable).getOperand()) != null) {
                PsiClass aClass;
                PsiType opType = operand2.getType();
                if (opType instanceof PsiClassType && PsiPrimitiveType.getUnboxedType((PsiType)opType) == null && !opType.equalsToText("java.lang.String") && (aClass = ((PsiClassType)opType).resolve()) != null && !aClass.isEnum()) {
                    return;
                }
                if (opType != null) {
                    this.addIfNarrowing((PsiTypeCastExpression)switchVariable, opType, null);
                }
            }
        }

        public void visitAssertStatement(PsiAssertStatement statement) {
            this.addIfNarrowing(statement.getAssertCondition(), (PsiType)PsiType.BOOLEAN);
            this.addIfNarrowing(statement.getAssertDescription(), (PsiType)PsiType.getJavaLangString((PsiManager)statement.getManager(), (GlobalSearchScope)statement.getResolveScope()));
            super.visitAssertStatement(statement);
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            this.addIfNarrowing(statement.getCondition(), (PsiType)PsiType.BOOLEAN);
            super.visitDoWhileStatement(statement);
        }

        public void visitIfStatement(PsiIfStatement statement) {
            this.addIfNarrowing(statement.getCondition(), (PsiType)PsiType.BOOLEAN);
            super.visitIfStatement(statement);
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            this.addIfNarrowing(statement.getCondition(), (PsiType)PsiType.BOOLEAN);
            super.visitWhileStatement(statement);
        }

        public void visitResourceExpression(PsiResourceExpression expression2) {
            this.addIfNarrowing(expression2.getExpression(), null);
            super.visitResourceExpression(expression2);
        }

        public void visitExpressionStatement(PsiExpressionStatement statement) {
            if (!(statement.getParent() instanceof PsiSwitchLabeledRuleStatement)) {
                this.addIfNarrowing(statement.getExpression(), null);
            }
            super.visitExpressionStatement(statement);
        }

        public void visitNameValuePair(PsiNameValuePair pair2) {
            PsiAnnotationMemberValue value2 = pair2.getValue();
            if (value2 instanceof PsiExpression) {
                this.addIfNarrowing((PsiExpression)value2, null);
            }
            super.visitNameValuePair(pair2);
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
            PsiType returnType;
            PsiMethod method;
            if (!(PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent()) instanceof PsiExpressionList) && (method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)expression2)) != null && (returnType = method.getReturnType()) != null) {
                List returns = LambdaUtil.getReturnExpressions((PsiLambdaExpression)expression2);
                for (PsiExpression aReturn : returns) {
                    PsiExpression operand2;
                    PsiExpression returnInLambda = RedundantCastUtil.deparenthesizeExpression(aReturn);
                    if (!(returnInLambda instanceof PsiTypeCastExpression) || (operand2 = MyIsRedundantVisitor.getInnerMostOperand(returnInLambda)) == null || !returnType.equals(operand2.getType())) continue;
                    this.addToResults((PsiTypeCastExpression)returnInLambda);
                }
            }
            super.visitLambdaExpression(expression2);
        }

        public void visitConditionalExpression(PsiConditionalExpression conditionalExpression) {
            PsiElement gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)conditionalExpression.getParent());
            if (gParent instanceof PsiLambdaExpression) {
                return;
            }
            if (gParent instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType((PsiElement)gParent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class}) instanceof PsiLambdaExpression) {
                return;
            }
            if (!(gParent instanceof PsiExpressionList)) {
                PsiExpression thenExpression2 = RedundantCastUtil.deparenthesizeExpression(conditionalExpression.getThenExpression());
                PsiExpression elseExpression2 = RedundantCastUtil.deparenthesizeExpression(conditionalExpression.getElseExpression());
                if (thenExpression2 instanceof PsiTypeCastExpression) {
                    this.visitConditional((PsiTypeCastExpression)thenExpression2, conditionalExpression, MyIsRedundantVisitor.getInnerMostOperand(elseExpression2));
                }
                if (elseExpression2 instanceof PsiTypeCastExpression) {
                    this.visitConditional((PsiTypeCastExpression)elseExpression2, conditionalExpression, MyIsRedundantVisitor.getInnerMostOperand(RedundantCastUtil.deparenthesizeExpression(conditionalExpression.getThenExpression())));
                }
            }
            this.addIfNarrowing(conditionalExpression.getCondition(), (PsiType)PsiType.BOOLEAN);
            super.visitConditionalExpression(conditionalExpression);
        }

        private void visitConditional(PsiTypeCastExpression typeCast, @NotNull PsiConditionalExpression parent, @Nullable PsiExpression oppositeOperand) {
            PsiExpression operand2 = MyIsRedundantVisitor.getInnerMostOperand(typeCast.getOperand());
            if (operand2 == null) {
                return;
            }
            PsiType castTo = typeCast.getType();
            if (castTo == null) {
                return;
            }
            PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)parent);
            if (operand2 instanceof PsiFunctionalExpression && !castTo.equals(expectedTypeByParent)) {
                return;
            }
            PsiType opType = operand2.getType();
            if (opType == null) {
                return;
            }
            if (castTo instanceof PsiClassType && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)opType) && oppositeOperand != null && !(oppositeOperand.getType() instanceof PsiPrimitiveType) && !(expectedTypeByParent instanceof PsiPrimitiveType)) {
                return;
            }
            PsiType conditionalType = parent.getType();
            if (!Comparing.equal((Object)opType, (Object)conditionalType)) {
                if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)typeCast)) {
                    return;
                }
                if (!(PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent) || oppositeOperand != null && Comparing.equal((Object)conditionalType, (Object)oppositeOperand.getType()))) {
                    return;
                }
            }
            this.addIfNarrowing(typeCast, opType, expectedTypeByParent);
        }

        private static PsiType getOpTypeWithExpected(PsiExpression operand2, PsiType expectedTypeByParent) {
            PsiType opType = operand2.getType();
            if (expectedTypeByParent != null && !(operand2 instanceof PsiFunctionalExpression)) {
                try {
                    JavaResolveResult newResult;
                    PsiExpression initializer = (PsiExpression)LambdaUtil.copyWithExpectedType((PsiElement)operand2, (PsiType)expectedTypeByParent);
                    opType = initializer.getType();
                    if (initializer instanceof PsiMethodCallExpression && (newResult = ((PsiMethodCallExpression)initializer).resolveMethodGenerics()) instanceof MethodCandidateInfo && ((MethodCandidateInfo)newResult).getInferenceErrorMessage() != null) {
                        return null;
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    // empty catch block
                }
            }
            return opType;
        }

        private static boolean isApplicableForConditionalBranch(PsiType opType, PsiExpression thenExpression2) {
            PsiType thenType;
            return thenExpression2 == null || (thenType = thenExpression2.getType()) == null || TypeConversionUtil.isAssignable((PsiType)opType, (PsiType)thenType);
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
            PsiType opType;
            PsiExpression indexExpression;
            PsiExpression operand2;
            PsiExpression arrayExpression = RedundantCastUtil.deparenthesizeExpression(expression2.getArrayExpression());
            if (arrayExpression instanceof PsiTypeCastExpression) {
                PsiTypeElement castTypeElement = ((PsiTypeCastExpression)arrayExpression).getCastType();
                operand2 = ((PsiTypeCastExpression)arrayExpression).getOperand();
                if (castTypeElement != null && operand2 != null && PsiUtil.isAccessedForWriting((PsiExpression)expression2)) {
                    PsiType castTo = castTypeElement.getType();
                    PsiType opType2 = operand2.getType();
                    if (opType2 != null && TypeConversionUtil.isAssignable((PsiType)opType2, (PsiType)castTo, (boolean)false) && opType2.getArrayDimensions() == castTo.getArrayDimensions()) {
                        this.addToResults((PsiTypeCastExpression)arrayExpression);
                    }
                }
            }
            if ((indexExpression = RedundantCastUtil.deparenthesizeExpression(expression2.getIndexExpression())) instanceof PsiTypeCastExpression && (operand2 = ((PsiTypeCastExpression)indexExpression).getOperand()) != null && (opType = operand2.getType()) != null) {
                this.addIfNarrowing((PsiTypeCastExpression)indexExpression, opType, null);
            }
            super.visitArrayAccessExpression(expression2);
        }
    }
}

