/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AccessModifier {
    PUBLIC("public"),
    PROTECTED("protected"),
    PACKAGE_LOCAL("packageLocal"),
    PRIVATE("private");

    public static final List<AccessModifier> ALL_MODIFIERS;
    private static final List<AccessModifier> PUBLIC_PACKAGE;
    private static final List<AccessModifier> PUBLIC_PRIVATE;
    @NotNull
    @PsiModifier.ModifierConstant
    private final String myModifier;

    private AccessModifier(String modifier) {
        this.myModifier = modifier;
    }

    @NotNull
    @PsiModifier.ModifierConstant
    public String toPsiModifier() {
        return this.myModifier;
    }

    public boolean hasModifier(@NotNull PsiModifierListOwner owner2) {
        return owner2.hasModifierProperty(this.toPsiModifier());
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static AccessModifier fromKeyword(@Nullable PsiKeyword keyword) {
        return keyword == null ? null : AccessModifier.fromPsiModifier(keyword.getText());
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static AccessModifier fromPsiModifier(@Nullable String modifier) {
        if (modifier == null) {
            return null;
        }
        switch (modifier) {
            case "public": {
                return PUBLIC;
            }
            case "protected": {
                return PROTECTED;
            }
            case "packageLocal": {
                return PACKAGE_LOCAL;
            }
            case "private": {
                return PRIVATE;
            }
        }
        return null;
    }

    public static AccessModifier fromModifierList(@NotNull PsiModifierList modifierList) {
        if (modifierList.hasModifierProperty("private")) {
            return PRIVATE;
        }
        if (modifierList.hasModifierProperty("packageLocal")) {
            return PACKAGE_LOCAL;
        }
        if (modifierList.hasModifierProperty("protected")) {
            return PROTECTED;
        }
        return PUBLIC;
    }

    public boolean isWeaker(@NotNull AccessModifier other) {
        return this.compareTo(other) < 0;
    }

    public String toString() {
        String psiModifier = this.toPsiModifier();
        return psiModifier.equals(AccessModifier.PACKAGE_LOCAL.myModifier) ? "package-private" : psiModifier;
    }

    @NotNull
    public static List<AccessModifier> getAvailableModifiers(PsiMember member) {
        if (member == null) {
            return Collections.emptyList();
        }
        PsiClass containingClass = member.getContainingClass();
        if (member instanceof PsiField) {
            if (member instanceof PsiEnumConstant || containingClass == null || containingClass.isInterface()) {
                return Collections.emptyList();
            }
            return ALL_MODIFIERS;
        }
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            if (containingClass == null || containingClass.isEnum() && method.isConstructor()) {
                return Collections.emptyList();
            }
            if (JavaPsiRecordUtil.getRecordComponentForAccessor(method) != null) {
                return Collections.singletonList(PUBLIC);
            }
            if (JavaPsiRecordUtil.isCompactConstructor(method) || JavaPsiRecordUtil.isExplicitCanonicalConstructor(method) || method instanceof LightRecordCanonicalConstructor) {
                PsiModifierList list;
                if (PsiUtil.getLanguageLevel((PsiElement)member) != LanguageLevel.JDK_14_PREVIEW && (list = containingClass.getModifierList()) != null) {
                    AccessModifier classModifier = AccessModifier.fromModifierList(list);
                    return ContainerUtil.filter(ALL_MODIFIERS, m -> !classModifier.isWeaker((AccessModifier)((Object)m)));
                }
                return Collections.singletonList(PUBLIC);
            }
            if (containingClass.isInterface()) {
                if (method.getBody() != null && PsiUtil.isLanguageLevel9OrHigher((PsiElement)member)) {
                    return PUBLIC_PRIVATE;
                }
                return Collections.singletonList(PUBLIC);
            }
            AccessModifier minAccess = AccessModifier.getMinAccess(method);
            if (minAccess != PRIVATE) {
                return ContainerUtil.filter(ALL_MODIFIERS, mod -> mod.compareTo(minAccess) <= 0);
            }
            return ALL_MODIFIERS;
        }
        if (member instanceof PsiClass) {
            if (PsiUtil.isLocalOrAnonymousClass((PsiClass)((PsiClass)member))) {
                return Collections.emptyList();
            }
            if (containingClass == null) {
                return PUBLIC_PACKAGE;
            }
            return ALL_MODIFIERS;
        }
        return Collections.emptyList();
    }

    @NotNull
    private static AccessModifier getMinAccess(PsiMethod method) {
        HierarchicalMethodSignature superSignature;
        PsiMethod superMethod;
        AccessModifier current;
        if (method.isConstructor() || method.hasModifierProperty("static")) {
            return PRIVATE;
        }
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        AccessModifier lowest = PRIVATE;
        Iterator iterator = signature.getSuperSignatures().iterator();
        while (iterator.hasNext() && (!(current = AccessModifier.fromModifierList((superMethod = (superSignature = (HierarchicalMethodSignature)iterator.next()).getMethod()).getModifierList())).isWeaker(lowest) || method.hasModifierProperty("abstract") && !MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method) || !PsiUtil.isAccessible((Project)method.getProject(), (PsiMember)superMethod, (PsiElement)method, null) || (lowest = current) != PUBLIC)) {
        }
        return lowest;
    }

    static {
        ALL_MODIFIERS = ContainerUtil.immutableList((Object[])AccessModifier.values());
        PUBLIC_PACKAGE = ContainerUtil.immutableList((Object[])new AccessModifier[]{PUBLIC, PACKAGE_LOCAL});
        PUBLIC_PRIVATE = ContainerUtil.immutableList((Object[])new AccessModifier[]{PUBLIC, PRIVATE});
    }
}

