/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.impl.PsiLiteralStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.text.LiteralFormatUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLiteralExpressionImpl
extends JavaStubPsiElement<PsiLiteralStub>
implements PsiLiteralExpression,
PsiLanguageInjectionHost,
ContributedReferenceHost {
    private static final TokenSet NUMERIC_LITERALS = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.INTEGER_LITERALS, ElementType.REAL_LITERALS});

    public PsiLiteralExpressionImpl(@NotNull PsiLiteralStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.LITERAL_EXPRESSION);
    }

    public PsiLiteralExpressionImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        return ((CompositeElement)this.getNode()).getChildrenAsPsiElements((TokenSet)null, PsiElement.ARRAY_FACTORY);
    }

    public PsiType getType() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            return PsiType.INT;
        }
        if (type2 == JavaTokenType.LONG_LITERAL) {
            return PsiType.LONG;
        }
        if (type2 == JavaTokenType.FLOAT_LITERAL) {
            return PsiType.FLOAT;
        }
        if (type2 == JavaTokenType.DOUBLE_LITERAL) {
            return PsiType.DOUBLE;
        }
        if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            return PsiType.CHAR;
        }
        if (ElementType.STRING_LITERALS.contains(type2)) {
            PsiFile file = this.getContainingFile();
            return PsiType.getJavaLangString((PsiManager)file.getManager(), (GlobalSearchScope)ResolveScopeManager.getElementResolveScope((PsiElement)file));
        }
        if (type2 == JavaTokenType.TRUE_KEYWORD || type2 == JavaTokenType.FALSE_KEYWORD) {
            return PsiType.BOOLEAN;
        }
        if (type2 == JavaTokenType.NULL_KEYWORD) {
            return PsiType.NULL;
        }
        return null;
    }

    public boolean isTextBlock() {
        return this.getLiteralElementType() == JavaTokenType.TEXT_BLOCK_LITERAL;
    }

    public IElementType getLiteralElementType() {
        PsiLiteralStub stub = (PsiLiteralStub)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralType();
        }
        return this.getNode().getFirstChildNode().getElementType();
    }

    public String getCanonicalText() {
        IElementType type2 = this.getLiteralElementType();
        return NUMERIC_LITERALS.contains(type2) ? LiteralFormatUtil.removeUnderscores(this.getText()) : this.getText();
    }

    public String getText() {
        PsiLiteralStub stub = (PsiLiteralStub)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralText();
        }
        return super.getText();
    }

    public Object getValue() {
        IElementType type2 = this.getLiteralElementType();
        if (type2 == JavaTokenType.TRUE_KEYWORD) {
            return Boolean.TRUE;
        }
        if (type2 == JavaTokenType.FALSE_KEYWORD) {
            return Boolean.FALSE;
        }
        if (type2 == JavaTokenType.STRING_LITERAL) {
            return PsiLiteralExpressionImpl.internedParseStringCharacters(PsiLiteralUtil.getStringLiteralContent((PsiLiteralExpression)this));
        }
        if (type2 == JavaTokenType.TEXT_BLOCK_LITERAL) {
            return PsiLiteralExpressionImpl.internedParseStringCharacters(PsiLiteralUtil.getTextBlockText((PsiLiteralExpression)this));
        }
        String text2 = NUMERIC_LITERALS.contains(type2) ? StringUtil.toLowerCase((String)this.getCanonicalText()) : this.getCanonicalText();
        int textLength = text2.length();
        if (type2 == JavaTokenType.INTEGER_LITERAL) {
            return PsiLiteralUtil.parseInteger((String)text2);
        }
        if (type2 == JavaTokenType.LONG_LITERAL) {
            return PsiLiteralUtil.parseLong((String)text2);
        }
        if (type2 == JavaTokenType.FLOAT_LITERAL) {
            return PsiLiteralUtil.parseFloat((String)text2);
        }
        if (type2 == JavaTokenType.DOUBLE_LITERAL) {
            return PsiLiteralUtil.parseDouble((String)text2);
        }
        if (type2 == JavaTokenType.CHARACTER_LITERAL) {
            StringBuilder chars;
            if (textLength == 1 || !StringUtil.endsWithChar((CharSequence)text2, (char)'\'')) {
                return null;
            }
            boolean success = PsiLiteralExpressionImpl.parseStringCharacters(text2 = text2.substring(1, textLength - 1), chars = new StringBuilder(), null);
            if (!success) {
                return null;
            }
            if (chars.length() != 1) {
                return null;
            }
            return Character.valueOf(chars.charAt(0));
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    @Nullable
    public String getInnerText() {
        return PsiLiteralUtil.getStringLiteralContent((PsiLiteralExpression)this);
    }

    @Nullable
    private static String internedParseStringCharacters(String chars) {
        if (chars == null) {
            return null;
        }
        StringBuilder outChars = new StringBuilder(chars.length());
        boolean success = PsiLiteralExpressionImpl.parseStringCharacters(chars, outChars, null);
        return success ? outChars.toString() : null;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, int @Nullable [] sourceOffsets) {
        return CodeInsightUtilCore.parseStringCharacters((String)chars, (StringBuilder)outChars, (int[])sourceOffsets);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitLiteralExpression((PsiLiteralExpression)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiLiteralExpression:" + this.getText();
    }

    public boolean isValidHost() {
        return ElementType.TEXT_LITERALS.contains(this.getLiteralElementType());
    }

    public PsiReference @NotNull [] getReferences() {
        IElementType type2 = this.getLiteralElementType();
        return ElementType.STRING_LITERALS.contains(type2) || type2 == JavaTokenType.INTEGER_LITERAL ? PsiReferenceService.getService().getContributedReferences((PsiElement)this) : PsiReference.EMPTY_ARRAY;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text2);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<PsiLiteralExpressionImpl> createLiteralTextEscaper() {
        return new StringLiteralEscaper<PsiLiteralExpressionImpl>(this);
    }
}

