/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiExpressionStatementImpl
extends CompositePsiElement
implements PsiExpressionStatement {
    private static final Logger LOG = Logger.getInstance(PsiExpressionStatementImpl.class);

    public PsiExpressionStatementImpl() {
        super(JavaElementType.EXPRESSION_STATEMENT);
    }

    @NotNull
    public PsiExpression getExpression() {
        PsiExpression expression2 = (PsiExpression)SourceTreeToPsiMap.treeElementToPsi((ASTNode)this.findChildByType(ElementType.EXPRESSION_BIT_SET));
        if (expression2 != null) {
            return expression2;
        }
        LOG.error("Illegal PSI: \n" + DebugUtil.psiToString((PsiElement)this.getParent(), (boolean)false));
        return null;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 64: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward((ASTNode)this, (IElementType)JavaTokenType.SEMICOLON);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.SEMICOLON) {
            return 22;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 64;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitExpressionStatement((PsiExpressionStatement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiExpressionStatement";
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (this.getChildRole(child) == 64) {
            this.getTreeParent().deleteChildInternal((ASTNode)this);
        } else {
            super.deleteChildInternal(child);
        }
    }
}

