/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class PsiDeclarationStatementImpl
extends CompositePsiElement
implements PsiDeclarationStatement {
    private static final TokenSet DECLARED_ELEMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.LOCAL_VARIABLE, JavaElementType.CLASS});

    public PsiDeclarationStatementImpl() {
        super(JavaElementType.DECLARATION_STATEMENT);
    }

    public PsiElement @NotNull [] getDeclaredElements() {
        return this.getChildrenAsPsiElements(DECLARED_ELEMENT_BIT_SET, PsiElement.ARRAY_FACTORY);
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child.getElementType() == JavaTokenType.COMMA) {
            return 23;
        }
        return super.getChildRole(child);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        TreeElement next;
        if (DECLARED_ELEMENT_BIT_SET.contains(child.getElementType())) {
            PsiElement[] declaredElements = this.getDeclaredElements();
            int length = declaredElements.length;
            if (length == 1) {
                this.getTreeParent().deleteChildInternal((ASTNode)this);
                return;
            }
            if (length > 0) {
                if (SourceTreeToPsiMap.psiElementToTree((PsiElement)declaredElements[length - 1]) == child) {
                    this.removeCommaBefore(child);
                    CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)this);
                    LeafElement semicolon = Factory.createSingleLeafElement((IElementType)JavaTokenType.SEMICOLON, (CharSequence)";", (CharTable)charTable, (PsiManager)this.getManager());
                    SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)declaredElements[length - 2]).addChild((ASTNode)semicolon, null);
                } else if (SourceTreeToPsiMap.psiElementToTree((PsiElement)declaredElements[0]) == child) {
                    next = (CompositeElement)SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)declaredElements[1]);
                    ASTNode copyChild = child.copyElement();
                    ASTNode nameChild = ((CompositeElement)copyChild).findChildByRole(9);
                    assert (nameChild != null);
                    this.removeCommaBefore((ASTNode)next);
                    next.addInternal((TreeElement)copyChild.getFirstChildNode(), nameChild.getTreePrev(), null, Boolean.FALSE);
                } else {
                    this.removeCommaBefore(child);
                }
            }
        }
        super.deleteChildInternal(child);
        TreeElement first = this.getFirstChildNode();
        if (first != null && !DECLARED_ELEMENT_BIT_SET.contains(first.getElementType())) {
            TreeElement last = first;
            while ((next = last.getTreeNext()) != null && !DECLARED_ELEMENT_BIT_SET.contains(next.getElementType())) {
                last = next;
            }
            this.getTreeParent().addInternal(first, (ASTNode)last, (ASTNode)this, Boolean.TRUE);
        }
    }

    private void removeCommaBefore(ASTNode child) {
        ASTNode prev = child;
        while ((prev = prev.getTreePrev()) != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(prev.getElementType())) {
        }
        if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
            this.deleteChildInternal(prev);
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitDeclarationStatement((PsiDeclarationStatement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        for (PsiElement element : this.getDeclaredElements()) {
            if (element != lastParent) {
                if (processor2.execute(element, state)) continue;
                return false;
            }
            ElementClassHint hint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
            if (!(lastParent instanceof PsiClass) || hint != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS) || processor2.execute(lastParent, state)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "PsiDeclarationStatement";
    }
}

