/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiLabelReference;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiContinueStatementImpl
extends CompositePsiElement
implements PsiContinueStatement {
    private static final Logger LOG = Logger.getInstance(PsiContinueStatementImpl.class);

    public PsiContinueStatementImpl() {
        super(JavaElementType.CONTINUE_STATEMENT);
    }

    public PsiIdentifier getLabelIdentifier() {
        return (PsiIdentifier)this.findPsiChildByType(JavaTokenType.IDENTIFIER);
    }

    public PsiStatement findContinuedStatement() {
        PsiIdentifier label = this.getLabelIdentifier();
        if (label != null) {
            PsiLabeledStatement labeled = PsiImplUtil.findEnclosingLabeledStatement((PsiElement)this, label.getText());
            return labeled != null ? labeled.getStatement() : null;
        }
        return PsiImplUtil.findEnclosingLoop((PsiElement)this);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 82: {
                return this.findChildByType(JavaTokenType.CONTINUE_KEYWORD);
            }
            case 83: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 22: {
                return TreeUtil.findChildBackward((ASTNode)this, (IElementType)JavaTokenType.SEMICOLON);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.CONTINUE_KEYWORD) {
            return 82;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return 83;
        }
        if (i == JavaTokenType.SEMICOLON) {
            return 22;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitContinueStatement((PsiContinueStatement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public PsiReference getReference() {
        PsiIdentifier label = this.getLabelIdentifier();
        return label != null ? new PsiLabelReference((PsiStatement)this, label) : null;
    }

    public String toString() {
        return "PsiContinueStatement";
    }
}

