/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLangInvokeHandleReference
extends PsiReferenceBase<PsiLiteralExpression>
implements InsertHandler<LookupElement> {
    private final PsiExpression myContext;

    public JavaLangInvokeHandleReference(@NotNull PsiLiteralExpression literal, @NotNull PsiExpression context) {
        super((PsiElement)literal);
        this.myContext = context;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return element;
    }

    @Nullable
    public PsiElement resolve() {
        Object value2 = ((PsiLiteralExpression)this.myElement).getValue();
        if (value2 instanceof String) {
            JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
            String name2 = (String)value2;
            String type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement);
            if (type2 != null && (ownerClass = JavaReflectionReferenceUtil.getReflectiveClass(this.myContext)) != null) {
                switch (type2) {
                    case "findGetter": 
                    case "findSetter": {
                        return JavaLangInvokeHandleReference.resolveField(name2, ownerClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isNonStaticField));
                    }
                    case "findStaticGetter": 
                    case "findStaticSetter": {
                        return JavaLangInvokeHandleReference.resolveField(name2, ownerClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isStaticField));
                    }
                    case "findVirtual": 
                    case "findSpecial": {
                        return this.resolveMethod(name2, ownerClass, (Condition<? super PsiMethod>)((Condition)JavaLangInvokeHandleReference::isNonStaticMethod));
                    }
                    case "findStatic": {
                        return this.resolveMethod(name2, ownerClass, (Condition<? super PsiMethod>)((Condition)JavaLangInvokeHandleReference::isStaticMethod));
                    }
                    case "findVarHandle": {
                        return JavaLangInvokeHandleReference.resolveField(name2, ownerClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isNonStaticField));
                    }
                    case "findStaticVarHandle": {
                        return JavaLangInvokeHandleReference.resolveField(name2, ownerClass, (Condition<? super PsiField>)((Condition)JavaLangInvokeHandleReference::isStaticField));
                    }
                }
            }
        }
        return null;
    }

    private static PsiElement resolveField(@NotNull String name2, @NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Condition<? super PsiField> filter) {
        PsiField field = ownerClass.getPsiClass().findFieldByName(name2, true);
        return field != null && filter.value((Object)field) ? field : null;
    }

    private PsiElement resolveMethod(@NotNull String name2, @NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Condition<? super PsiMethod> filter) {
        PsiExpression typeExpression;
        JavaReflectionReferenceUtil.ReflectiveSignature expectedSignature;
        PsiExpression[] arguments;
        PsiMethodCallExpression definitionCall;
        Object[] methods = ownerClass.getPsiClass().findMethodsByName(name2, true);
        if (methods.length != 0 && (methods = ContainerUtil.filter((Object[])methods, filter).toArray(PsiMethod.EMPTY_ARRAY)).length > 1 && (definitionCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiMethodCallExpression.class)) != null && (arguments = definitionCall.getArgumentList().getExpressions()).length > 2 && (expectedSignature = JavaReflectionReferenceUtil.composeMethodSignature(typeExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[2]))) != null) {
            return (PsiElement)ContainerUtil.find((Object[])methods, method -> expectedSignature.equals(JavaReflectionReferenceUtil.getMethodSignature(method)));
        }
        return methods.length != 0 ? methods[0] : null;
    }

    public Object @NotNull [] getVariants() {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        String type2;
        Object value2 = ((PsiLiteralExpression)this.myElement).getValue();
        if (value2 instanceof String && (type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement)) != null && (ownerClass = JavaReflectionReferenceUtil.getReflectiveClass(this.myContext)) != null) {
            switch (type2) {
                case "findGetter": 
                case "findSetter": {
                    return this.lookupFields(ownerClass, JavaLangInvokeHandleReference::isNonStaticField);
                }
                case "findStaticGetter": 
                case "findStaticSetter": {
                    return this.lookupFields(ownerClass, JavaLangInvokeHandleReference::isStaticField);
                }
                case "findVirtual": {
                    return this.lookupMethods(ownerClass, JavaLangInvokeHandleReference::isNonStaticMethod);
                }
                case "findStatic": {
                    return this.lookupMethods(ownerClass, JavaLangInvokeHandleReference::isStaticMethod);
                }
                case "findVarHandle": {
                    return this.lookupFields(ownerClass, JavaLangInvokeHandleReference::isNonStaticField);
                }
                case "findStaticVarHandle": {
                    return this.lookupFields(ownerClass, JavaLangInvokeHandleReference::isStaticField);
                }
            }
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    private Object[] lookupMethods(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Predicate<? super PsiMethod> filter) {
        return ownerClass.getPsiClass().getVisibleSignatures().stream().map(MethodSignatureBackedByPsiMethod::getMethod).filter(filter).sorted(Comparator.comparingInt(method -> JavaReflectionReferenceUtil.getMethodSortOrder(method)).thenComparing(PsiMethod::getName)).map(method -> JavaReflectionReferenceUtil.withPriority(JavaReflectionReferenceUtil.lookupMethod(method, this), -JavaReflectionReferenceUtil.getMethodSortOrder(method))).filter(Objects::nonNull).toArray();
    }

    private Object[] lookupFields(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Predicate<? super PsiField> filter) {
        THashSet uniqueNames = new THashSet();
        return Arrays.stream(ownerClass.getPsiClass().getAllFields()).filter(arg_0 -> JavaLangInvokeHandleReference.lambda$lookupFields$3(ownerClass, (Set)uniqueNames, arg_0)).filter(filter).sorted(Comparator.comparing(field -> JavaReflectionReferenceUtil.isPublic((PsiMember)field) ? 0 : 1).thenComparing(PsiField::getName)).map(field -> JavaReflectionReferenceUtil.withPriority((LookupElement)JavaLookupElementBuilder.forField(field).withInsertHandler((InsertHandler)this), JavaReflectionReferenceUtil.isPublic((PsiMember)field))).toArray();
    }

    private static boolean isNonStaticField(PsiField field) {
        return field != null && !field.hasModifierProperty("static");
    }

    private static boolean isStaticField(PsiField field) {
        return field != null && field.hasModifierProperty("static");
    }

    private static boolean isNonStaticMethod(@Nullable PsiMethod method) {
        return JavaReflectionReferenceUtil.isRegularMethod(method) && !method.hasModifierProperty("static");
    }

    private static boolean isStaticMethod(@Nullable PsiMethod method) {
        return JavaReflectionReferenceUtil.isRegularMethod(method) && method.hasModifierProperty("static");
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Object object = item.getObject();
        if (object instanceof JavaReflectionReferenceUtil.ReflectiveSignature) {
            String text2 = ", " + JavaReflectionReferenceUtil.getMethodTypeExpressionText((JavaReflectionReferenceUtil.ReflectiveSignature)object);
            JavaReflectionReferenceUtil.replaceText(context, text2);
        } else if (object instanceof PsiField) {
            PsiField field = (PsiField)object;
            String typeText = JavaReflectionReferenceUtil.getTypeText(field.getType());
            String text3 = ", " + typeText + ".class";
            JavaReflectionReferenceUtil.replaceText(context, text3);
        }
    }

    private static /* synthetic */ boolean lambda$lookupFields$3(JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Set uniqueNames, PsiField field) {
        return field != null && (field.getContainingClass() == ownerClass.getPsiClass() || !field.hasModifierProperty("private")) && uniqueNames.add(field.getName());
    }

    static class JavaLangInvokeHandleReferenceProvider
    extends PsiReferenceProvider {
        JavaLangInvokeHandleReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            PsiElement parent;
            PsiLiteralExpression literal;
            if (element instanceof PsiLiteralExpression && (literal = (PsiLiteralExpression)element).getValue() instanceof String && (parent = element.getParent()) instanceof PsiExpressionList) {
                PsiExpression qualifier;
                PsiExpression[] expressions2 = ((PsiExpressionList)parent).getExpressions();
                PsiExpression psiExpression = qualifier = expressions2.length != 0 ? expressions2[0] : null;
                if (qualifier != null) {
                    return new PsiReference[]{new JavaLangInvokeHandleReference(literal, qualifier)};
                }
            }
            return PsiReference.EMPTY_ARRAY;
        }
    }
}

