/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ConstraintType;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ThreadLocalTypes;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.util.Function;
import com.intellij.util.MathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance(InferenceSession.class);
    private static final Function<Pair<PsiType, PsiType>, PsiType> UPPER_BOUND_FUNCTION = pair2 -> GenericsUtil.getGreatestLowerBound((PsiType)((PsiType)pair2.first), (PsiType)((PsiType)pair2.second));
    private static final String EQUALITY_CONSTRAINTS_PRESENTATION = "equality constraints";
    private static final String UPPER_BOUNDS_PRESENTATION = "upper bounds";
    private static final String LOWER_BOUNDS_PRESENTATION = "lower bounds";
    static final Key<PsiCapturedWildcardType> ORIGINAL_CAPTURE = Key.create((String)"ORIGINAL_CAPTURE");
    protected final Set<InferenceVariable> myInferenceVariables = new LinkedHashSet<InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private final Set<ConstraintFormula> myConstraintsCopy = new HashSet<ConstraintFormula>();
    private final InferenceSessionContainer myInferenceSessionContainer;
    private PsiSubstitutor mySiteSubstitutor;
    private final PsiManager myManager;
    private int myConstraintIdx;
    private List<String> myErrorMessages;
    private boolean myErased;
    public final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;
    private final ParameterTypeInferencePolicy myPolicy;
    private PsiSubstitutor myInferenceSubstitution = PsiSubstitutor.EMPTY;
    private PsiSubstitutor myRestoreNameSubstitution = PsiSubstitutor.EMPTY;
    private MethodCandidateInfo myCurrentMethod;
    private ThreadLocalTypes myTempTypes;

    public InferenceSession(InitialInferenceState initialState, ParameterTypeInferencePolicy policy) {
        this.myContext = initialState.getContext();
        this.myManager = this.myContext.getManager();
        this.myInferenceSubstitution = initialState.getInferenceSubstitutor();
        this.myInferenceVariables.addAll(initialState.getInferenceVariables());
        this.mySiteSubstitutor = initialState.getSiteSubstitutor();
        for (Pair<InferenceVariable[], PsiClassType> capture : initialState.getCaptures()) {
            this.myIncorporationPhase.addCapture((InferenceVariable[])capture.first, (PsiClassType)capture.second);
        }
        this.myInferenceSessionContainer = initialState.getInferenceSessionContainer();
        this.myErased = initialState.isErased();
        this.myPolicy = policy;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i = 0; i < leftTypes.length; ++i) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i]);
            PsiType t = this.substituteWithInferenceVariables(leftTypes[i]);
            PsiType s = this.substituteWithInferenceVariables(rightType);
            if (t == null || s == null) continue;
            this.addConstraint(new TypeCompatibilityConstraint(t, s));
        }
        this.myPolicy = DefaultParameterTypeInferencePolicy.INSTANCE;
        this.myInferenceSessionContainer = new InferenceSessionContainer();
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this(typeParams, siteSubstitutor, manager, context, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context, ParameterTypeInferencePolicy policy) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.myPolicy = policy;
        this.initBounds(typeParams);
        this.myInferenceSessionContainer = new InferenceSessionContainer();
    }

    public MethodCandidateInfo getCurrentMethod(PsiExpressionList argumentList) {
        return this.myCurrentMethod != null && this.myCurrentMethod.isOnArgumentList(argumentList) ? this.myCurrentMethod : null;
    }

    public void setCurrentMethod(MethodCandidateInfo currentMethod) {
        this.myCurrentMethod = currentMethod;
    }

    @NotNull
    public ParameterTypeInferencePolicy getInferencePolicy() {
        return this.myPolicy;
    }

    public static PsiType createTypeParameterTypeWithUpperBound(@NotNull PsiType upperBound, @NotNull PsiElement place) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        PsiTypeParameter parameter2 = elementFactory.createTypeParameterFromText("T", place);
        TypeConversionUtil.setInferredBoundsForSynthetic((PsiTypeParameter)parameter2, null, (PsiType)upperBound);
        return elementFactory.createType((PsiClass)parameter2);
    }

    public void initExpressionConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiMethod method, boolean varargs) {
        if (method != null) {
            this.initThrowsConstraints(method);
        }
        if (parameters2.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (!varargs && i >= parameters2.length || args[i] == null || !InferenceSession.isPertinentToApplicability(args[i], method)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters2, i, this.mySiteSubstitutor, varargs);
                LOG.assertTrue(parameterType != null);
                if (InferenceSession.ignoreLambdaConstraintTree(args[i])) continue;
                this.addConstraint(new ExpressionCompatibilityConstraint(args[i], this.substituteWithInferenceVariables(parameterType)));
            }
        }
    }

    public void initThrowsConstraints(PsiMethod method) {
        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable = this.getInferenceVariable(this.substituteWithInferenceVariables((PsiType)thrownType));
            if (variable == null) continue;
            variable.setThrownBound();
        }
    }

    static PsiExpressionList getArgumentList(PsiElement parent) {
        if (parent instanceof PsiCall) {
            return ((PsiCall)parent).getArgumentList();
        }
        if (parent instanceof PsiAnonymousClass) {
            return InferenceSession.getArgumentList(parent.getParent());
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr2, PsiMethod method) {
        return InferenceSession.isPertinentToApplicability(expr2, method, null);
    }

    private static boolean isPertinentToApplicability(PsiExpression expr2, PsiMethod method, PsiType expectedReturnType) {
        if ((expr2 instanceof PsiLambdaExpression && ((PsiLambdaExpression)expr2).hasFormalParameterTypes() || expr2 instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expr2).isExact()) && method != null) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expr2.getParent());
            PsiType paramType = null;
            if (parent instanceof PsiExpressionList) {
                PsiElement gParent = parent.getParent();
                PsiTypeParameterListOwner owner2 = InferenceSession.getTypeParameterOwner(method, gParent);
                if (owner2 != null) {
                    PsiParameter[] parameters2;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)parent), (PsiElement)expr2);
                    if (idx > (parameters2 = method.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters2[parameters2.length - 1].getType();
                        paramType = parameters2[parameters2.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters2[idx].getType();
                    }
                    if (InferenceSession.isTypeParameterType(owner2, paramType)) {
                        return false;
                    }
                }
            } else if (expectedReturnType != null && (parent instanceof PsiLambdaExpression || parent instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMethod.class}) != null)) {
                if (InferenceSession.isTypeParameterType((PsiTypeParameterListOwner)method, expectedReturnType)) {
                    return false;
                }
                paramType = expectedReturnType;
            }
            if (expr2 instanceof PsiLambdaExpression) {
                for (PsiExpression expression2 : LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)expr2))) {
                    if (InferenceSession.isPertinentToApplicability(expression2, method, LambdaUtil.getFunctionalInterfaceReturnType((PsiType)paramType))) continue;
                    return false;
                }
                return true;
            }
        }
        if (expr2 instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)expr2).hasFormalParameterTypes();
        }
        if (expr2 instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr2).isExact();
        }
        if (expr2 instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr2).getExpression(), method);
        }
        if (expr2 instanceof PsiConditionalExpression) {
            PsiExpression thenExpression2 = ((PsiConditionalExpression)expr2).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression2, method)) {
                return false;
            }
            PsiExpression elseExpression2 = ((PsiConditionalExpression)expr2).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression2, method)) {
                return false;
            }
        }
        return true;
    }

    private static PsiTypeParameterListOwner getTypeParameterOwner(@NotNull PsiMethod method, PsiElement gParent) {
        PsiClass containingClass;
        PsiMethod owner2 = null;
        if (method.getTypeParameters().length > 0 && gParent instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
            owner2 = method;
        } else if (method.isConstructor() && gParent instanceof PsiNewExpression && (containingClass = method.getContainingClass()) != null && containingClass.hasTypeParameters() && PsiDiamondType.hasDiamond((PsiNewExpression)((PsiNewExpression)gParent))) {
            owner2 = containingClass;
        }
        return owner2;
    }

    private static boolean isTypeParameterType(PsiTypeParameterListOwner method, PsiType paramType) {
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)paramType);
        return psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method;
    }

    private static PsiType getParameterType(PsiParameter[] parameters2, int i, @Nullable PsiSubstitutor substitutor, boolean varargs) {
        if (substitutor == null || !varargs && i >= parameters2.length) {
            return null;
        }
        return substitutor.substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)i, (boolean)varargs));
    }

    @NotNull
    public PsiSubstitutor infer() {
        return this.infer(null, null, null, null);
    }

    PsiSubstitutor collectAdditionalAndInfer(PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] args, @NotNull MethodCandidateInfo properties, @NotNull PsiSubstitutor psiSubstitutor) {
        return this.performGuardedInference(parameters2, args, this.myContext, properties, psiSubstitutor, false);
    }

    @NotNull
    public PsiSubstitutor infer(PsiParameter @Nullable [] parameters2, PsiExpression @Nullable [] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo currentMethod) {
        return this.performGuardedInference(parameters2, args, parent, currentMethod, PsiSubstitutor.EMPTY, false);
    }

    @NotNull
    PsiSubstitutor performGuardedInference(PsiParameter @Nullable [] parameters2, PsiExpression @Nullable [] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo currentMethod, @NotNull PsiSubstitutor initialSubstitutor, boolean prohibitCaching) {
        if (!prohibitCaching) {
            prohibitCaching = MethodCandidateInfo.isOverloadCheck() || !(parent instanceof PsiMethodCallExpression) || ((PsiMethodCallExpression)parent).getMethodExpression().multiResolve(false).length != 1;
        }
        return (PsiSubstitutor)ThreadLocalTypes.performWithTypes(types -> {
            this.myTempTypes = types;
            try {
                this.doInfer(parameters2, args, parent, currentMethod, initialSubstitutor);
                PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
                return psiSubstitutor;
            }
            finally {
                if (currentMethod != null) {
                    if (this.myErrorMessages != null) {
                        currentMethod.setApplicabilityError(StringUtil.join(this.myErrorMessages, (String)"\n"));
                    }
                    if (this.myErased) {
                        currentMethod.setErased();
                    }
                }
                this.myTempTypes = null;
            }
        }, (boolean)prohibitCaching);
    }

    private void doInfer(PsiParameter @Nullable [] parameters2, PsiExpression @Nullable [] args, @Nullable PsiElement parent, @Nullable MethodCandidateInfo properties, @NotNull PsiSubstitutor initialSubstitutor) {
        if (!this.repeatInferencePhases()) {
            return;
        }
        PsiExpressionList argumentList = InferenceSession.getArgumentList(parent);
        if (properties != null && argumentList != null && !MethodCandidateInfo.isOverloadCheck((PsiElement)argumentList)) {
            PsiType returnType;
            PsiMethod method = properties.getElement();
            if (parent instanceof PsiCallExpression && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)((PsiExpression)parent), (PsiMethod)method) && !PsiType.VOID.equals((Object)(returnType = method.getReturnType())) && returnType != null) {
                Ref errorMessage = new Ref();
                PsiType targetType = InferenceSession.getTargetTypeFromParent(parent, (Ref<String>)errorMessage, false);
                if (targetType == null && errorMessage.get() != null) {
                    return;
                }
                if (targetType != null && !PsiType.VOID.equals((Object)targetType)) {
                    PsiType actualType = PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method, (PsiSubstitutor)this.mySiteSubstitutor) ? returnType : this.mySiteSubstitutor.substitute(returnType);
                    this.registerReturnTypeConstraints(actualType, targetType, this.myContext);
                }
            }
            if (!this.repeatInferencePhases()) {
                if (InferenceSession.isPertinentToApplicabilityCheckOnContainingCall(parent)) {
                    return;
                }
            } else if (parameters2 != null && parameters2.length > 0 && args != null && !InferenceSession.isPertinentToApplicabilityCheckOnContainingCall(parent)) {
                LinkedHashSet<ConstraintFormula> additionalConstraints = new LinkedHashSet<ConstraintFormula>();
                HashSet<ConstraintFormula> ignoredConstraints = new HashSet<ConstraintFormula>();
                this.collectAdditionalConstraints(parameters2, args, method, this.mySiteSubstitutor, additionalConstraints, ignoredConstraints, properties.isVarargs(), initialSubstitutor);
                this.proceedWithAdditionalConstraints(additionalConstraints, ignoredConstraints);
            }
        }
        this.resolveBounds(this.myInferenceVariables, initialSubstitutor);
    }

    private static boolean isPertinentToApplicabilityCheckOnContainingCall(@NotNull PsiElement parent) {
        return ThreadLocalTypes.hasBindingFor((PsiElement)parent);
    }

    private void collectAdditionalConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiMethod parentMethod, PsiSubstitutor siteSubstitutor, Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, boolean varargs, PsiSubstitutor initialSubstitutor) {
        for (int i = 0; i < args.length; ++i) {
            PsiSubstitutor nestedSubstitutor;
            PsiType parameterType;
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[i]);
            if (arg == null || (parameterType = (nestedSubstitutor = this.myInferenceSessionContainer.findNestedSubstitutor((PsiElement)arg, this.myInferenceSubstitution)).substitute(InferenceSession.getParameterType(parameters2, i, siteSubstitutor, varargs))) == null) continue;
            if (!InferenceSession.isPertinentToApplicability(arg, parentMethod)) {
                ExpressionCompatibilityConstraint compatibilityConstraint = new ExpressionCompatibilityConstraint(arg, parameterType);
                if (arg instanceof PsiFunctionalExpression && InferenceSession.ignoreLambdaConstraintTree(arg) || this.dependsOnIgnoredConstraint(ignoredConstraints, compatibilityConstraint)) {
                    ignoredConstraints.add(compatibilityConstraint);
                    continue;
                }
                additionalConstraints.add(compatibilityConstraint);
            }
            additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(arg, parameterType));
            if (arg instanceof PsiCall) {
                PsiMethod calledMethod;
                JavaResolveResult resolveResult = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((PsiCall)arg));
                PsiMethod psiMethod = calledMethod = resolveResult instanceof MethodCandidateInfo ? (PsiMethod)resolveResult.getElement() : null;
                if (calledMethod == null || !PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)arg, (PsiMethod)calledMethod)) continue;
                this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCall)arg, initialSubstitutor);
                continue;
            }
            if (!(arg instanceof PsiLambdaExpression) || !InferenceSession.isPertinentToApplicability(arg, parentMethod)) continue;
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)arg, ((PsiLambdaExpression)arg).getGroundTargetType(parameterType), !this.isProperType(initialSubstitutor.substitute(parameterType)), initialSubstitutor);
        }
    }

    private boolean dependsOnIgnoredConstraint(Set<ConstraintFormula> ignoredConstraints, ExpressionCompatibilityConstraint compatibilityConstraint) {
        Set<InferenceVariable> inputVariables;
        if (!ignoredConstraints.isEmpty() && (inputVariables = compatibilityConstraint.getInputVariables(this)) != null) {
            for (ConstraintFormula ignoredConstraint : ignoredConstraints) {
                Set<InferenceVariable> inputsOfIgnored;
                Set<InferenceVariable> outputVariables;
                if (!(ignoredConstraint instanceof InputOutputConstraintFormula) || (outputVariables = ((InputOutputConstraintFormula)ignoredConstraint).getOutputVariables(inputsOfIgnored = ((InputOutputConstraintFormula)ignoredConstraint).getInputVariables(this), this)) == null || !ContainerUtil.intersects(outputVariables, inputVariables)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean ignoreLambdaConstraintTree(PsiExpression arg) {
        for (PsiElement expr2 : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
            if (PsiTreeUtil.getParentOfType((PsiElement)expr2, PsiFunctionalExpression.class, (boolean)false) != arg) continue;
            return true;
        }
        return false;
    }

    private void collectLambdaReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiLambdaExpression lambdaExpression, PsiType parameterType, boolean addConstraint, PsiSubstitutor initialSubstitutor) {
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)parameterType);
        if (!(interfaceReturnType == null || PsiType.VOID.equals((Object)interfaceReturnType) && addConstraint)) {
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression);
            for (PsiExpression returnExpression2 : returnExpressions) {
                this.processReturnExpression(additionalConstraints, ignoredConstraints, returnExpression2, interfaceReturnType, addConstraint, initialSubstitutor);
            }
        }
    }

    private void processReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiExpression returnExpression2, @NotNull PsiType functionalType, boolean addConstraint, PsiSubstitutor initialSubstitutor) {
        if (returnExpression2 instanceof PsiCallExpression) {
            if (addConstraint) {
                JavaResolveResult resolveResult = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((PsiCallExpression)returnExpression2));
                if (resolveResult instanceof MethodCandidateInfo && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)returnExpression2, (PsiMethod)((MethodCandidateInfo)resolveResult).getElement())) {
                    this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCall)((PsiCallExpression)returnExpression2), initialSubstitutor);
                }
            } else {
                this.getInferenceSessionContainer().registerNestedSession(this, functionalType, returnExpression2);
            }
        } else if (returnExpression2 instanceof PsiParenthesizedExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiParenthesizedExpression)returnExpression2).getExpression(), functionalType, addConstraint, initialSubstitutor);
        } else if (returnExpression2 instanceof PsiConditionalExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression2).getThenExpression(), functionalType, addConstraint, initialSubstitutor);
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression2).getElseExpression(), functionalType, addConstraint, initialSubstitutor);
        } else if (returnExpression2 instanceof PsiSwitchExpression) {
            for (PsiExpression resultExpression : PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)((PsiSwitchExpression)returnExpression2))) {
                this.processReturnExpression(additionalConstraints, ignoredConstraints, resultExpression, functionalType, addConstraint, initialSubstitutor);
            }
        } else if (returnExpression2 instanceof PsiLambdaExpression && !InferenceSession.ignoreLambdaConstraintTree(returnExpression2)) {
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)returnExpression2, functionalType, this.myErased, initialSubstitutor);
        }
    }

    private void collectAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiCall callExpression, PsiSubstitutor initialSubstitutor) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList != null) {
            PsiMethod method;
            JavaResolveResult result = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)callExpression);
            PsiMethod psiMethod = method = result instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result).getElement() : null;
            if (method != null) {
                PsiExpression[] newArgs = argumentList.getExpressions();
                PsiParameter[] newParams = method.getParameterList().getParameters();
                if (newParams.length > 0) {
                    this.collectAdditionalConstraints(newParams, newArgs, method, InferenceSession.chooseSiteSubstitutor(null, result, method), additionalConstraints, ignoredConstraints, InferenceSession.chooseVarargsMode(null, result), initialSubstitutor);
                }
            }
        }
    }

    public static PsiSubstitutor chooseSiteSubstitutor(MethodCandidateInfo currentMethod, JavaResolveResult resolveResult, PsiMethod method) {
        return resolveResult instanceof MethodCandidateInfo && method != null && !method.isConstructor() ? ((MethodCandidateInfo)resolveResult).getSiteSubstitutor() : (currentMethod != null ? currentMethod.getSiteSubstitutor() : PsiSubstitutor.EMPTY);
    }

    public static boolean chooseVarargsMode(MethodCandidateInfo currentMethod, JavaResolveResult resolveResult) {
        return resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isVarargs() || currentMethod != null && currentMethod.isVarargs();
    }

    PsiSubstitutor getInstantiations(Collection<InferenceVariable> variables) {
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : variables) {
            PsiType equalsBound = this.getEqualsBound(variable, substitutor);
            if (equalsBound == null || PsiType.NULL.equals((Object)equalsBound)) continue;
            substitutor = substitutor.put(variable.getParameter(), equalsBound);
        }
        return substitutor;
    }

    protected PsiSubstitutor prepareSubstitution() {
        boolean foundErrorMessage = false;
        Iterator<List<InferenceVariable>> iterator = InferenceVariablesOrder.resolveOrderIterator(this.myInferenceVariables, this);
        while (iterator.hasNext()) {
            List<InferenceVariable> variables = iterator.next();
            for (InferenceVariable inferenceVariable : variables) {
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                PsiType instantiation = inferenceVariable.getInstantiation();
                if (instantiation != PsiType.NULL) continue;
                if (!foundErrorMessage) {
                    foundErrorMessage = this.checkBoundsConsistency(this.mySiteSubstitutor, inferenceVariable) == PsiType.NULL;
                }
                this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, (PsiType)JavaPsiFacade.getElementFactory((Project)this.myManager.getProject()).createType((PsiClass)typeParameter));
            }
        }
        return this.mySiteSubstitutor;
    }

    InitialInferenceState createInitialState(InferenceSessionContainer container, Collection<InitialInferenceState.VariableInfo> variables, PsiSubstitutor topInferenceSubstitutor) {
        return new InitialInferenceState(variables, topInferenceSubstitutor, this.myContext, this.myInferenceSubstitution, this.mySiteSubstitutor, this.myIncorporationPhase.getCaptures(), this.myErased, container);
    }

    private void initBounds(PsiTypeParameter ... typeParameters) {
        this.initBounds(this.myContext, typeParameters);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiTypeParameter ... typeParameters) {
        return this.initBounds(context, this.mySiteSubstitutor, typeParameters);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiSubstitutor siteSubstitutor, PsiTypeParameter ... typeParameters) {
        ArrayList<InferenceVariable> result = new ArrayList<InferenceVariable>(typeParameters.length);
        for (PsiTypeParameter parameter2 : typeParameters) {
            String name2 = parameter2.getName();
            if (this.myContext != null) {
                name2 = name2 + MathUtil.nonNegativeAbs((int)this.myContext.hashCode());
            }
            InferenceVariable variable = new InferenceVariable(context, parameter2, name2);
            result.add(variable);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
            this.myInferenceSubstitution = this.myInferenceSubstitution.put(parameter2, (PsiType)elementFactory.createType((PsiClass)variable));
            this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.put((PsiTypeParameter)variable, (PsiType)elementFactory.createType((PsiClass)parameter2));
            this.myInferenceVariables.add(variable);
        }
        for (InferenceVariable variable : result) {
            PsiClassType[] extendsListTypes;
            PsiTypeParameter parameter3 = variable.getParameter();
            boolean added = false;
            for (PsiClassType classType : extendsListTypes = parameter3.getExtendsListTypes()) {
                if (this.isProperType((PsiType)(classType = this.substituteWithInferenceVariables(siteSubstitutor.substitute((PsiType)classType))))) {
                    added = true;
                }
                variable.addBound((PsiType)classType, InferenceBound.UPPER, null);
            }
            if (added) continue;
            variable.addBound((PsiType)PsiType.getJavaLangObject((PsiManager)parameter3.getManager(), (GlobalSearchScope)parameter3.getResolveScope()), InferenceBound.UPPER, null);
        }
        return result.toArray(new InferenceVariable[0]);
    }

    public void registerReturnTypeConstraints(PsiType returnType, @NotNull PsiType targetType, PsiElement context) {
        returnType = this.substituteWithInferenceVariables(returnType);
        if (this.myErased) {
            PsiSubstitutor currentSubstitutor = this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(targetType, TypeConversionUtil.erasure((PsiType)currentSubstitutor.substitute(returnType))));
        } else if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(returnType)) {
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)returnType);
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                LOG.assertTrue(returnType instanceof PsiClassType);
                PsiClassType substitutedCapture = (PsiClassType)PsiUtil.captureToplevelWildcards((PsiType)returnType, (PsiElement)context);
                PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
                PsiType[] parameters2 = substitutedCapture.getParameters();
                InferenceVariable[] copy = this.initFreshVariablesForCapturedBounds(typeParameters, parameters2);
                PsiType[] newParameters = new PsiType[parameters2.length];
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
                int idx = 0;
                for (int i = 0; i < parameters2.length; ++i) {
                    newParameters[i] = parameters2[i];
                    if (!(parameters2[i] instanceof PsiCapturedWildcardType)) continue;
                    newParameters[i] = elementFactory.createType((PsiClass)copy[idx++]);
                }
                substitutedCapture = elementFactory.createType(psiClass, newParameters);
                this.myIncorporationPhase.addCapture(copy, (PsiClassType)returnType);
                this.addConstraint(new TypeCompatibilityConstraint(targetType, (PsiType)substitutedCapture));
            }
        } else {
            InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType, targetType);
            if (inferenceVariable != null) {
                PsiSubstitutor substitutor = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor);
                PsiType substitutedReturnType = substitutor.substitute((PsiTypeParameter)inferenceVariable);
                if (substitutedReturnType != null) {
                    this.addConstraint(new TypeCompatibilityConstraint(targetType, PsiUtil.captureToplevelWildcards((PsiType)substitutedReturnType, (PsiElement)context)));
                }
            } else {
                this.addConstraint(new TypeCompatibilityConstraint(targetType, returnType));
            }
        }
    }

    private InferenceVariable[] initFreshVariablesForCapturedBounds(PsiTypeParameter[] typeParameters, PsiType[] parameters2) {
        if (Registry.is((String)"javac.fresh.variables.for.captured.wildcards.only")) {
            ArrayList<PsiTypeParameter> capturedParams = new ArrayList<PsiTypeParameter>();
            PsiSubstitutor restParamSubstitution = PsiSubstitutor.EMPTY;
            for (int i = 0; i < parameters2.length; ++i) {
                PsiType parameter2 = parameters2[i];
                if (parameter2 instanceof PsiCapturedWildcardType) {
                    capturedParams.add(typeParameters[i]);
                    continue;
                }
                restParamSubstitution = restParamSubstitution.put(typeParameters[i], parameter2);
            }
            InferenceVariable[] variables = this.initBounds(null, restParamSubstitution, capturedParams.toArray(PsiTypeParameter.EMPTY_ARRAY));
            int idx = 0;
            for (PsiType parameter3 : parameters2) {
                if (!(parameter3 instanceof PsiCapturedWildcardType)) continue;
                InferenceVariable variable = variables[idx++];
                if (!this.isProperType((PsiType)((PsiCapturedWildcardType)parameter3).getWildcard())) continue;
                variable.putUserData(ORIGINAL_CAPTURE, (PsiCapturedWildcardType)parameter3);
            }
            return variables;
        }
        return this.initBounds((PsiElement)null, typeParameters);
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType, this) || InferenceSession.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER, InferenceBound.EQ}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType((PsiType)bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType, InferenceSession session) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion((PsiType)targetType, bound, session)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized((PsiType)targetType)) {
            Processor differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (InferenceSession.findParameterizationOfTheSameGenericClass(bounds, (Processor<? super Pair<PsiType, PsiType>>)(differentParameterizationProcessor = pair2 -> pair2.first == null || pair2.second == null || !TypesDistinctProver.provablyDistinct((PsiType)((PsiType)pair2.first), (PsiType)((PsiType)pair2.second)))) != null) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            ArrayList<PsiType> boundsToCheck = new ArrayList<PsiType>(bounds);
            boundsToCheck.addAll(eqBounds);
            for (PsiType lowBound : boundsToCheck) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiType getTargetType(PsiElement context) {
        PsiType targetType = InferenceSession.getTargetTypeFromParent(context, (Ref<String>)new Ref(), true);
        if (targetType instanceof PsiClassType) {
            return ((PsiClassType)targetType).setLanguageLevel(PsiUtil.getLanguageLevel((PsiElement)context));
        }
        return targetType;
    }

    public static PsiType getTargetTypeByParent(PsiElement context) {
        PsiType targetType = InferenceSession.getTargetTypeFromParent(context, (Ref<String>)new Ref(), false);
        if (targetType instanceof PsiClassType) {
            return ((PsiClassType)targetType).setLanguageLevel(PsiUtil.getLanguageLevel((PsiElement)context));
        }
        return targetType;
    }

    private static PsiType getTargetTypeFromParent(PsiElement context, Ref<String> errorMessage, boolean inferParent) {
        PsiSwitchExpression switchExpression;
        PsiType targetType = PsiTypesUtil.getExpectedTypeByParent((PsiElement)context);
        if (targetType != null) {
            return targetType;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)context.getParent());
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList argumentList;
            PsiElement gParent = parent.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiCall && (argumentList = ((PsiCall)gParent).getArgumentList()) != null) {
                if (MethodCandidateInfo.isOverloadCheck((PsiElement)argumentList)) {
                    return ThreadLocalTypes.getElementType((PsiElement)context);
                }
                JavaResolveResult result = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((PsiCall)gParent));
                PsiElement element = result.getElement();
                if (element == null) {
                    errorMessage.set((Object)"Overload resolution failed");
                    return null;
                }
                if (element instanceof PsiMethod && (inferParent || !((PsiMethod)element).hasTypeParameters())) {
                    boolean varargs = result instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).isVarargs();
                    return PsiTypesUtil.getTypeByMethod((PsiElement)context, (PsiExpressionList)argumentList, (PsiElement)result.getElement(), (boolean)varargs, (PsiSubstitutor)result.getSubstitutor(), (boolean)inferParent);
                }
            }
        } else {
            if (parent instanceof PsiConditionalExpression) {
                return InferenceSession.getTargetTypeFromParent(parent, errorMessage, inferParent);
            }
            if (parent instanceof PsiLambdaExpression) {
                return InferenceSession.getTargetTypeFromParentLambda((PsiLambdaExpression)parent, errorMessage, inferParent);
            }
            if (parent instanceof PsiReturnStatement) {
                return InferenceSession.getTargetTypeFromParentLambda((PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMethod.class}), errorMessage, inferParent);
            }
        }
        if ((switchExpression = (PsiSwitchExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiSwitchExpression.class)) != null && PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)switchExpression).contains(context)) {
            return InferenceSession.getTargetTypeFromParent((PsiElement)switchExpression, errorMessage, inferParent);
        }
        return null;
    }

    private static PsiType getTargetTypeFromParentLambda(PsiLambdaExpression lambdaExpression, Ref<String> errorMessage, boolean inferParent) {
        if (lambdaExpression != null) {
            PsiType typeTypeByParentCall = InferenceSession.getTargetTypeFromParent((PsiElement)lambdaExpression, errorMessage, inferParent);
            if (typeTypeByParentCall != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)lambdaExpression.getGroundTargetType(typeTypeByParentCall));
            }
            PsiType cachedLambdaType = ThreadLocalTypes.getElementType((PsiElement)lambdaExpression);
            if (cachedLambdaType != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)lambdaExpression.getGroundTargetType(cachedLambdaType));
            }
            return inferParent || !(PsiUtil.skipParenthesizedExprUp((PsiElement)lambdaExpression.getParent()) instanceof PsiExpressionList) ? LambdaUtil.getFunctionalInterfaceReturnType((PsiType)lambdaExpression.getFunctionalInterfaceType()) : null;
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType);
        return psiClass instanceof InferenceVariable ? this.getInferenceVariable((PsiTypeParameter)psiClass) : null;
    }

    public boolean isProperType(@Nullable PsiType type2) {
        return this.collectDependencies(type2, null);
    }

    public boolean collectDependencies(@Nullable PsiType type2, @Nullable Set<? super InferenceVariable> dependencies) {
        return InferenceSession.collectDependencies(type2, dependencies, (Function<? super PsiClassType, ? extends InferenceVariable>)((Function)classType -> this.getInferenceVariable((PsiType)classType)));
    }

    public static boolean collectDependencies(@Nullable PsiType type2, final @Nullable Set<? super InferenceVariable> dependencies, final Function<? super PsiClassType, ? extends InferenceVariable> fun) {
        if (type2 == null) {
            return true;
        }
        Boolean isProper = (Boolean)type2.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

            public Boolean visitType(@NotNull PsiType type2) {
                return true;
            }

            public Boolean visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
                return true;
            }

            public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            public Boolean visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return (Boolean)bound.accept((PsiTypeVisitor)this);
            }

            public Boolean visitClassType(@NotNull PsiClassType classType) {
                InferenceVariable inferenceVariable = (InferenceVariable)((Object)fun.fun((Object)classType));
                if (inferenceVariable != null) {
                    if (dependencies != null) {
                        dependencies.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                PsiClassType.ClassResolveResult result = classType.resolveGenerics();
                PsiClass aClass = result.getElement();
                if (aClass != null) {
                    PsiSubstitutor substitutor = result.getSubstitutor();
                    for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                        PsiType psiType = substitutor.substitute(typeParameter);
                        if (psiType == null || ((Boolean)psiType.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        });
        return dependencies != null ? !dependencies.isEmpty() : isProper;
    }

    public boolean repeatInferencePhases() {
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (!this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList newConstraints = new ArrayList();
        for (int i = this.myConstraintIdx; i < this.myConstraints.size(); ++i) {
            ConstraintFormula constraint = this.myConstraints.get(i);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    private boolean isThrowable(List<PsiType> upperBounds) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds) {
            if (upperBound.equalsToText("java.lang.Object") || !this.isProperType(upperBound)) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor) {
        LinkedHashSet dependencies = new LinkedHashSet();
        if (!this.collectDependencies(bound, dependencies)) {
            return bound;
        }
        for (InferenceVariable dependency : dependencies) {
            PsiType instantiation = dependency.getInstantiation();
            if (instantiation == PsiType.NULL) continue;
            substitutor = substitutor.put((PsiTypeParameter)dependency, instantiation);
        }
        return substitutor.substitute(bound);
    }

    private boolean hasBoundProblems(List<InferenceVariable> typeParams, PsiSubstitutor substitutor) {
        for (InferenceVariable typeParameter : typeParams) {
            List<PsiType> extendsTypes;
            PsiType[] bounds;
            PsiClass aClass;
            PsiType type2;
            if (typeParameter.getInstantiation() != PsiType.NULL || typeParameter.getUserData(ORIGINAL_CAPTURE) != null || (type2 = substitutor.substitute((PsiTypeParameter)typeParameter)) instanceof PsiClassType && (aClass = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)((PsiTypeParameter)aClass)) || GenericsUtil.findTypeParameterBoundError((PsiTypeParameter)typeParameter, (PsiType[])(bounds = (extendsTypes = typeParameter.getBounds(InferenceBound.UPPER)).toArray(PsiType.EMPTY_ARRAY)), (PsiSubstitutor)substitutor, (PsiElement)this.myContext, (boolean)true) == null) continue;
            return true;
        }
        return false;
    }

    protected void resolveBounds(Collection<InferenceVariable> inferenceVariables, @NotNull PsiSubstitutor substitutor) {
        UniqueNameGenerator uniqueNameGenerator = new UniqueNameGenerator();
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(inferenceVariables);
        Map<InferenceVariable, Set<InferenceVariable>> dependencies = InferenceVariablesOrder.getDependencies(allVars, this);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(allVars, dependencies);
            List<InferenceVariable> unresolved = new ArrayList<InferenceVariable>();
            for (InferenceVariable var : vars) {
                PsiType eqBound = this.getEqualsBound(var, substitutor);
                if (eqBound != PsiType.NULL) continue;
                unresolved.add(var);
            }
            if (!unresolved.isEmpty() && vars.size() > unresolved.size()) {
                vars.removeAll(unresolved);
                vars.addAll(unresolved);
            }
            if (!this.myIncorporationPhase.hasCaptureConstraints(unresolved)) {
                PsiSubstitutor firstSubstitutor = this.resolveSubset(vars, substitutor);
                if (this.myErrorMessages == null && this.hasBoundProblems(vars, firstSubstitutor)) {
                    firstSubstitutor = null;
                    unresolved = vars;
                }
                if (firstSubstitutor != null) {
                    substitutor = firstSubstitutor;
                    allVars.removeAll(vars);
                    continue;
                }
            }
            if (!this.initFreshVariables(substitutor, unresolved, uniqueNameGenerator)) {
                return;
            }
            this.myIncorporationPhase.forgetCaptures(vars);
            if (this.repeatInferencePhases()) continue;
            return;
        }
        Map map2 = substitutor.getSubstitutionMap();
        for (PsiTypeParameter parameter2 : map2.keySet()) {
            PsiTypeParameter param;
            PsiType mapping = (PsiType)map2.get(parameter2);
            if (parameter2 instanceof InferenceVariable) {
                ((InferenceVariable)parameter2).setInstantiation(mapping);
                if (((InferenceVariable)parameter2).getCallContext() != this.myContext) continue;
                param = ((InferenceVariable)parameter2).getParameter();
            } else {
                param = parameter2;
            }
            this.mySiteSubstitutor = this.mySiteSubstitutor.put(param, mapping);
        }
    }

    private boolean initFreshVariables(PsiSubstitutor substitutor, List<InferenceVariable> vars, UniqueNameGenerator nameGenerator) {
        int i;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getManager().getProject());
        PsiSubstitutor ySubstitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] yVars = new PsiTypeParameter[vars.size()];
        for (i = 0; i < vars.size(); ++i) {
            InferenceVariable var = vars.get(i);
            PsiTypeParameter parameter2 = var.getParameter();
            yVars[i] = elementFactory.createTypeParameterFromText(nameGenerator.generateUniqueName(parameter2.getName()), (PsiElement)parameter2);
            ySubstitutor = ySubstitutor.put((PsiTypeParameter)var, (PsiType)elementFactory.createType((PsiClass)yVars[i]));
        }
        for (i = 0; i < yVars.length; ++i) {
            Object lowerBound;
            PsiTypeParameter parameter3 = yVars[i];
            InferenceVariable var = vars.get(i);
            PsiType upperBound = this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, ySubstitutor.putAll(substitutor), true);
            PsiType lub = this.getLowerBound(var, substitutor);
            if (lub != PsiType.NULL) {
                for (PsiClassType upperBoundType : parameter3.getExtendsListTypes()) {
                    if (TypeConversionUtil.isAssignable((PsiType)upperBoundType, (PsiType)lub)) continue;
                    return false;
                }
                lowerBound = lub;
            } else {
                lowerBound = this.myPolicy.inferLowerBoundForFreshVariables() ? upperBound : null;
            }
            TypeConversionUtil.setInferredBoundsForSynthetic((PsiTypeParameter)parameter3, (PsiType)lowerBound, (PsiType)upperBound);
            TypeConversionUtil.markAsFreshVariable((PsiTypeParameter)parameter3, (PsiElement)this.myContext);
            if (var.addBound((PsiType)elementFactory.createType((PsiClass)parameter3), InferenceBound.EQ, this.myIncorporationPhase)) continue;
            return false;
        }
        return true;
    }

    private PsiSubstitutor resolveSubsetOrdered(Set<InferenceVariable> varsToResolve, PsiSubstitutor siteSubstitutor) {
        PsiSubstitutor substitutor = siteSubstitutor;
        Iterator<List<InferenceVariable>> varsIterator = InferenceVariablesOrder.resolveOrderIterator(varsToResolve, this);
        while (varsIterator.hasNext()) {
            List<InferenceVariable> vars = varsIterator.next();
            PsiSubstitutor resolveSubset = this.resolveSubset(vars, substitutor);
            substitutor = substitutor.putAll(resolveSubset);
        }
        return substitutor;
    }

    @NotNull
    protected final PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor) {
        if (this.myErased) {
            for (InferenceVariable var : vars) {
                substitutor = substitutor.put((PsiTypeParameter)var, null);
            }
        }
        for (InferenceVariable var : vars) {
            PsiType instantiation = var.getInstantiation();
            PsiType type2 = instantiation == PsiType.NULL ? this.checkBoundsConsistency(substitutor, var) : instantiation;
            if (type2 == PsiType.NULL) continue;
            substitutor = substitutor.put((PsiTypeParameter)var, type2);
        }
        return substitutor;
    }

    private PsiType checkBoundsConsistency(PsiSubstitutor substitutor, InferenceVariable var) {
        PsiType type2;
        PsiType eqBound = this.getEqualsBound(var, substitutor);
        if (eqBound != PsiType.NULL && eqBound instanceof PsiPrimitiveType) {
            return PsiType.NULL;
        }
        PsiType lowerBound = this.getLowerBound(var, substitutor);
        if (eqBound == PsiType.NULL) {
            lowerBound = this.myPolicy.adjustInferredType(this.myManager, lowerBound, ConstraintType.SUBTYPE);
        }
        PsiType upperBound = this.getUpperBound(var, substitutor);
        if (eqBound != PsiType.NULL && (this.myErased || eqBound != null)) {
            PsiCapturedWildcardType capturedWildcard;
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)eqBound);
            if (aClass instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)((PsiTypeParameter)aClass)) && (capturedWildcard = (PsiCapturedWildcardType)var.getUserData(ORIGINAL_CAPTURE)) != null && capturedWildcard.getUpperBound().equals(TypeConversionUtil.getInferredUpperBoundForSynthetic((PsiTypeParameter)((PsiTypeParameter)aClass)))) {
                eqBound = capturedWildcard;
            }
            if (this.isLowerBoundNotAssignable(var, eqBound, true)) {
                String incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION);
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
                return PsiType.NULL;
            }
            type2 = eqBound;
            if (this.isLowerBoundNotAssignable(var, eqBound, false)) {
                this.setErased();
            }
        } else {
            type2 = lowerBound;
        }
        if (type2 == PsiType.NULL) {
            if (var.isThrownBound() && this.myPolicy.inferRuntimeExceptionForThrownBoundWithNoConstraints() && this.isThrowable(var.getBounds(InferenceBound.UPPER))) {
                type2 = PsiType.getJavaLangRuntimeException((PsiManager)this.myManager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myManager.getProject()));
            } else {
                PsiType psiType = type2 = var.getBounds(InferenceBound.UPPER).size() == 1 ? (PsiType)this.myPolicy.getInferredTypeWithNoConstraint((PsiManager)this.myManager, (PsiType)upperBound).first : upperBound;
            }
            if (this.myErrorMessages == null && type2 instanceof PsiIntersectionType) {
                String conflictingConjunctsMessage = ((PsiIntersectionType)type2).getConflictingConjunctsMessage();
                if (conflictingConjunctsMessage == null) {
                    conflictingConjunctsMessage = InferenceSession.findParameterizationOfTheSameGenericClass(var.getBounds(InferenceBound.UPPER), (Processor<? super Pair<PsiType, PsiType>>)((Processor)pair2 -> pair2.first == null || pair2.second == null || Comparing.equal((Object)this.substituteNonProperBound((PsiType)pair2.first, substitutor), (Object)this.substituteNonProperBound((PsiType)pair2.second, substitutor)))) != null ? type2.getPresentableText(false) : InferenceSession.getConjunctsConflict((PsiIntersectionType)type2);
                }
                if (conflictingConjunctsMessage != null) {
                    this.registerIncompatibleErrorMessage("Type parameter " + var.getParameter().getName() + " has incompatible upper bounds: " + conflictingConjunctsMessage);
                    return PsiType.NULL;
                }
            }
        } else {
            for (PsiType upperType : var.getBounds(InferenceBound.UPPER)) {
                if (this.myErrorMessages != null || !this.isProperType(upperType)) continue;
                if (type2 != lowerBound && !TypeConversionUtil.isAssignable((PsiType)upperType, (PsiType)type2)) {
                    this.registerIncompatibleErrorMessage(this.incompatibleBoundsMessage(var, substitutor, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION));
                    return PsiType.NULL;
                }
                if (type2 != lowerBound) continue;
                for (PsiType lowerBoundConjunct : var.getBounds(InferenceBound.LOWER)) {
                    if (!this.isProperType(lowerBoundConjunct) || TypeConversionUtil.isAssignable((PsiType)upperType, (PsiType)lowerBoundConjunct)) continue;
                    this.registerIncompatibleErrorMessage(this.incompatibleBoundsMessage(var, substitutor, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION));
                    return PsiType.NULL;
                }
            }
        }
        if (type2 == PsiType.NULL) {
            this.registerIncompatibleErrorMessage("Incompatible upper bounds: " + StringUtil.join(var.getBounds(InferenceBound.UPPER), bound -> {
                PsiType substituted = this.substituteNonProperBound((PsiType)bound, substitutor);
                return this.getPresentableText(substituted != null ? substituted : bound);
            }, (String)", "));
        }
        return type2;
    }

    private boolean isLowerBoundNotAssignable(InferenceVariable var, PsiType eqBound, boolean allowUncheckedConversion) {
        return var.getBounds(InferenceBound.LOWER).stream().anyMatch(lBound -> this.isProperType((PsiType)lBound) && !TypeConversionUtil.isAssignable((PsiType)eqBound, (PsiType)lBound, (boolean)allowUncheckedConversion));
    }

    private static String getConjunctsConflict(PsiIntersectionType type2) {
        PsiType[] conjuncts = type2.getConjuncts();
        for (int i = 0; i < conjuncts.length; ++i) {
            PsiClass conjunct = PsiUtil.resolveClassInClassTypeOnly((PsiType)conjuncts[i]);
            for (int i1 = 0; i1 < conjuncts.length; ++i1) {
                if (i == i1) continue;
                PsiClass oppositeConjunct = PsiUtil.resolveClassInClassTypeOnly((PsiType)conjuncts[i1]);
                if (conjunct != null && oppositeConjunct != null || (!(conjuncts[i] instanceof PsiArrayType) || !TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)((PsiArrayType)conjuncts[i]), (PsiType)conjuncts[i1])) && (!(conjuncts[i] instanceof PsiCapturedWildcardType) || oppositeConjunct == null || oppositeConjunct.isInterface() || oppositeConjunct instanceof PsiTypeParameter)) continue;
                return conjuncts[i].getPresentableText() + " and " + conjuncts[i1].getPresentableText();
            }
        }
        return null;
    }

    public String getPresentableText(PsiType psiType) {
        PsiType substituted = this.myRestoreNameSubstitution.substitute(psiType);
        return substituted != null ? substituted.getPresentableText() : null;
    }

    public void registerIncompatibleErrorMessage(Collection<InferenceVariable> variables, String incompatibleTypesMessage) {
        variables = new ArrayList<InferenceVariable>(variables);
        ((ArrayList)variables).sort((v1, v2) -> Comparing.compare((Comparable)((Object)v1.getName()), (Comparable)((Object)v2.getName())));
        String variablesEnumeration = StringUtil.join(variables, variable -> variable.getParameter().getName(), (String)", ");
        this.registerIncompatibleErrorMessage("no instance(s) of type variable(s) " + variablesEnumeration + (variablesEnumeration.isEmpty() ? "" : " ") + "exist so that " + incompatibleTypesMessage);
    }

    public void registerIncompatibleErrorMessage(@NotNull String incompatibleBoundsMessage) {
        if (this.myErrorMessages == null) {
            this.myErrorMessages = new ArrayList<String>();
        }
        if (!this.myErrorMessages.contains(incompatibleBoundsMessage)) {
            this.myErrorMessages.add(incompatibleBoundsMessage);
        }
    }

    private String incompatibleBoundsMessage(InferenceVariable var, PsiSubstitutor substitutor, InferenceBound lowBound, String lowBoundName, InferenceBound upperBound, String upperBoundName) {
        Function typePresentation = type2 -> {
            PsiType substituted = this.substituteNonProperBound((PsiType)type2, substitutor);
            return this.getPresentableText(substituted != null ? substituted : type2);
        };
        return "inference variable " + var.getParameter().getName() + " has incompatible bounds:\n " + lowBoundName + ": " + StringUtil.join(var.getBounds(lowBound), (Function)typePresentation, (String)", ") + "\n" + upperBoundName + ": " + StringUtil.join(var.getBounds(upperBound), (Function)typePresentation, (String)", ");
    }

    private PsiType getLowerBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.LOWER, (Function<? super Pair<PsiType, PsiType>, ? extends PsiType>)((Function)pair2 -> GenericsUtil.getLeastUpperBound((PsiType)((PsiType)pair2.first), (PsiType)((PsiType)pair2.second), (PsiManager)this.myManager)), substitutor);
    }

    private PsiType getUpperBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, substitutor);
    }

    private PsiType getEqualsBound(InferenceVariable var, PsiSubstitutor substitutor) {
        return this.composeBound(var, InferenceBound.EQ, (Function<? super Pair<PsiType, PsiType>, ? extends PsiType>)((Function)pair2 -> !Comparing.equal((Object)pair2.first, (Object)pair2.second) ? null : (PsiType)pair2.first), substitutor);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<? super Pair<PsiType, PsiType>, ? extends PsiType> fun, PsiSubstitutor substitutor) {
        return this.composeBound(variable, boundType, fun, substitutor, false);
    }

    private PsiType composeBound(InferenceVariable variable, InferenceBound boundType, Function<? super Pair<PsiType, PsiType>, ? extends PsiType> fun, PsiSubstitutor substitutor, boolean includeNonProperBounds) {
        List<PsiType> bounds = variable.getBounds(boundType);
        PsiPrimitiveType lub = PsiType.NULL;
        for (PsiType bound : bounds) {
            bound = this.substituteNonProperBound(bound, substitutor);
            if (!includeNonProperBounds && !this.isProperType(bound)) continue;
            if (lub == PsiType.NULL) {
                lub = bound;
                continue;
            }
            Pair pair2 = Pair.create((Object)lub, (Object)bound);
            if ((lub = (PsiType)fun.fun((Object)pair2)) != null) continue;
            return PsiType.NULL;
        }
        return lub;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        if (this.myContext != null) {
            return this.myContext.getResolveScope();
        }
        return GlobalSearchScope.allScope((Project)this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (this.myConstraintsCopy.add(constraint)) {
            if (constraint instanceof ExpressionCompatibilityConstraint && InferenceSession.ignoreLambdaConstraintTree(((ExpressionCompatibilityConstraint)constraint).getExpression())) {
                LOG.error("Should have been stopped at lambda under overload guard");
            }
            this.myConstraints.add(constraint);
        }
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        PsiSubstitutor siteSubstitutor = PsiSubstitutor.EMPTY;
        while (!additionalConstraints.isEmpty()) {
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints, ignoredConstraints);
            LinkedHashSet<InferenceVariable> varsToResolve = new LinkedHashSet<InferenceVariable>();
            for (ConstraintFormula formula : subset) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
            }
            PsiSubstitutor substitutor = this.resolveSubsetOrdered(varsToResolve, siteSubstitutor);
            for (ConstraintFormula formula : subset) {
                if (this.processOneConstraint(formula, additionalConstraints, substitutor, ignoredConstraints)) continue;
                return false;
            }
        }
        return true;
    }

    private void collectVarsToResolve(Set<? super InferenceVariable> varsToResolve, InputOutputConstraintFormula formula) {
        Set<InferenceVariable> inputVariables = formula.getInputVariables(this);
        if (inputVariables != null) {
            for (InferenceVariable inputVariable : inputVariables) {
                varsToResolve.addAll(inputVariable.getDependencies(this));
            }
            varsToResolve.addAll(inputVariables);
        }
    }

    private boolean processOneConstraint(ConstraintFormula formula, Set<ConstraintFormula> additionalConstraints, PsiSubstitutor substitutor, Set<ConstraintFormula> ignoredConstraints) {
        PsiExpression expression2;
        formula.apply(substitutor, true);
        if (formula instanceof InputOutputConstraintFormula) {
            this.myTempTypes.forceType((PsiElement)((InputOutputConstraintFormula)formula).getExpression(), ((InputOutputConstraintFormula)formula).getCurrentType());
        }
        this.addConstraint(formula);
        if (!this.repeatInferencePhases()) {
            return false;
        }
        if (formula instanceof ExpressionCompatibilityConstraint && (expression2 = ((ExpressionCompatibilityConstraint)formula).getExpression()) instanceof PsiLambdaExpression) {
            PsiType parameterType = ((PsiLambdaExpression)expression2).getGroundTargetType(((ExpressionCompatibilityConstraint)formula).getCurrentType());
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)expression2, parameterType, !this.isProperType(parameterType), substitutor);
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        Set<InferenceVariable> outputVariables = this.getOutputVariables(additionalConstraints);
        Set<InferenceVariable> ignoredOutputVariables = this.getOutputVariables(ignoredConstraints);
        LinkedHashSet<ConstraintFormula> subset = new LinkedHashSet<ConstraintFormula>();
        LinkedHashSet<ConstraintFormula> noInputVariables = new LinkedHashSet<ConstraintFormula>();
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                Set<InferenceVariable> inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        if (dependsOnOutput) break;
                        Set<InferenceVariable> dependencies = inputVariable.getDependencies(this);
                        dependencies.add(inputVariable);
                        if (!this.hasCapture(inputVariable)) {
                            if (this.dependsOnOutput(ignoredOutputVariables, dependencies)) {
                                dependsOnOutput = true;
                                ignoredConstraints.add(constraint);
                                break;
                            }
                            dependsOnOutput = this.dependsOnOutput(outputVariables, dependencies);
                        }
                        dependencies.retainAll(outputVariables);
                        if (dependencies.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    if (!inputVariables.isEmpty()) continue;
                    noInputVariables.add(constraint);
                    continue;
                }
                subset.add(constraint);
                noInputVariables.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            additionalConstraints.removeAll(ignoredConstraints);
            if (!additionalConstraints.isEmpty()) {
                subset.add(additionalConstraints.iterator().next());
            }
        }
        if (!noInputVariables.isEmpty()) {
            subset = noInputVariables;
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    private boolean dependsOnOutput(Set<InferenceVariable> outputVariables, Set<InferenceVariable> dependencies) {
        for (InferenceVariable outputVariable : outputVariables) {
            if (!ContainerUtil.intersects(outputVariable.getDependencies(this), dependencies)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Set<InferenceVariable> getOutputVariables(Set<ConstraintFormula> constraintFormulas) {
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : constraintFormulas) {
            Set<InferenceVariable> inputVariables;
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        return outputVariables;
    }

    public PsiSubstitutor collectApplicabilityConstraints(PsiMethodReferenceExpression reference, MethodCandidateInfo candidateInfo, PsiType functionalInterfaceType) {
        block12: {
            PsiSubstitutor psiSubstitutor;
            boolean isStatic;
            PsiParameter[] parameters2;
            PsiParameter[] functionalMethodParameters;
            PsiClass containingClass;
            PsiClass methodContainingClass;
            PsiMethod method;
            boolean varargs;
            MethodSignature signature;
            block11: {
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
                LOG.assertTrue(interfaceMethod != null, (Object)this.myContext);
                PsiSubstitutor functionalInterfaceSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult);
                signature = interfaceMethod.getSignature(functionalInterfaceSubstitutor);
                varargs = candidateInfo.isVarargs();
                method = candidateInfo.getElement();
                methodContainingClass = method.getContainingClass();
                PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)reference);
                containingClass = qualifierResolveResult.getContainingClass();
                if (containingClass == null) {
                    return this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
                }
                functionalMethodParameters = interfaceMethod.getParameterList().getParameters();
                parameters2 = method.getParameterList().getParameters();
                isStatic = method.hasModifierProperty("static");
                psiSubstitutor = qualifierResolveResult.getSubstitutor();
                if ((parameters2.length != functionalMethodParameters.length || varargs) && (!isStatic || !varargs)) break block11;
                if (method.isConstructor() && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)psiSubstitutor)) {
                    this.initBounds(containingClass.getTypeParameters());
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
                if (methodContainingClass != null && (psiSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), psiSubstitutor)) == null) {
                    LOG.error("derived: " + containingClass + "; super: " + methodContainingClass + "; reference: " + reference.getText() + "; containingFile: " + reference.getContainingFile().getName());
                }
                for (int i = 0; i < functionalMethodParameters.length; ++i) {
                    PsiType pType = signature.getParameterTypes()[i];
                    this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards((PsiType)pType, (PsiElement)functionalMethodParameters[i])));
                }
                break block12;
            }
            if (!PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)reference, (MethodSignature)signature, (boolean)varargs, (boolean)isStatic, (int)parameters2.length)) break block12;
            PsiType pType = signature.getParameterTypes()[0];
            if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)psiSubstitutor)) {
                PsiSubstitutor receiverSubstitutor;
                PsiClassType subclassType = StrictSubtypingConstraint.getSubclassType(containingClass, pType, true);
                PsiSubstitutor psiSubstitutor2 = receiverSubstitutor = subclassType != null ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClassType)((PsiClassType)PsiUtil.captureToplevelWildcards((PsiType)subclassType, (PsiElement)this.myContext))) : null;
                if (receiverSubstitutor != null) {
                    if (!method.hasTypeParameters() && (signature.getParameterTypes().length == 1 || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)receiverSubstitutor))) {
                        return methodContainingClass != null ? JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), receiverSubstitutor) : receiverSubstitutor;
                    }
                    this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(receiverSubstitutor);
                    if (methodContainingClass != null) {
                        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), receiverSubstitutor);
                        LOG.assertTrue(superSubstitutor != null, (Object)("mContainingClass: " + methodContainingClass.getName() + "; containingClass: " + containingClass.getName()));
                        this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(superSubstitutor);
                    }
                    psiSubstitutor = receiverSubstitutor;
                }
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
            if (PsiUtil.isArrayClass((PsiElement)containingClass)) {
                return null;
            }
            PsiClassType qType = factory.createType(containingClass, psiSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables((PsiType)qType), PsiUtil.captureToplevelWildcards((PsiType)pType, (PsiElement)reference)));
            if (methodContainingClass != null) {
                psiSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), psiSubstitutor);
                LOG.assertTrue(psiSubstitutor != null, (Object)("derived: " + containingClass + "; super: " + methodContainingClass + "; reference: " + reference.getText() + "; containingFile: " + reference.getContainingFile().getName()));
            }
            for (int i = 0; i < signature.getParameterTypes().length - 1; ++i) {
                PsiType interfaceParamType = signature.getParameterTypes()[i + 1];
                this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards((PsiType)interfaceParamType, (PsiElement)functionalMethodParameters[i])));
            }
        }
        return null;
    }

    public void setErased() {
        this.myErased = true;
    }

    private InferenceVariable getInferenceVariable(PsiTypeParameter parameter2) {
        return parameter2 instanceof InferenceVariable && this.myInferenceVariables.contains(parameter2) ? (InferenceVariable)parameter2 : null;
    }

    public static boolean isMoreSpecific(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context, boolean varargs) {
        return (Boolean)LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])m1.getTypeParameters(), (PsiSubstitutor)siteSubstitutor1, () -> InferenceSession.isMoreSpecificInternal(m1, m2, siteSubstitutor1, args, context, varargs));
    }

    private static boolean isMoreSpecificInternal(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context, boolean varargs) {
        InferenceSession session = new InferenceSession(m2.getTypeParameters(), siteSubstitutor1, m2.getManager(), context);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        PsiParameter[] parameters2 = m2.getParameterList().getParameters();
        if (!varargs) {
            LOG.assertTrue(parameters1.length == parameters2.length);
        }
        int paramsLength = !varargs ? parameters1.length : Math.max(parameters1.length, parameters2.length) - 1;
        for (int i = 0; i < paramsLength; ++i) {
            PsiType sType = InferenceSession.getParameterType(parameters1, i, siteSubstitutor1, varargs);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i, siteSubstitutor1, varargs));
            if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)m2, (PsiSubstitutor)siteSubstitutor1)) {
                tType = TypeConversionUtil.erasure((PsiType)tType);
            }
            if (sType instanceof PsiClassType && tType instanceof PsiClassType && LambdaUtil.isFunctionalType((PsiType)sType) && LambdaUtil.isFunctionalType((PsiType)tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args[i])) continue;
                return false;
            }
            if (session.isProperType(tType) && !TypeConversionUtil.isAssignable((PsiType)tType, (PsiType)sType)) {
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = InferenceSession.getParameterType(parameters1, paramsLength, siteSubstitutor1, true);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, paramsLength, siteSubstitutor1, true));
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases();
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiType capturedSType = sType;
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType((PsiType)capturedSType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)sInterfaceMethod, (PsiClassType.ClassResolveResult)sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType((PsiType)tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)tInterfaceMethod, (PsiClassType.ClassResolveResult)tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    private static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals((Object)tReturnType)) {
                return true;
            }
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)arg));
            if (sReturnType instanceof PsiClassType && tReturnType instanceof PsiClassType && LambdaUtil.isFunctionalType((PsiType)sReturnType) && LambdaUtil.isFunctionalType((PsiType)tReturnType) && !TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)sReturnType), (PsiType)TypeConversionUtil.erasure((PsiType)tReturnType)) && !TypeConversionUtil.isAssignable((PsiType)TypeConversionUtil.erasure((PsiType)tReturnType), (PsiType)TypeConversionUtil.erasure((PsiType)sReturnType))) {
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(PsiExpression.EMPTY_ARRAY))) {
                    return false;
                }
            } else {
                boolean tPrimitive;
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)sReturnType);
                boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)tReturnType);
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression2 : returnExpressions) {
                        if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)returnExpression2)) {
                            PsiType returnExpressionType = returnExpression2.getType();
                            if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                            return false;
                        }
                        if (!sPrimitive) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable((PsiType)tReturnType, (PsiType)sReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            boolean tPrimitive;
            PsiParameter[] tParameters;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            if (sParameters.length != (tParameters = tInterfaceMethod.getParameterList().getParameters()).length) {
                LOG.error("s: " + sInterfaceMethod.getParameterList().getText() + "; t: " + tInterfaceMethod.getParameterList().getText());
            }
            for (int i = 0; i < tParameters.length; ++i) {
                PsiType tSubstituted = tSubstitutor.substitute(tParameters[i].getType());
                PsiType sSubstituted = sSubstitutor.substitute(sParameters[i].getType());
                if (session != null) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                    continue;
                }
                if (Comparing.equal((Object)tSubstituted, (Object)sSubstituted)) continue;
                return false;
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals((Object)tReturnType)) {
                return true;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)sReturnType);
            boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)tReturnType);
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null, (Object)arg);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)methodReturnType) || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable((PsiType)tReturnType, (PsiType)sReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression2 = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression2 = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression2, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression2, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiSwitchExpression) {
            return PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)((PsiSwitchExpression)arg)).stream().allMatch(resultExpression -> InferenceSession.argConstraints(resultExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor));
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure((PsiType)tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure((PsiType)sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable((PsiType)sConjunctErasure, (PsiType)erasedType);
                subRelation |= TypeConversionUtil.isAssignable((PsiType)erasedType, (PsiType)sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure((PsiType)sType)) != null) {
            return TypeConversionUtil.isAssignable((PsiType)sTypeErasure, (PsiType)erasedType) || TypeConversionUtil.isAssignable((PsiType)erasedType, (PsiType)sTypeErasure);
        }
        return false;
    }

    void collectCaptureDependencies(InferenceVariable inferenceVariable, Set<? super InferenceVariable> dependencies) {
        this.myIncorporationPhase.collectCaptureDependencies(inferenceVariable, dependencies);
    }

    boolean hasCapture(InferenceVariable inferenceVariable) {
        return this.myIncorporationPhase.hasCaptureConstraints(Collections.singletonList(inferenceVariable));
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public final void propagateVariables(@NotNull InferenceSession from) {
        this.myInferenceVariables.addAll(from.getInferenceVariables());
        this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.putAll(from.getRestoreNameSubstitution());
    }

    public PsiType substituteWithInferenceVariables(@Nullable PsiType type2) {
        return this.myInferenceSubstitution.substitute(type2);
    }

    public PsiSubstitutor getInferenceSubstitution() {
        return this.myInferenceSubstitution;
    }

    public PsiSubstitutor getRestoreNameSubstitution() {
        return this.myRestoreNameSubstitution;
    }

    public InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    public PsiType startWithFreshVars(PsiType type2) {
        PsiSubstitutor s = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : this.myInferenceVariables) {
            s = s.put((PsiTypeParameter)variable, (PsiType)JavaPsiFacade.getElementFactory((Project)this.myManager.getProject()).createType((PsiClass)variable.getParameter()));
        }
        return s.substitute(type2);
    }

    public static PsiClass findParameterizationOfTheSameGenericClass(List<? extends PsiType> upperBounds, Processor<? super Pair<PsiType, PsiType>> processor2) {
        for (int i = 0; i < upperBounds.size(); ++i) {
            PsiType sBound = upperBounds.get(i);
            PsiClass sClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)sBound);
            if (sClass == null) continue;
            LinkedHashSet superClasses = InheritanceUtil.getSuperClasses((PsiClass)sClass);
            superClasses.add(sClass);
            for (int j = i + 1; j < upperBounds.size(); ++j) {
                PsiType tBound = upperBounds.get(j);
                PsiClass tClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)tBound);
                if (tClass == null) continue;
                LinkedHashSet<PsiClass> tSupers = new LinkedHashSet<PsiClass>();
                tSupers.add(tClass);
                tSupers.addAll(InheritanceUtil.getSuperClasses((PsiClass)tClass));
                tSupers.retainAll(superClasses);
                for (PsiClass gClass : tSupers) {
                    PsiSubstitutor sSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)gClass, (PsiClassType)((PsiClassType)sBound));
                    PsiSubstitutor tSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)gClass, (PsiClassType)((PsiClassType)tBound));
                    boolean found = false;
                    for (PsiTypeParameter typeParameter : gClass.getTypeParameters()) {
                        PsiType tType;
                        PsiType sType = sSubstitutor.substituteWithBoundsPromotion(typeParameter);
                        Pair typePair = Pair.create((Object)sType, (Object)(tType = tSubstitutor.substituteWithBoundsPromotion(typeParameter)));
                        if (processor2.process((Object)typePair)) continue;
                        found = true;
                    }
                    if (!found) continue;
                    return gClass;
                }
            }
        }
        return null;
    }

    public List<String> getIncompatibleErrorMessages() {
        return this.myErrorMessages;
    }

    public boolean isErased() {
        return this.myErased;
    }
}

