/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiRecordComponentStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiRecordComponentImpl
extends JavaStubPsiElement<PsiRecordComponentStub>
implements PsiRecordComponent {
    private volatile Reference<PsiType> myCachedType;

    public PsiRecordComponentImpl(@NotNull PsiRecordComponentStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.RECORD_COMPONENT);
    }

    public PsiRecordComponentImpl(@NotNull ASTNode node) {
        super(node);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitRecordComponent((PsiRecordComponent)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            return null;
        }
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof PsiClass ? (PsiClass)grandParent : null;
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList modifierList = (PsiModifierList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        assert (modifierList != null) : this;
        return modifierList;
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        return this.getModifierList().hasModifierProperty(name2);
    }

    @NotNull
    public PsiType getType() {
        PsiRecordComponentStub stub = (PsiRecordComponentStub)this.getStub();
        if (stub != null) {
            PsiType type2 = (PsiType)SoftReference.dereference(this.myCachedType);
            if (type2 == null) {
                String typeText = TypeInfo.createTypeText(stub.getType(false));
                assert (typeText != null) : stub;
                type2 = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade().createTypeFromText(typeText, (PsiElement)this);
                type2 = JavaSharedImplUtil.applyAnnotations(type2, this.getModifierList());
                this.myCachedType = new SoftReference((Object)type2);
            }
            return type2;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        return JavaSharedImplUtil.getType(typeElement, (PsiElement)this.getNameIdentifier());
    }

    @NotNull
    public PsiTypeElement getTypeElement() {
        return (PsiTypeElement)this.findNotNullChildByType(JavaElementType.TYPE);
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        JavaSharedImplUtil.normalizeBrackets((PsiVariable)this);
    }

    @Nullable
    public Object computeConstantValue() {
        return null;
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.findNotNullChildByType(JavaTokenType.IDENTIFIER);
    }

    @Override
    public int getTextOffset() {
        return this.getNameIdentifier().getTextOffset();
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        PsiIdentifier identifier = this.getNameIdentifier();
        return PsiImplUtil.setName((PsiElement)identifier, name2);
    }

    @NotNull
    public String getName() {
        PsiRecordComponentStub stub = (PsiRecordComponentStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        return this.getNameIdentifier().getText();
    }

    @NotNull
    public CompositeElement getNode() {
        return (CompositeElement)super.getNode();
    }

    @Nullable
    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public boolean isVarArgs() {
        PsiRecordComponentStub stub = (PsiRecordComponentStub)this.getGreenStub();
        if (stub != null) {
            return stub.isVararg();
        }
        return this.getType() instanceof PsiEllipsisType;
    }

    public String toString() {
        return "PsiRecordComponent:" + this.getName();
    }
}

