/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.lang.ref.Reference;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiParameterImpl
extends JavaStubPsiElement<PsiParameterStub>
implements PsiParameter {
    private static final Logger LOG = Logger.getInstance(PsiParameterImpl.class);
    private volatile Reference<PsiType> myCachedType;

    public PsiParameterImpl(@NotNull PsiParameterStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.PARAMETER);
    }

    protected PsiParameterImpl(@NotNull PsiParameterStub stub, @NotNull IStubElementType type2) {
        super(stub, type2);
    }

    public PsiParameterImpl(@NotNull ASTNode node) {
        super(node);
    }

    public static PsiType getLambdaParameterType(PsiParameter param) {
        PsiLambdaExpression lambdaExpression;
        int parameterIndex;
        PsiElement paramParent = param.getParent();
        if (paramParent instanceof PsiParameterList && (parameterIndex = ((PsiParameterList)paramParent).getParameterIndex(param)) > -1 && (lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)param, PsiLambdaExpression.class)) != null) {
            PsiType functionalInterfaceType = (PsiType)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)param, false, () -> LambdaUtil.getFunctionalInterfaceType((PsiElement)lambdaExpression, (boolean)true));
            PsiType type2 = lambdaExpression.getGroundTargetType(functionalInterfaceType);
            if (type2 instanceof PsiIntersectionType) {
                PsiType[] conjuncts;
                for (PsiType conjunct : conjuncts = ((PsiIntersectionType)type2).getConjuncts()) {
                    PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType((PsiType)conjunct, (int)parameterIndex);
                    if (lambdaParameterFromType == null) continue;
                    return lambdaParameterFromType;
                }
            } else {
                PsiType lambdaParameterFromType = LambdaUtil.getLambdaParameterFromType((PsiType)type2, (int)parameterIndex);
                if (lambdaParameterFromType != null) {
                    return lambdaParameterFromType;
                }
            }
        }
        return new PsiLambdaParameterType(param);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiParameterImpl clone = (PsiParameterImpl)((Object)super.clone());
        clone.myCachedType = null;
        return clone;
    }

    @NotNull
    public final String getName() {
        PsiParameterStub stub = (PsiParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        return this.getNameIdentifier().getText();
    }

    public final PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name2);
        return this;
    }

    @NotNull
    public final PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)PsiTreeUtil.getRequiredChildOfType((PsiElement)this, PsiIdentifier.class);
    }

    @NotNull
    public CompositeElement getNode() {
        return (CompositeElement)super.getNode();
    }

    @NotNull
    public PsiType getType() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            PsiType type2 = (PsiType)SoftReference.dereference(this.myCachedType);
            if (type2 == null) {
                String typeText = TypeInfo.createTypeText(stub.getType(false));
                assert (typeText != null) : stub;
                type2 = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade().createTypeFromText(typeText, (PsiElement)this);
                type2 = JavaSharedImplUtil.applyAnnotations(type2, this.getModifierList());
                this.myCachedType = new SoftReference((Object)type2);
            }
            return type2;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        if (typeElement == null || this.isLambdaParameter() && typeElement.isInferredType()) {
            assert (this.isLambdaParameter()) : this;
            return PsiParameterImpl.getLambdaParameterType(this);
        }
        return JavaSharedImplUtil.getType(typeElement, (PsiElement)this.getNameIdentifier());
    }

    private boolean isLambdaParameter() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression;
    }

    public PsiTypeElement getTypeElement() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiTypeElement)) continue;
            return (PsiTypeElement)child;
        }
        return null;
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList modifierList = (PsiModifierList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
        assert (modifierList != null) : this;
        return modifierList;
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        return this.getModifierList().hasModifierProperty(name2);
    }

    public PsiExpression getInitializer() {
        return null;
    }

    public boolean hasInitializer() {
        return false;
    }

    public Object computeConstantValue() {
        return null;
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        JavaSharedImplUtil.normalizeBrackets((PsiVariable)this);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameter((PsiParameter)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiParameter:" + this.getName();
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            return this;
        }
        if (parent instanceof PsiParameterList) {
            return parent.getParent();
        }
        if (parent instanceof PsiForeachStatement) {
            return parent;
        }
        if (parent instanceof PsiCatchSection) {
            return parent;
        }
        PsiElement[] children = parent.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].equals((Object)this)) continue;
                for (int j = i + 1; j < children.length; ++j) {
                    if (!(children[j] instanceof PsiCodeBlock)) continue;
                    return children[j];
                }
                break;
            }
        }
        LOG.error("Code block not found among parameter' (" + (Object)((Object)this) + ") parent' (" + parent + ") children: " + Arrays.asList(children));
        return null;
    }

    public boolean isVarArgs() {
        PsiParameterStub stub = (PsiParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.isParameterTypeEllipsis();
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        return typeElement != null && SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)typeElement).findChildByType(JavaTokenType.ELLIPSIS) != null;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, PlatformIcons.PARAMETER_ICON, 0);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiElement declarationScope = this.getDeclarationScope();
        return new LocalSearchScope(declarationScope);
    }

    public PsiElement getOriginalElement() {
        PsiParameter[] originalParameters;
        int index;
        PsiElement originalMethod;
        PsiElement gParent;
        PsiElement parent = this.getParent();
        if (parent instanceof PsiParameterList && (gParent = parent.getParent()) instanceof PsiMethod && (originalMethod = gParent.getOriginalElement()) instanceof PsiMethod && originalMethod != gParent && (index = ((PsiParameterList)parent).getParameterIndex((PsiParameter)this)) < (originalParameters = ((PsiMethod)originalMethod).getParameterList().getParameters()).length) {
            return originalParameters[index];
        }
        return this;
    }
}

