/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.light.LightCompactConstructorParameter;
import com.intellij.psi.impl.light.LightParameterListBuilder;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiMethodImpl
extends JavaStubPsiElement<PsiMethodStub>
implements PsiMethod,
Queryable {
    private SoftReference<PsiType> myCachedType;

    public PsiMethodImpl(PsiMethodStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.METHOD);
    }

    protected PsiMethodImpl(PsiMethodStub stub, IStubElementType type2) {
        super(stub, type2);
    }

    public PsiMethodImpl(ASTNode node) {
        super(node);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    protected void dropCached() {
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiMethodImpl clone = (PsiMethodImpl)((Object)super.clone());
        clone.dropCached();
        return clone;
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
    }

    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
    }

    public PsiMethod @NotNull [] findSuperMethods() {
        return PsiSuperMethodImplUtil.findSuperMethods(this);
    }

    public PsiMethod @NotNull [] findSuperMethods(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
    }

    public PsiMethod @NotNull [] findSuperMethods(PsiClass parentClass) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
    }

    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    public PsiMethod @NotNull [] findDeepestSuperMethods() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
    }

    @NotNull
    public String getName() {
        PsiIdentifier nameIdentifier;
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        String name2 = stub != null ? stub.getName() : ((nameIdentifier = this.getNameIdentifier()) == null ? null : nameIdentifier.getText());
        return name2 != null ? name2 : "<unnamed>";
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        return PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        PsiIdentifier identifier = this.getNameIdentifier();
        if (identifier == null) {
            throw new IncorrectOperationException("Empty name: " + (Object)((Object)this));
        }
        PsiImplUtil.setName((PsiElement)identifier, name2);
        return this;
    }

    public PsiTypeElement getReturnTypeElement() {
        if (this.isConstructor()) {
            return null;
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    public PsiTypeParameterList getTypeParameterList() {
        return (PsiTypeParameterList)this.getRequiredStubOrPsiChild((IStubElementType)JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    public PsiTypeParameter @NotNull [] getTypeParameters() {
        return PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
    }

    public PsiType getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            PsiType type2 = (PsiType)SoftReference.dereference(this.myCachedType);
            if (type2 == null) {
                String typeText = TypeInfo.createTypeText(stub.getReturnTypeText(false));
                assert (typeText != null) : stub;
                type2 = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade().createTypeFromText(typeText, (PsiElement)this);
                type2 = JavaSharedImplUtil.applyAnnotations(type2, this.getModifierList());
                this.myCachedType = new SoftReference((Object)type2);
            }
            return type2;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getReturnTypeElement();
        return typeElement != null ? JavaSharedImplUtil.getType(typeElement, (PsiElement)this.getParameterList()) : null;
    }

    @NotNull
    public PsiModifierList getModifierList() {
        return (PsiModifierList)this.getRequiredStubOrPsiChild((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        return this.getModifierList().hasModifierProperty(name2);
    }

    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList list = (PsiParameterList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.PARAMETER_LIST);
        if (list == null) {
            return (PsiParameterList)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
                LightParameterListBuilder lightList = new LightParameterListBuilder((PsiManager)this.getManager(), this.getLanguage());
                PsiClass aClass = this.getContainingClass();
                if (aClass != null) {
                    PsiRecordComponent[] recordComponents;
                    for (PsiRecordComponent component : recordComponents = aClass.getRecordComponents()) {
                        String name2 = component.getName();
                        if (name2 == null) continue;
                        lightList.addParameter(new LightCompactConstructorParameter(name2, component.getType(), (PsiElement)this, component));
                    }
                }
                return CachedValueProvider.Result.create((Object)((Object)lightList), (Object[])new Object[]{this, PsiModificationTracker.MODIFICATION_COUNT});
            });
        }
        return list;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList child = (PsiReferenceList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.THROWS_LIST);
        if (child != null) {
            return child;
        }
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        Stream<String> children = stub != null ? stub.getChildrenStubs().stream().map(s -> s.getClass().getSimpleName() + " : " + s.getStubType()) : Stream.of(this.getChildren()).map(e -> e.getClass().getSimpleName() + " : " + e.getNode().getElementType());
        throw new AssertionError((Object)("Missing throws list, file=" + this.getContainingFile() + " children:\n" + children.collect(Collectors.joining("\n"))));
    }

    public PsiCodeBlock getBody() {
        return (PsiCodeBlock)this.getNode().findChildByRoleAsPsiElement(17);
    }

    @NotNull
    public CompositeElement getNode() {
        return (CompositeElement)super.getNode();
    }

    public boolean isDeprecated() {
        return JavaStubImplUtil.isMemberDeprecated(this, (PsiMemberStub)this.getGreenStub());
    }

    public PsiDocComment getDocComment() {
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        if (stub != null && !stub.hasDocComment()) {
            return null;
        }
        return (PsiDocComment)this.getNode().findChildByRoleAsPsiElement(7);
    }

    public boolean isConstructor() {
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        return this.getNode().findChildByRole(10) == null;
    }

    public boolean isVarArgs() {
        PsiMethodStub stub = (PsiMethodStub)this.getGreenStub();
        if (stub != null) {
            return stub.isVarArgs();
        }
        return PsiImplUtil.isVarArgs(this);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitMethod((PsiMethod)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiMethod:" + this.getName();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return PsiImplUtil.processDeclarationsInMethod(this, processor2, state, lastParent, place);
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == PsiSubstitutor.EMPTY) {
            return (MethodSignature)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return CachedValueProvider.Result.create((Object)signature, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            });
        }
        return MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
    }

    public PsiElement getOriginalElement() {
        PsiMethod originalMethod;
        PsiElement original;
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && (original = containingClass.getOriginalElement()) != containingClass && (originalMethod = ((PsiClass)original).findMethodBySignature((PsiMethod)this, false)) != null) {
            return originalMethod;
        }
        return this;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, methodIcon, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @NotNull
    public SearchScope getUseScope() {
        return (SearchScope)ReadAction.compute(() -> PsiImplUtil.getMemberUseScope((PsiMember)this));
    }

    public void putInfo(@NotNull Map<String, String> info) {
        info.put("methodName", this.getName());
    }

    protected boolean isVisibilitySupported() {
        return true;
    }
}

