/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.CharTable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaDummyHolder
extends DummyHolder
implements PsiImportHolder {
    private static final Map<String, PsiClass> EMPTY = Collections.emptyMap();
    private Map<String, PsiClass> myPseudoImports = EMPTY;
    private InjectedDeclarations myInjectedDeclarations;

    JavaDummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context) {
        super(manager, contentElement, context, null, null, JavaDummyHolder.language((PsiElement)context, (Language)JavaLanguage.INSTANCE));
    }

    JavaDummyHolder(@NotNull PsiManager manager, CharTable table, boolean validity) {
        super(manager, null, null, table, Boolean.valueOf(validity), (Language)JavaLanguage.INSTANCE);
    }

    JavaDummyHolder(@NotNull PsiManager manager, PsiElement context) {
        super(manager, null, context, null, null, JavaDummyHolder.language((PsiElement)context, (Language)JavaLanguage.INSTANCE));
    }

    JavaDummyHolder(@NotNull PsiManager manager, TreeElement contentElement, PsiElement context, CharTable table) {
        super(manager, contentElement, context, table, null, JavaDummyHolder.language((PsiElement)context, (Language)JavaLanguage.INSTANCE));
    }

    JavaDummyHolder(@NotNull PsiManager manager, PsiElement context, CharTable table) {
        super(manager, null, context, table, null, JavaDummyHolder.language((PsiElement)context, (Language)JavaLanguage.INSTANCE));
    }

    JavaDummyHolder(@NotNull PsiManager manager, CharTable table) {
        super(manager, null, null, table, null, (Language)JavaLanguage.INSTANCE);
    }

    public boolean importClass(@NotNull PsiClass aClass) {
        PsiClass resolved;
        PsiElement context = this.getContext();
        String className2 = aClass.getName();
        if (context != null && className2 != null && (resolved = JavaPsiFacade.getInstance((Project)this.getProject()).getResolveHelper().resolveReferencedClass(className2, context)) != null) {
            return this.getManager().areElementsEquivalent((PsiElement)aClass, (PsiElement)resolved);
        }
        if (!this.myPseudoImports.containsKey(className2)) {
            if (this.myPseudoImports == EMPTY) {
                this.myPseudoImports = new LinkedHashMap<String, PsiClass>();
            }
            this.myPseudoImports.put(className2, aClass);
            this.myManager.beforeChange(false);
        }
        return true;
    }

    public void setInjectedDeclarations(@NotNull InjectedDeclarations injectedDeclarations) {
        this.myInjectedDeclarations = injectedDeclarations;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ElementClassHint classHint2 = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (classHint2 == null || classHint2.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            String name2;
            NameHint nameHint = (NameHint)processor2.getHint(NameHint.KEY);
            String string = name2 = nameHint != null ? nameHint.getName(state) : null;
            if (name2 != null) {
                PsiClass imported = this.myPseudoImports.get(name2);
                if (imported != null && !processor2.execute((PsiElement)imported, state)) {
                    return false;
                }
            } else {
                for (PsiClass aClass : this.myPseudoImports.values()) {
                    if (processor2.execute((PsiElement)aClass, state)) continue;
                    return false;
                }
            }
            if (this.getContext() == null) {
                return JavaResolveUtil.processImplicitlyImportedPackages(processor2, state, place, this.getManager());
            }
        }
        if (this.myInjectedDeclarations != null) {
            return this.myInjectedDeclarations.process(processor2, state, lastParent, place);
        }
        return true;
    }

    public boolean isSamePackage(PsiElement other) {
        PsiElement myContext = this.getContext();
        if (other instanceof DummyHolder) {
            PsiElement otherContext = other.getContext();
            if (myContext == null || otherContext == null) {
                return myContext == otherContext;
            }
            return JavaPsiFacade.getInstance((Project)myContext.getProject()).arePackagesTheSame(myContext, otherContext);
        }
        if (other instanceof PsiJavaFile) {
            if (myContext != null) {
                return JavaPsiFacade.getInstance((Project)myContext.getProject()).arePackagesTheSame(myContext, other);
            }
            String packageName = ((PsiJavaFile)other).getPackageName();
            return packageName.isEmpty();
        }
        return false;
    }

    public boolean isInPackage(PsiPackage aPackage) {
        PsiElement myContext = this.getContext();
        if (myContext != null) {
            return JavaPsiFacade.getInstance((Project)myContext.getProject()).isInPackage(myContext, aPackage);
        }
        return aPackage == null || aPackage.getQualifiedName().isEmpty();
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        super.setOriginalFile(originalFile);
        this.putUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY, PsiUtil.getLanguageLevel((PsiElement)originalFile));
    }

    @FunctionalInterface
    public static interface InjectedDeclarations {
        public boolean process(@NotNull PsiScopeProcessor var1, @NotNull ResolveState var2, PsiElement var3, @NotNull PsiElement var4);
    }
}

