/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRecordComponentSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiRecordComponent recordComponent;
        RecordNavigationInfo info;
        PsiElement element = queryParameters.getElementToSearch();
        if (element instanceof PsiRecordComponent && (info = JavaRecordComponentSearcher.findNavigationInfo(recordComponent = (PsiRecordComponent)element)) != null) {
            SearchRequestCollector optimizer = queryParameters.getOptimizer();
            optimizer.searchWord(info.myName, queryParameters.getEffectiveSearchScope(), true, (PsiElement)info.myLightMethod);
            optimizer.searchWord(info.myName, info.myLightField.getUseScope(), true, (PsiElement)info.myLightField);
            PsiParameter parameter2 = info.myLightCompactConstructorParameter;
            if (parameter2 != null) {
                optimizer.searchWord(info.myName, (SearchScope)new LocalSearchScope(parameter2.getDeclarationScope()), true, (PsiElement)parameter2);
            }
        }
    }

    private static RecordNavigationInfo findNavigationInfo(PsiRecordComponent recordComponent) {
        return (RecordNavigationInfo)ReadAction.compute(() -> {
            String name2 = recordComponent.getName();
            if (name2 == null) {
                return null;
            }
            PsiClass containingClass = recordComponent.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            List methods = ContainerUtil.filter((Object[])containingClass.findMethodsByName(name2, false), m -> m.getParameterList().isEmpty());
            if (methods.size() != 1) {
                return null;
            }
            PsiField field = containingClass.findFieldByName(name2, false);
            if (field == null) {
                return null;
            }
            PsiMethod compactConstructor = (PsiMethod)ContainerUtil.find((Object[])containingClass.getConstructors(), JavaPsiRecordUtil::isCompactConstructor);
            PsiParameter parameter2 = compactConstructor != null ? (PsiParameter)ContainerUtil.find((Object[])compactConstructor.getParameterList().getParameters(), p -> name2.equals(p.getName())) : null;
            return new RecordNavigationInfo((PsiMethod)methods.get(0), field, parameter2, name2);
        });
    }

    private static class RecordNavigationInfo {
        @NotNull
        final PsiMethod myLightMethod;
        @NotNull
        final PsiField myLightField;
        @Nullable
        final PsiParameter myLightCompactConstructorParameter;
        @NotNull
        final String myName;

        private RecordNavigationInfo(@NotNull PsiMethod lightMethod, @NotNull PsiField lightField, @Nullable PsiParameter parameter2, @NotNull String name2) {
            this.myLightMethod = lightMethod;
            this.myLightField = lightField;
            this.myLightCompactConstructorParameter = parameter2;
            this.myName = name2;
        }
    }
}

