/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AllClassesSearchExecutor
implements QueryExecutor<PsiClass, AllClassesSearch.SearchParameters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(@NotNull AllClassesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiClass> consumer) {
        PsiElement[] scopeRoots;
        SearchScope scope = queryParameters.getScope();
        if (scope == GlobalSearchScope.EMPTY_SCOPE) {
            return true;
        }
        if (scope instanceof GlobalSearchScope) {
            PsiManager manager = PsiManager.getInstance((Project)queryParameters.getProject());
            manager.startBatchFilesProcessingMode();
            try {
                boolean bl = AllClassesSearchExecutor.processAllClassesInGlobalScope((GlobalSearchScope)scope, queryParameters, consumer);
                return bl;
            }
            finally {
                manager.finishBatchFilesProcessingMode();
            }
        }
        for (PsiElement scopeRoot : scopeRoots = ((LocalSearchScope)scope).getScope()) {
            if (AllClassesSearchExecutor.processScopeRootForAllClasses(scopeRoot, consumer)) continue;
            return false;
        }
        return true;
    }

    private static boolean processAllClassesInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull AllClassesSearch.SearchParameters parameters2, @NotNull Processor<? super PsiClass> processor2) {
        THashSet names2 = new THashSet(10000);
        AllClassesSearchExecutor.processClassNames(parameters2.getProject(), scope, (Processor<? super String>)((Processor)arg_0 -> AllClassesSearchExecutor.lambda$processAllClassesInGlobalScope$0(parameters2, (Set)names2, arg_0)));
        ArrayList<String> sorted = new ArrayList<String>((Collection<String>)names2);
        sorted.sort(String.CASE_INSENSITIVE_ORDER);
        return AllClassesSearchExecutor.processClassesByNames(parameters2.getProject(), scope, sorted, processor2);
    }

    public static boolean processClassesByNames(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Collection<String> names2, @NotNull Processor<? super PsiClass> processor2) {
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
        for (String name2 : names2) {
            ProgressIndicatorProvider.checkCanceled();
            for (PsiClass psiClass : (PsiClass[])DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> cache.getClassesByName(name2, scope))) {
                ProgressIndicatorProvider.checkCanceled();
                if (processor2.process((Object)psiClass)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processClassNames(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Processor<? super String> processor2) {
        boolean success = (Boolean)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> PsiShortNamesCache.getInstance((Project)project).processAllClassNames(s -> {
            ProgressManager.checkCanceled();
            return processor2.process(s);
        }, scope, IdFilter.getProjectIdFilter((Project)project, (boolean)true)));
        ProgressManager.checkCanceled();
        return success;
    }

    private static boolean processScopeRootForAllClasses(@NotNull PsiElement scopeRoot, final @NotNull Processor<? super PsiClass> processor2) {
        final boolean[] stopped = new boolean[]{false};
        Object visitor2 = scopeRoot instanceof PsiCompiledElement ? new JavaRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor2.process((Object)aClass);
                super.visitClass(aClass);
            }
        } : new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor2.process((Object)aClass);
                super.visitClass(aClass);
            }
        };
        ApplicationManager.getApplication().runReadAction(() -> AllClassesSearchExecutor.lambda$processScopeRootForAllClasses$4(scopeRoot, (JavaElementVisitor)visitor2));
        return !stopped[0];
    }

    private static /* synthetic */ void lambda$processScopeRootForAllClasses$4(PsiElement scopeRoot, JavaElementVisitor visitor2) {
        scopeRoot.accept((PsiElementVisitor)visitor2);
    }

    private static /* synthetic */ boolean lambda$processAllClassesInGlobalScope$0(AllClassesSearch.SearchParameters parameters2, Set names2, String s) {
        if (parameters2.nameMatches(s)) {
            names2.add(s);
        }
        return true;
    }
}

