/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.migration;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.migration.PsiMigrationImpl;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MigrationElementFinder
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;

    public MigrationElementFinder(Project project) {
        this.myProject = project;
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            return migration.getMigrationClass(qualifiedName);
        }
        return null;
    }

    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass migrationClass;
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null && (migrationClass = migration.getMigrationClass(qualifiedName)) != null) {
            return new PsiClass[]{migrationClass};
        }
        return PsiClass.EMPTY_ARRAY;
    }

    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            List<PsiClass> classes2 = migration.getMigrationClasses(psiPackage.getQualifiedName());
            return classes2.toArray(PsiClass.EMPTY_ARRAY);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            List<PsiPackage> packages = migration.getMigrationPackages(psiPackage.getQualifiedName());
            return packages.toArray(PsiPackage.EMPTY_ARRAY);
        }
        return PsiPackage.EMPTY_ARRAY;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        PsiMigrationImpl migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration();
        if (migration != null) {
            return migration.getMigrationPackage(qualifiedName);
        }
        return null;
    }
}

