/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;

public class LightReferenceParameterList
extends LightElement
implements PsiReferenceParameterList {
    private final PsiTypeElement[] myTypeElements;
    private final String myText;

    public LightReferenceParameterList(PsiManager manager, PsiTypeElement[] referenceElements) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myTypeElements = referenceElements;
        this.myText = this.calculateText();
    }

    private String calculateText() {
        if (this.myTypeElements.length == 0) {
            return "";
        }
        StringJoiner buffer = new StringJoiner(",", "<", ">");
        for (PsiTypeElement type2 : this.myTypeElements) {
            buffer.add(type2.getText());
        }
        return buffer.toString();
    }

    public String toString() {
        return "PsiReferenceParameterList";
    }

    public String getText() {
        return this.myText;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceParameterList((PsiReferenceParameterList)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public PsiElement copy() {
        PsiTypeElement[] elements = new PsiTypeElement[this.myTypeElements.length];
        for (int i = 0; i < this.myTypeElements.length; ++i) {
            PsiTypeElement typeElement = this.myTypeElements[i];
            elements[i] = (PsiTypeElement)typeElement.copy();
        }
        return new LightReferenceParameterList(this.myManager, elements);
    }

    public PsiTypeElement @NotNull [] getTypeParameterElements() {
        return this.myTypeElements;
    }

    public PsiType @NotNull [] getTypeArguments() {
        return PsiImplUtil.typesByTypeElements(this.myTypeElements);
    }
}

