/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPsiClassBase
extends LightElement
implements PsiClass,
SyntheticElement {
    @NotNull
    private final String myName;

    public LightPsiClassBase(@NotNull PsiElement context, @NotNull String name2) {
        this(context.getManager(), context.getLanguage(), name2);
    }

    public LightPsiClassBase(@NotNull PsiManager manager, @NotNull Language language, @NotNull String name2) {
        super(manager, language);
        this.myName = name2;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getQualifiedName() {
        PsiElement parent = this.getParent();
        if (parent instanceof PsiJavaFile) {
            return StringUtil.getQualifiedName((String)((PsiJavaFile)parent).getPackageName(), (String)this.getName());
        }
        if (parent instanceof PsiClass) {
            String parentQName = ((PsiClass)parent).getQualifiedName();
            if (parentQName == null) {
                return null;
            }
            return StringUtil.getQualifiedName((String)parentQName, (String)this.getName());
        }
        return null;
    }

    public String toString() {
        return "Light PSI class: " + this.getName();
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public PsiClassType @NotNull [] getExtendsListTypes() {
        return PsiClassImplUtil.getExtendsListTypes(this);
    }

    public PsiClassType @NotNull [] getImplementsListTypes() {
        return PsiClassImplUtil.getImplementsListTypes(this);
    }

    @Nullable
    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    public PsiClass @NotNull [] getInterfaces() {
        return PsiClassImplUtil.getInterfaces(this);
    }

    public PsiClass @NotNull [] getSupers() {
        return PsiClassImplUtil.getSupers(this);
    }

    public PsiClassType @NotNull [] getSuperTypes() {
        return PsiClassImplUtil.getSuperTypes(this);
    }

    public PsiMethod @NotNull [] getConstructors() {
        return PsiImplUtil.getConstructors(this);
    }

    public PsiField @NotNull [] getAllFields() {
        return PsiClassImplUtil.getAllFields(this);
    }

    public PsiMethod @NotNull [] getAllMethods() {
        return PsiClassImplUtil.getAllMethods(this);
    }

    public PsiClass @NotNull [] getAllInnerClasses() {
        return PsiClassImplUtil.getAllInnerClasses(this);
    }

    @Nullable
    public PsiField findFieldByName(@NonNls String name2, boolean checkBases) {
        return PsiClassImplUtil.findFieldByName(this, name2, checkBases);
    }

    @Nullable
    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    public PsiMethod @NotNull [] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
    }

    public PsiMethod @NotNull [] findMethodsByName(@NonNls String name2, boolean checkBases) {
        return PsiClassImplUtil.findMethodsByName(this, name2, checkBases);
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NonNls String name2, boolean checkBases) {
        return PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name2, checkBases);
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        return PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiClassImplUtil.MemberType.METHOD);
    }

    @Nullable
    public PsiClass findInnerClassByName(@NonNls String name2, boolean checkBases) {
        return PsiClassImplUtil.findInnerByName(this, name2, checkBases);
    }

    @Nullable
    public PsiElement getLBrace() {
        return null;
    }

    @Nullable
    public PsiElement getRBrace() {
        return null;
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    public boolean isInheritorDeep(PsiClass baseClass, @Nullable PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        return PsiSuperMethodImplUtil.getVisibleSignatures(this);
    }

    public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot rename light class");
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    public PsiTypeParameter @NotNull [] getTypeParameters() {
        return PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
    }

    @NotNull
    public abstract PsiModifierList getModifierList();

    public boolean hasModifierProperty(@PsiModifier.ModifierConstant @NonNls @NotNull String name2) {
        return this.getModifierList().hasModifierProperty(name2);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        return PsiClassImplUtil.processDeclarationsInClass(this, processor2, state, null, lastParent, place, PsiUtil.getLanguageLevel((PsiElement)place), false);
    }
}

