/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightReferenceParameterList;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

abstract class LightClassReferenceBase
extends LightElement
implements PsiJavaCodeReferenceElement {
    protected final String myText;
    private LightReferenceParameterList myParameterList;

    protected LightClassReferenceBase(@NotNull PsiManager manager, @NotNull String text2) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myText = text2;
    }

    public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            return new JavaResolveResult[]{result};
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        throw new RuntimeException("Variants are not available for light references");
    }

    public PsiElement getReferenceNameElement() {
        return null;
    }

    public PsiReferenceParameterList getParameterList() {
        LightReferenceParameterList parameterList = this.myParameterList;
        if (parameterList == null) {
            this.myParameterList = parameterList = new LightReferenceParameterList(this.myManager, PsiTypeElement.EMPTY_ARRAY);
        }
        return parameterList;
    }

    public String getQualifiedName() {
        PsiClass psiClass = (PsiClass)this.resolve();
        if (psiClass != null) {
            return psiClass.getQualifiedName();
        }
        return null;
    }

    public String getText() {
        return this.myText;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public String getCanonicalText() {
        String name2 = this.getQualifiedName();
        if (name2 == null) {
            return "";
        }
        PsiType[] types = this.getTypeParameters();
        if (types.length == 0) {
            return name2;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(name2);
        buf.append('<');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(types[i].getCanonicalText());
        }
        buf.append('>');
        return buf.toString();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + this.getText();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        return element instanceof PsiClass && this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    public Object @NotNull [] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @NotNull
    public PsiElement getElement() {
        return this;
    }

    public PsiType @NotNull [] getTypeParameters() {
        return PsiType.EMPTY_ARRAY;
    }

    public PsiElement getQualifier() {
        return null;
    }

    public boolean isQualified() {
        return false;
    }
}

