/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionElementType;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class MethodReferenceElementType
extends FunctionalExpressionElementType<PsiMethodReferenceExpression> {
    private static final NotNullLazyValue<TokenSet> EXCLUDE_FROM_PRESENTABLE_TEXT = new NotNullLazyValue<TokenSet>(){

        @NotNull
        protected TokenSet compute() {
            return TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.REFERENCE_PARAMETER_LIST})});
        }
    };

    public MethodReferenceElementType() {
        super("METHOD_REF_EXPRESSION");
    }

    @Override
    public PsiMethodReferenceExpression createPsi(@NotNull ASTNode node) {
        return new PsiMethodReferenceExpressionImpl(node);
    }

    public PsiMethodReferenceExpression createPsi(@NotNull FunctionalExpressionStub<PsiMethodReferenceExpression> stub) {
        return new PsiMethodReferenceExpressionImpl(stub);
    }

    @NotNull
    public ASTNode createCompositeNode() {
        return new CompositeElement((IElementType)this){

            public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
                super.replaceChildInternal(child, JavaSourceUtil.addParenthToReplacedChild(child, newElement, (PsiManager)this.getManager()));
            }

            public int getChildRole(@NotNull ASTNode child) {
                IElementType elType = child.getElementType();
                if (elType == JavaTokenType.DOUBLE_COLON) {
                    return 253;
                }
                if (elType == JavaTokenType.IDENTIFIER) {
                    return 53;
                }
                if (elType == JavaElementType.REFERENCE_EXPRESSION) {
                    return 119;
                }
                return 64;
            }
        };
    }

    @Override
    @NotNull
    protected String getPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode funExpr) {
        return LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)funExpr, (TokenSet)((TokenSet)EXCLUDE_FROM_PRESENTABLE_TEXT.getValue()));
    }
}

