/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import com.intellij.psi.impl.java.stubs.impl.PsiImportStatementStubImpl;
import com.intellij.psi.impl.source.PsiImportStatementImpl;
import com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.java.ImportStaticStatementElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaImportStatementElementType
extends JavaStubElementType<PsiImportStatementStub, PsiImportStatementBase> {
    public JavaImportStatementElementType(@NonNls @NotNull String id) {
        super(id);
    }

    public PsiImportStatementBase createPsi(@NotNull PsiImportStatementStub stub) {
        return this.getPsiFactory(stub).createImportStatement(stub);
    }

    @Override
    public PsiImportStatementBase createPsi(@NotNull ASTNode node) {
        if (node instanceof ImportStaticStatementElement) {
            return new PsiImportStaticStatementImpl(node);
        }
        return new PsiImportStatementImpl(node);
    }

    @NotNull
    public PsiImportStatementStub createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement parentStub) {
        boolean isOnDemand = false;
        String refText = null;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type2 = child.getTokenType();
            if (type2 == JavaElementType.JAVA_CODE_REFERENCE || type2 == JavaElementType.IMPORT_STATIC_REFERENCE) {
                refText = JavaSourceUtil.getReferenceText(tree, child);
                continue;
            }
            if (type2 != JavaTokenType.DOT) continue;
            isOnDemand = true;
        }
        byte flags = PsiImportStatementStubImpl.packFlags(isOnDemand, node.getTokenType() == JavaElementType.IMPORT_STATIC_STATEMENT);
        return new PsiImportStatementStubImpl(parentStub, refText, flags);
    }

    public void serialize(@NotNull PsiImportStatementStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeByte((int)((PsiImportStatementStubImpl)stub).getFlags());
        dataStream.writeName(stub.getImportReferenceText());
    }

    @NotNull
    public PsiImportStatementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        byte flags = dataStream.readByte();
        String refText = dataStream.readNameString();
        return new PsiImportStatementStubImpl(parentStub, refText, flags);
    }

    public void indexStub(@NotNull PsiImportStatementStub stub, @NotNull IndexSink sink) {
    }
}

