/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsParameterListImpl
extends ClsRepositoryPsiElement<PsiParameterListStub>
implements PsiParameterList {
    public ClsParameterListImpl(@NotNull PsiParameterListStub stub) {
        super(stub);
    }

    public PsiParameter @NotNull [] getParameters() {
        return (PsiParameter[])((PsiParameterListStub)this.getStub()).getChildrenByType((IElementType)JavaStubElementTypes.PARAMETER, PsiParameter.ARRAY_FACTORY);
    }

    public int getParameterIndex(@NotNull PsiParameter parameter2) {
        assert (parameter2.getParent() == this);
        return PsiImplUtil.getParameterIndex(parameter2, this);
    }

    public int getParametersCount() {
        return ((PsiParameterListStub)this.getStub()).getChildrenStubs().size();
    }

    @Nullable
    public PsiParameter getParameter(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index is negative: " + index);
        }
        int count = 0;
        for (StubElement child : ((PsiParameterListStub)this.getStub()).getChildrenStubs()) {
            if (child.getStubType() != JavaStubElementTypes.PARAMETER) continue;
            if (count == index) {
                return (PsiParameter)child.getPsi();
            }
            ++count;
        }
        return null;
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        buffer.append('(');
        PsiParameter[] parameters2 = this.getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            ClsParameterListImpl.appendText((PsiElement)parameters2[i], indentLevel, buffer);
        }
        buffer.append(')');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        this.setMirrorCheckingType(element, null);
        ClsParameterListImpl.setMirrors((PsiElement[])this.getParameters(), (PsiElement[])((PsiParameterList)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element)).getParameters());
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameterList((PsiParameterList)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiParameterList";
    }
}

