/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.indexing.FileContent;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<ClassFileDecompilers.Decompiler> {
    private static final Logger LOG = Logger.getInstance(ClassFileStubBuilder.class);
    public static final int STUB_VERSION = 23;

    public boolean acceptsFile(@NotNull VirtualFile file) {
        return true;
    }

    @NotNull
    public Stream<ClassFileDecompilers.Decompiler> getAllSubBuilders() {
        return ClassFileDecompilers.getInstance().EP_NAME.extensions().filter(decompiler -> decompiler instanceof ClassFileDecompilers.Full);
    }

    @Nullable
    public ClassFileDecompilers.Decompiler getSubBuilder(@NotNull FileContent fileContent) {
        fileContent.getFile().setPreloadedContentHint(fileContent.getContent());
        try {
            ClassFileDecompilers.Decompiler decompiler = ClassFileDecompilers.getInstance().find(fileContent.getFile());
            return decompiler;
        }
        finally {
            fileContent.getFile().setPreloadedContentHint(null);
        }
    }

    @NotNull
    public String getSubBuilderVersion(@Nullable ClassFileDecompilers.Decompiler decompiler) {
        if (decompiler == null) {
            return "default";
        }
        int version = decompiler instanceof ClassFileDecompilers.Full ? ((ClassFileDecompilers.Full)decompiler).getStubBuilder().getStubVersion() : 0;
        return decompiler.getClass().getName() + ":" + version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Stub buildStubTree(@NotNull FileContent fileContent, @Nullable ClassFileDecompilers.Decompiler decompiler) {
        fileContent.getFile().setPreloadedContentHint(fileContent.getContent());
        try {
            VirtualFile file = fileContent.getFile();
            try {
                if (decompiler instanceof ClassFileDecompilers.Full) {
                    PsiFileStub psiFileStub = ((ClassFileDecompilers.Full)decompiler).getStubBuilder().buildFileStub(fileContent);
                    return psiFileStub;
                }
            }
            catch (ClsFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(file.getPath(), (Throwable)e);
                }
                LOG.info(file.getPath() + ": " + e.getMessage());
            }
            try {
                PsiJavaFileStub stub = ClsFileImpl.buildFileStub(file, fileContent.getContent());
                if (stub == null && fileContent.getFileName().indexOf(36) < 0) {
                    LOG.info("No stub built for the file " + fileContent);
                }
                PsiJavaFileStub psiJavaFileStub = stub;
                return psiJavaFileStub;
            }
            catch (ClsFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(file.getPath(), (Throwable)e);
                } else {
                    LOG.info(file.getPath() + ": " + e.getMessage());
                }
                Stub stub = null;
                fileContent.getFile().setPreloadedContentHint(null);
                return stub;
            }
        }
        finally {
            fileContent.getFile().setPreloadedContentHint(null);
        }
    }

    public int getStubVersion() {
        return 23;
    }
}

