/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmTypeDeclaration;
import com.intellij.lang.jvm.facade.JvmFacade;
import com.intellij.lang.jvm.facade.JvmFacadeImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.impl.IsConstantExpressionVisitor;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.HolderFactory;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.JavaDummyHolderFactory;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private static final Logger LOG = Logger.getInstance(JavaPsiFacadeImpl.class);
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final ConcurrentMap<String, PsiPackage> myPackageCache = ContainerUtil.createConcurrentSoftValueMap();
    private final ConcurrentMap<GlobalSearchScope, Map<String, PsiClass>> myClassCache = ContainerUtil.createConcurrentSoftKeySoftValueMap();
    private final Map<GlobalSearchScope, Map<String, Collection<PsiJavaModule>>> myModuleCache = ContainerUtil.createConcurrentSoftKeySoftValueMap();
    private final Project myProject;
    private final JavaFileManager myFileManager;
    private final AtomicNotNullLazyValue<JvmFacadeImpl> myJvmFacade;
    private final JvmPsiConversionHelper myConversionHelper;

    public JavaPsiFacadeImpl(Project project) {
        this.myProject = project;
        this.myFileManager = JavaFileManager.getInstance(this.myProject);
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        this.myJvmFacade = AtomicNotNullLazyValue.createValue(() -> (JvmFacadeImpl)JvmFacade.getInstance((Project)project));
        this.myConversionHelper = JvmPsiConversionHelper.getInstance((Project)this.myProject);
        project.getMessageBus().connect().subscribe(PsiModificationTracker.TOPIC, () -> {
            this.myClassCache.clear();
            this.myPackageCache.clear();
            this.myModuleCache.clear();
        });
        DummyHolderFactory.setFactory((HolderFactory)new JavaDummyHolderFactory());
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass result;
        ProgressIndicatorProvider.checkCanceled();
        Map map2 = (Map)this.myClassCache.get(scope);
        if (map2 == null) {
            map2 = ContainerUtil.createConcurrentWeakValueMap();
            map2 = (Map)ConcurrencyUtil.cacheOrGet(this.myClassCache, (Object)scope, (Object)map2);
        }
        if ((result = (PsiClass)map2.get(qualifiedName)) == null && (result = this.doFindClass(qualifiedName, scope)) != null) {
            map2.put(qualifiedName, result);
        }
        return result;
    }

    @Nullable
    private PsiClass doFindClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes2 = this.findClassesInDumbMode(qualifiedName, scope);
            if (classes2.length != 0) {
                return classes2[0];
            }
            return null;
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        for (PsiElementFinder finder : finders) {
            PsiClass aClass = finder.findClass(qualifiedName, scope);
            if (aClass == null || classesFilter != null && !classesFilter.value((Object)aClass)) continue;
            return aClass;
        }
        return null;
    }

    private PsiClass @NotNull [] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        String packageName = StringUtil.getPackageName((String)qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className2 = StringUtil.getShortName((String)qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope);
            if (containingClasses.length == 1) {
                return PsiElementFinder.filterByName((String)className2, (PsiClass[])containingClasses[0].getInnerClasses());
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        return pkg.findClassByShortName(className2, scope);
    }

    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        List<PsiClass> allClasses = this.findClassesWithJvmFacade(qualifiedName, scope);
        return allClasses.isEmpty() ? PsiClass.EMPTY_ARRAY : allClasses.toArray(PsiClass.EMPTY_ARRAY);
    }

    @NotNull
    private List<PsiClass> findClassesWithJvmFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        List<JvmClass> jvmClasses;
        ArrayList<Object> result = null;
        List<PsiClass> ownClasses = this.findClassesWithoutJvmFacade(qualifiedName, scope);
        if (!ownClasses.isEmpty()) {
            result = new ArrayList<PsiClass>(ownClasses);
        }
        if (!(jvmClasses = ((JvmFacadeImpl)this.myJvmFacade.getValue()).findClassesWithoutJavaFacade(qualifiedName, scope)).isEmpty()) {
            List jvmPsiClasses = ContainerUtil.map(jvmClasses, it -> this.myConversionHelper.convertTypeDeclaration((JvmTypeDeclaration)it));
            if (result == null) {
                result = new ArrayList(jvmPsiClasses);
            } else {
                result.addAll(jvmPsiClasses);
            }
        }
        return result == null ? Collections.emptyList() : result;
    }

    @NotNull
    public List<PsiClass> findClassesWithoutJvmFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (this.shouldUseSlowResolve()) {
            return Arrays.asList(this.findClassesInDumbMode(qualifiedName, scope));
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] finderClasses = finder.findClasses(qualifiedName, scope);
            if (finderClasses.length == 0) continue;
            if (result == null) {
                result = new ArrayList(finderClasses.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, finderClasses, result);
        }
        return result == null ? Collections.emptyList() : result;
    }

    private static Condition<PsiClass> getFilterFromFinders(@NotNull GlobalSearchScope scope, @NotNull List<PsiElementFinder> finders) {
        Condition filter = null;
        for (PsiElementFinder finder : finders) {
            Condition finderFilter = finder.getClassesFilter(scope);
            if (finderFilter == null) continue;
            filter = filter == null ? finderFilter : Conditions.and((Condition)filter, (Condition)finderFilter);
        }
        return filter;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance((Project)this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        return this.myConstantEvaluationHelper;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        PsiPackage aPackage = (PsiPackage)this.myPackageCache.get(qualifiedName);
        if (aPackage != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            aPackage = finder.findPackage(qualifiedName);
            if (aPackage == null) continue;
            return (PsiPackage)ConcurrencyUtil.cacheOrGet(this.myPackageCache, (Object)qualifiedName, (Object)aPackage);
        }
        return null;
    }

    public PsiJavaModule findModule(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        Collection<PsiJavaModule> modules = this.findModules(moduleName, scope);
        return modules.size() == 1 ? modules.iterator().next() : null;
    }

    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        return this.myModuleCache.computeIfAbsent(scope, k -> ContainerUtil.createConcurrentWeakValueMap()).computeIfAbsent(moduleName, k -> JavaFileManager.getInstance(this.myProject).findModules((String)k, scope));
    }

    @NotNull
    private List<PsiElementFinder> filteredFinders() {
        return DumbService.getInstance((Project)this.getProject()).filterByDumbAwareness((Collection)PsiElementFinder.EP.getPoint((AreaInstance)this.myProject).getExtensionList());
    }

    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        return this.getElementFactory();
    }

    @NotNull
    public PsiResolveHelper getResolveHelper() {
        return PsiResolveHelper.SERVICE.getInstance((Project)this.myProject);
    }

    @NotNull
    public PsiNameHelper getNameHelper() {
        return PsiNameHelper.getInstance((Project)this.myProject);
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        THashSet result = new THashSet();
        for (PsiElementFinder finder : this.filteredFinders()) {
            result.addAll(finder.getClassNames(psiPackage, scope));
        }
        return result;
    }

    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        List<PsiElementFinder> finders = this.filteredFinders();
        Condition<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope, finders);
        ArrayList result = null;
        for (PsiElementFinder finder : finders) {
            PsiClass[] classes2 = finder.getClasses(psiPackage, scope);
            if (classes2.length == 0) continue;
            if (result == null) {
                result = new ArrayList(classes2.length);
            }
            JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, classes2, result);
        }
        return result == null ? PsiClass.EMPTY_ARRAY : result.toArray(PsiClass.EMPTY_ARRAY);
    }

    private static void filterClassesAndAppend(PsiElementFinder finder, @Nullable Condition<? super PsiClass> classesFilter, PsiClass @NotNull [] classes2, @NotNull List<? super PsiClass> result) {
        for (PsiClass psiClass : classes2) {
            if (psiClass == null) {
                LOG.error("Finder " + finder + " returned null PsiClass");
                continue;
            }
            if (classesFilter != null && !classesFilter.value((Object)psiClass)) continue;
            result.add((PsiClass)psiClass);
        }
    }

    public PsiFile @NotNull [] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        Condition filter = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            Condition finderFilter = finder.getPackageFilesFilter(psiPackage, scope);
            if (finderFilter == null) continue;
            if (filter == null) {
                filter = finderFilter;
                continue;
            }
            filter = Conditions.and((Condition)filter, (Condition)finderFilter);
        }
        LinkedHashSet<PsiFile> result = new LinkedHashSet<PsiFile>();
        PsiDirectory[] directories = psiPackage.getDirectories(scope);
        for (PsiDirectory directory : directories) {
            for (PsiFile file : directory.getFiles()) {
                if (filter != null && !filter.value((Object)file)) continue;
                result.add(file);
            }
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            Collections.addAll(result, finder.getPackageFiles(psiPackage, scope));
        }
        return result.toArray(PsiFile.EMPTY_ARRAY);
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        for (PsiElementFinder finder : this.filteredFinders()) {
            if (finder.processPackageDirectories(psiPackage, scope, consumer, includeLibrarySources)) continue;
            return false;
        }
        return true;
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        LinkedHashMap<String, PsiPackage> result = new LinkedHashMap<String, PsiPackage>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            PsiPackage[] packages;
            for (PsiPackage aPackage : packages = finder.getSubPackages(psiPackage, scope)) {
                result.putIfAbsent(aPackage.getName(), aPackage);
            }
        }
        return result.values().toArray(PsiPackage.EMPTY_ARRAY);
    }

    public boolean isPartOfPackagePrefix(@NotNull String packageName) {
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!PsiNameHelper.isSubpackageOf((String)subpackageName, (String)packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        PsiFile file = FileContextUtil.getContextFile((PsiElement)element);
        if (file instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file).isInPackage(aPackage);
        }
        if (file instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        PsiFile file1 = FileContextUtil.getContextFile((PsiElement)element1);
        if (Comparing.equal((Object)file1, (Object)(file2 = FileContextUtil.getContextFile((PsiElement)element2)))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage((PsiElement)other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Objects.equals(package1, package2);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public boolean isConstantExpression(@NotNull PsiExpression expression2) {
        IsConstantExpressionVisitor visitor2 = new IsConstantExpressionVisitor();
        expression2.accept((PsiElementVisitor)visitor2);
        return visitor2.isConstant();
    }

    @NotNull
    public PsiElementFactory getElementFactory() {
        return PsiElementFactory.getInstance((Project)this.myProject);
    }
}

