/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.TextLineBlock;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBlockBlock
extends AbstractJavaBlock {
    private final Indent myIndent;

    public TextBlockBlock(ASTNode textBlock, Wrap wrap, AlignmentStrategy alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        super(textBlock, wrap, alignment, indent, settings, javaSettings, formattingMode);
        this.myIndent = indent;
    }

    protected List<Block> buildChildren() {
        if (this.getFormattingMode() != FormattingMode.REFORMAT) {
            return Collections.emptyList();
        }
        int offset = this.myNode.getStartOffset();
        Alignment alignment = this.createChildAlignment();
        List<TextRange> textRanges = this.extractLinesRanges();
        ArrayList<Block> children = new ArrayList<Block>(textRanges.size());
        for (int i = 0; i < textRanges.size(); ++i) {
            TextRange range = textRanges.get(i).shiftRight(offset);
            Indent indent = i == 0 ? Indent.getNoneIndent() : Indent.getContinuationIndent();
            children.add(new TextLineBlock(range, alignment, indent, null));
        }
        return children;
    }

    @NotNull
    private List<TextRange> extractLinesRanges() {
        PsiLiteralExpression literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)this.myNode.getPsi(), PsiLiteralExpression.class);
        if (literal == null || !literal.isTextBlock()) {
            return Collections.emptyList();
        }
        int indent = PsiLiteralUtil.getTextBlockIndent((PsiLiteralExpression)literal);
        if (indent == -1) {
            return Collections.emptyList();
        }
        String text2 = this.myNode.getText();
        ArrayList<TextRange> linesRanges = new ArrayList<TextRange>();
        int start = StringUtil.indexOf((CharSequence)text2, (char)'\n', (int)3);
        if (start == -1) {
            return Collections.emptyList();
        }
        linesRanges.add(new TextRange(0, start));
        ++start;
        while (start < text2.length()) {
            int end = StringUtil.indexOf((CharSequence)text2, (char)'\n', (int)start);
            if (end == -1) {
                end = text2.length();
            }
            if (start + indent < end) {
                start += indent;
            }
            if (start != end) {
                linesRanges.add(new TextRange(start, end));
            }
            start = end + 1;
        }
        return linesRanges;
    }

    @Override
    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        return null;
    }

    @Override
    public Indent getIndent() {
        return this.myIndent;
    }

    @Override
    public boolean isLeaf() {
        return this.getFormattingMode() != FormattingMode.REFORMAT;
    }
}

