/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import com.intellij.psi.controlFlow.GoToInstruction;
import org.jetbrains.annotations.NotNull;

public class ReturnInstruction
extends GoToInstruction {
    private static final Logger LOG = Logger.getInstance(ReturnInstruction.class);
    @NotNull
    private CallInstruction myCallInstruction;
    private boolean myRethrowFromFinally;

    public ReturnInstruction(int offset, @NotNull CallInstruction callInstruction) {
        super(offset, BranchingInstruction.Role.END, false);
        this.myCallInstruction = callInstruction;
    }

    @Override
    public String toString() {
        return "RETURN FROM " + this.getProcBegin() + (this.offset == 0 ? "" : " TO " + this.offset);
    }

    int @NotNull [] getPossibleReturnOffsets() {
        int[] nArray;
        if (this.offset == 0) {
            int[] nArray2 = new int[3];
            nArray2[0] = this.getProcBegin() - 5;
            nArray2[1] = this.getProcBegin() - 3;
            nArray = nArray2;
            nArray2[2] = this.getProcBegin() - 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = this.offset;
        }
        return nArray;
    }

    int getProcBegin() {
        return this.myCallInstruction.procBegin;
    }

    int getProcEnd() {
        return this.myCallInstruction.procEnd;
    }

    void setCallInstruction(@NotNull CallInstruction callInstruction) {
        this.myCallInstruction = callInstruction;
    }

    @Override
    public int nNext() {
        return this.offset == 0 ? 3 : 1;
    }

    @Override
    public int getNext(int index, int no) {
        if (this.offset == 0) {
            switch (no) {
                case 0: {
                    return this.getProcBegin() - 5;
                }
                case 1: {
                    return this.getProcBegin() - 3;
                }
                case 2: {
                    return this.getProcBegin() - 1;
                }
            }
            LOG.assertTrue(false);
            return -1;
        }
        if (no == 0) {
            return this.offset;
        }
        LOG.assertTrue(false);
        return -1;
    }

    @Override
    public void accept(@NotNull ControlFlowInstructionVisitor visitor2, int offset, int nextOffset) {
        visitor2.visitReturnInstruction(this, offset, nextOffset);
    }

    void setRethrowFromFinally() {
        this.myRethrowFromFinally = true;
    }

    boolean isRethrowFromFinally() {
        return this.myRethrowFromFinally;
    }
}

