/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactElementPresentation
extends TreeNodePresentation {
    private final ArtifactPointer myArtifactPointer;
    private final ArtifactEditorContext myContext;

    public ArtifactElementPresentation(ArtifactPointer artifactPointer, ArtifactEditorContext context) {
        this.myArtifactPointer = artifactPointer;
        this.myContext = context;
    }

    public String getPresentableName() {
        return this.myArtifactPointer != null ? this.myArtifactPointer.getArtifactName(this.myContext.getArtifactModel()) : "<unknown>";
    }

    public boolean canNavigateToSource() {
        return this.findArtifact() != null;
    }

    public void navigateToSource() {
        Artifact artifact = this.findArtifact();
        if (artifact != null) {
            this.myContext.selectArtifact(artifact);
        }
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        Artifact artifact = this.findArtifact();
        Icon icon = artifact != null ? artifact.getArtifactType().getIcon() : AllIcons.Nodes.Artifact;
        presentationData.setIcon(icon);
        presentationData.addText(this.getPresentableName(), artifact != null ? mainAttributes : SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    @Nullable
    private Artifact findArtifact() {
        return this.myArtifactPointer != null ? this.myArtifactPointer.findArtifact(this.myContext.getArtifactModel()) : null;
    }

    public int getWeight() {
        return 100;
    }
}

