/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LibraryElementType
extends ComplexPackagingElementType<LibraryPackagingElement> {
    public static final LibraryElementType LIBRARY_ELEMENT_TYPE = new LibraryElementType();

    LibraryElementType() {
        super("library", JavaCompilerBundle.message((String)"element.type.name.library.files", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return PlatformIcons.LIBRARY_ICON;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        return !LibraryElementType.getAllLibraries(context).isEmpty();
    }

    @NotNull
    public List<? extends LibraryPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        List selected = context.chooseLibraries(JavaCompilerBundle.message((String)"dialog.title.packaging.choose.library", (Object[])new Object[0]));
        ArrayList<LibraryPackagingElement> elements = new ArrayList<LibraryPackagingElement>();
        for (Library library : selected) {
            elements.add(new LibraryPackagingElement(library.getTable().getTableLevel(), library.getName(), null));
        }
        return elements;
    }

    private static List<Library> getAllLibraries(ArtifactEditorContext context) {
        ArrayList<Library> libraries2 = new ArrayList<Library>();
        ContainerUtil.addAll(libraries2, (Object[])LibraryTablesRegistrar.getInstance().getLibraryTable().getLibraries());
        ContainerUtil.addAll(libraries2, (Object[])LibraryTablesRegistrar.getInstance().getLibraryTable(context.getProject()).getLibraries());
        return libraries2;
    }

    @NotNull
    public LibraryPackagingElement createEmpty(@NotNull Project project) {
        return new LibraryPackagingElement();
    }

    public String getShowContentActionText() {
        return "Show Library Files";
    }
}

