/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactElementType
extends ComplexPackagingElementType<ArtifactPackagingElement> {
    public static final ArtifactElementType ARTIFACT_ELEMENT_TYPE = new ArtifactElementType();

    ArtifactElementType() {
        super("artifact", JavaCompilerBundle.message((String)"element.type.name.artifact", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return AllIcons.Nodes.Artifact;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        return !ArtifactElementType.getAvailableArtifacts(context, artifact, false).isEmpty();
    }

    @NotNull
    public List<? extends ArtifactPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        Project project = context.getProject();
        List artifacts = context.chooseArtifacts(ArtifactElementType.getAvailableArtifacts(context, artifact, false), JavaCompilerBundle.message((String)"dialog.title.choose.artifacts", (Object[])new Object[0]));
        ArrayList<ArtifactPackagingElement> elements = new ArrayList<ArtifactPackagingElement>();
        for (Artifact selected : artifacts) {
            elements.add(new ArtifactPackagingElement(project, ArtifactPointerManager.getInstance((Project)project).createPointer(selected, context.getArtifactModel())));
        }
        return elements;
    }

    @NotNull
    public static List<? extends Artifact> getAvailableArtifacts(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, boolean notIncludedOnly) {
        Set result = ContainerUtil.set((Object[])context.getArtifactModel().getArtifacts());
        if (notIncludedOnly) {
            ArtifactUtil.processPackagingElements(artifact, ARTIFACT_ELEMENT_TYPE, artifactPackagingElement -> {
                result.remove(artifactPackagingElement.findArtifact((PackagingElementResolvingContext)context));
                return true;
            }, (PackagingElementResolvingContext)context, true);
        }
        result.remove(artifact);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Artifact another = (Artifact)iterator.next();
            boolean notContainThis = ArtifactUtil.processPackagingElements(another, ARTIFACT_ELEMENT_TYPE, element -> !artifact.getName().equals(element.getArtifactName()), (PackagingElementResolvingContext)context, true);
            if (notContainThis) continue;
            iterator.remove();
        }
        ArrayList list = new ArrayList(result);
        list.sort(ArtifactManager.ARTIFACT_COMPARATOR);
        return list;
    }

    @NotNull
    public ArtifactPackagingElement createEmpty(@NotNull Project project) {
        return new ArtifactPackagingElement(project);
    }

    public String getShowContentActionText() {
        return "Show Content of Included Artifacts";
    }
}

